/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.DaylightDetector;
import org.bukkit.block.data.type.Dispenser;

public class MaterialSwitchable
implements Property {
    public static final String[] handledMechs = new String[]{"switched"};
    public MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && (((MaterialTag)material).getModernData() instanceof Powerable || ((MaterialTag)material).getModernData() instanceof Openable || ((MaterialTag)material).getModernData() instanceof Dispenser || ((MaterialTag)material).getModernData() instanceof DaylightDetector);
    }

    public static MaterialSwitchable getFrom(ObjectTag _material) {
        if (!MaterialSwitchable.describes(_material)) {
            return null;
        }
        return new MaterialSwitchable((MaterialTag)_material);
    }

    private MaterialSwitchable(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerTag("switched", (attribute, material) -> new ElementTag(material.getState()), new String[0]);
    }

    public boolean isPowerable() {
        return this.material.getModernData() instanceof Powerable;
    }

    public Powerable getPowerable() {
        return (Powerable)this.material.getModernData();
    }

    public boolean isOpenable() {
        return this.material.getModernData() instanceof Openable;
    }

    public boolean isDisepnser() {
        return this.material.getModernData() instanceof Dispenser;
    }

    public Openable getOpenable() {
        return (Openable)this.material.getModernData();
    }

    public Dispenser getDispenser() {
        return (Dispenser)this.material.getModernData();
    }

    public DaylightDetector getDaylightDetector() {
        return (DaylightDetector)this.material.getModernData();
    }

    public boolean getState() {
        if (this.isOpenable()) {
            return this.getOpenable().isOpen();
        }
        if (this.isPowerable()) {
            return this.getPowerable().isPowered();
        }
        if (this.isDisepnser()) {
            return this.getDispenser().isTriggered();
        }
        return this.getDaylightDetector().isInverted();
    }

    public void setState(boolean state) {
        if (this.isOpenable()) {
            this.getOpenable().setOpen(state);
        } else if (this.isPowerable()) {
            this.getPowerable().setPowered(state);
        } else if (this.isDisepnser()) {
            this.getDispenser().setTriggered(state);
        } else {
            this.getDaylightDetector().setInverted(state);
        }
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getState());
    }

    @Override
    public String getPropertyId() {
        return "switched";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("switched") && mechanism.requireBoolean()) {
            this.setState(mechanism.getValue().asBoolean());
        }
    }
}

