/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Conversion;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Collections;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class FireworkCommand
extends AbstractCommand {
    public FireworkCommand() {
        this.setName("firework");
        this.setSyntax("firework (<location>) (power:<#>) (<type>/random) (primary:<color>|...) (fade:<color>|...) (flicker) (trail)");
        this.setRequiredArguments(0, 7);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("random")) {
                scriptEntry.addObject("type", new ElementTag(FireworkEffect.Type.values()[CoreUtilities.getRandom().nextInt(FireworkEffect.Type.values().length)].name()));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matchesEnum((Enum<?>[])FireworkEffect.Type.values())) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("power") && arg.matchesInteger()) {
                scriptEntry.addObject("power", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("flicker") && arg.matches("flicker")) {
                scriptEntry.addObject("flicker", "");
                continue;
            }
            if (!scriptEntry.hasObject("trail") && arg.matches("trail")) {
                scriptEntry.addObject("trail", "");
                continue;
            }
            if (!scriptEntry.hasObject("primary") && arg.matchesPrefix("primary") && arg.matchesArgumentList(ColorTag.class)) {
                scriptEntry.addObject("primary", arg.asType(ListTag.class).filter(ColorTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("fade") && arg.matchesPrefix("fade") && arg.matchesArgumentList(ColorTag.class)) {
                scriptEntry.addObject("fade", arg.asType(ListTag.class).filter(ColorTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("location", Utilities.entryDefaultLocation(scriptEntry, false));
        scriptEntry.defaultObject("type", new ElementTag("ball"));
        scriptEntry.defaultObject("power", new ElementTag(1));
        scriptEntry.defaultObject("primary", Collections.singletonList(new ColorTag(Color.YELLOW)));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag location = scriptEntry.hasObject("location") ? (LocationTag)scriptEntry.getObject("location") : Utilities.getEntryNPC(scriptEntry).getLocation();
        ElementTag type = scriptEntry.getElement("type");
        ElementTag power = scriptEntry.getElement("power");
        boolean flicker = scriptEntry.hasObject("flicker");
        boolean trail = scriptEntry.hasObject("trail");
        List primary = (List)scriptEntry.getObject("primary");
        List fade = (List)scriptEntry.getObject("fade");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), location.debug() + type.debug() + power.debug() + (flicker ? ArgumentHelper.debugObj("flicker", flicker) : "") + (trail ? ArgumentHelper.debugObj("trail", trail) : "") + ArgumentHelper.debugObj("primary colors", primary.toString()) + (fade != null ? ArgumentHelper.debugObj("fade colors", fade.toString()) : ""));
        }
        Firework firework = (Firework)location.getWorld().spawn((Location)location, Firework.class);
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        fireworkMeta.setPower(power.asInt());
        FireworkEffect.Builder fireworkBuilder = FireworkEffect.builder();
        fireworkBuilder.with(FireworkEffect.Type.valueOf((String)type.asString().toUpperCase()));
        fireworkBuilder.withColor(Conversion.convertColors(primary));
        if (fade != null) {
            fireworkBuilder.withFade(Conversion.convertColors(fade));
        }
        if (flicker) {
            fireworkBuilder.withFlicker();
        }
        if (trail) {
            fireworkBuilder.withTrail();
        }
        fireworkMeta.addEffects(new FireworkEffect[]{fireworkBuilder.build()});
        firework.setFireworkMeta(fireworkMeta);
        scriptEntry.addObject("launched_firework", new EntityTag((Entity)firework));
    }
}

