/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.Sound;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.NotePlayEvent;

public class NoteBlockPlaysNoteScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static NoteBlockPlaysNoteScriptEvent instance;
    public NotePlayEvent event;
    public LocationTag location;

    public NoteBlockPlaysNoteScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("noteblock plays note");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!this.runGenericSwitchCheck(path, "instrument", this.event.getInstrument().name())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "NoteBlockPlaysNote";
    }

    public Sound getSound() {
        switch (this.event.getInstrument()) {
            case PIANO: {
                return Sound.BLOCK_NOTE_BLOCK_HARP;
            }
            case BASS_DRUM: {
                return Sound.BLOCK_NOTE_BLOCK_BASEDRUM;
            }
            case SNARE_DRUM: {
                return Sound.BLOCK_NOTE_BLOCK_SNARE;
            }
            case STICKS: {
                return Sound.BLOCK_NOTE_BLOCK_HAT;
            }
            case BASS_GUITAR: {
                return Sound.BLOCK_NOTE_BLOCK_BASS;
            }
            case FLUTE: {
                return Sound.BLOCK_NOTE_BLOCK_FLUTE;
            }
            case BELL: {
                return Sound.BLOCK_NOTE_BLOCK_BELL;
            }
            case GUITAR: {
                return Sound.BLOCK_NOTE_BLOCK_GUITAR;
            }
            case CHIME: {
                return Sound.BLOCK_NOTE_BLOCK_CHIME;
            }
            case XYLOPHONE: {
                return Sound.BLOCK_NOTE_BLOCK_XYLOPHONE;
            }
            case IRON_XYLOPHONE: {
                return Sound.BLOCK_NOTE_BLOCK_IRON_XYLOPHONE;
            }
            case COW_BELL: {
                return Sound.BLOCK_NOTE_BLOCK_COW_BELL;
            }
            case DIDGERIDOO: {
                return Sound.BLOCK_NOTE_BLOCK_DIDGERIDOO;
            }
            case BIT: {
                return Sound.BLOCK_NOTE_BLOCK_BIT;
            }
            case BANJO: {
                return Sound.BLOCK_NOTE_BLOCK_BANJO;
            }
            case PLING: {
                return Sound.BLOCK_NOTE_BLOCK_PLING;
            }
        }
        return null;
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "instrument": {
                return new ElementTag(this.event.getInstrument().name());
            }
            case "sound": {
                return new ElementTag(this.getSound().name());
            }
            case "tone": {
                return new ElementTag(this.event.getNote().getTone().name());
            }
            case "octave": {
                return new ElementTag(this.event.getNote().getOctave());
            }
            case "sharp": {
                return new ElementTag(this.event.getNote().isSharped());
            }
            case "pitch": {
                double pitch = Math.pow(2.0, (double)(this.event.getNote().getId() - 12) / 12.0);
                return new ElementTag(pitch);
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onNotePlay(NotePlayEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

