/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.plugin.Plugin;

public class ItemMoveScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ItemMoveScriptEvent instance;
    public dInventory origin;
    public dInventory destination;
    public dInventory initiator;
    public dItem item;
    public boolean itemSet;
    public InventoryMoveItemEvent event;

    public ItemMoveScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.contains("moves from");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String s = path.event;
        String lower = path.eventLower;
        String iCheck = CoreUtilities.getXthArg(0, lower);
        String oCheck = CoreUtilities.getXthArg(3, lower);
        String dCheck = CoreUtilities.getXthArg(5, lower);
        String originType = CoreUtilities.toLowerCase(this.origin.getInventoryType().name());
        String destinationType = CoreUtilities.toLowerCase(this.destination.getInventoryType().name());
        if (!this.tryItem(this.item, iCheck)) {
            return false;
        }
        if (!oCheck.equals(originType)) {
            return false;
        }
        return dCheck.length() <= 0 || dCheck.equals(destinationType);
    }

    @Override
    public String getName() {
        return "ItemMoves";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        InventoryMoveItemEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (dItem.matches(determination)) {
            this.item = dItem.valueOf(determination);
            this.itemSet = true;
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("origin")) {
            return this.origin;
        }
        if (name.equals("destination")) {
            return this.destination;
        }
        if (name.equals("initiator")) {
            return this.initiator;
        }
        if (name.equals("item")) {
            return this.item;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onInventoryMoveItemEvent(InventoryMoveItemEvent event) {
        this.origin = dInventory.mirrorBukkitInventory(event.getSource());
        this.destination = dInventory.mirrorBukkitInventory(event.getDestination());
        this.initiator = dInventory.mirrorBukkitInventory(event.getInitiator());
        this.item = new dItem(event.getItem());
        this.itemSet = false;
        this.cancelled = event.isCancelled();
        this.fire();
        event.setCancelled(this.cancelled);
        if (this.itemSet) {
            event.setItem(this.item.getItemStack());
        }
    }
}

