/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.FormatScriptContainer;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;

public class NarrateCommand
extends AbstractCommand {
    public NarrateCommand() {
        this.setName("narrate");
        this.setSyntax("narrate [<text>] (targets:<player>|...) (format:<script>) (per_player) (from:<uuid>)");
        this.setRequiredArguments(1, 5);
        this.setParseArgs(false);
        this.isProcedural = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : ArgumentHelper.interpret(scriptEntry, scriptEntry.getOriginalArguments())) {
            if (!scriptEntry.hasObject("format") && arg.matchesPrefix("format", "f")) {
                String formatStr = TagManager.tag(arg.getValue(), scriptEntry.getContext());
                FormatScriptContainer format = (FormatScriptContainer)ScriptRegistry.getScriptContainer(formatStr);
                if (format == null) {
                    Debug.echoError("Could not find format script matching '" + formatStr + "'");
                }
                scriptEntry.addObject("format", new ScriptTag(format));
                continue;
            }
            if (!scriptEntry.hasObject("targets") && arg.matchesPrefix("target", "targets", "t")) {
                scriptEntry.addObject("targets", ListTag.getListFor(TagManager.tagObject(arg.getValue(), scriptEntry.getContext()), scriptEntry.getContext()).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("from") && arg.matchesPrefix("from")) {
                scriptEntry.addObject("from", TagManager.tagObject(arg.getValue(), scriptEntry.getContext()));
                continue;
            }
            if (!scriptEntry.hasObject("per_player") && arg.matches("per_player")) {
                scriptEntry.addObject("per_player", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("text")) {
                scriptEntry.addObject("text", new ElementTag(arg.getRawValue()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("targets")) {
            scriptEntry.addObject("targets", Utilities.entryHasPlayer(scriptEntry) ? Collections.singletonList(Utilities.getEntryPlayer(scriptEntry)) : null);
        }
        if (!scriptEntry.hasObject("text")) {
            throw new InvalidArgumentsException("Missing any text!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        FormatScriptContainer format;
        if (scriptEntry.getResidingQueue().procedural) {
            Debug.echoError("'Narrate' should not be used in a procedure script. Consider the 'debug' command instead.");
        }
        List targets = (List)scriptEntry.getObject("targets");
        String text = scriptEntry.getElement("text").asString();
        ScriptTag formatObj = (ScriptTag)scriptEntry.getObjectTag("format");
        ElementTag perPlayerObj = scriptEntry.getElement("per_player");
        ElementTag from = scriptEntry.getElement("from");
        boolean perPlayer = perPlayerObj != null && perPlayerObj.asBoolean();
        BukkitTagContext context = (BukkitTagContext)scriptEntry.getContext();
        if (!perPlayer || targets == null) {
            text = TagManager.tag(text, context);
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("Narrating", text) + ArgumentHelper.debugList("Targets", targets) + (formatObj != null ? formatObj.debug() : "") + (perPlayerObj != null ? perPlayerObj.debug() : "") + (from != null ? from.debug() : ""));
        }
        UUID fromId = null;
        if (from != null) {
            fromId = from.asString().startsWith("p@") ? UUID.fromString(from.asString().substring("p@".length())) : UUID.fromString(from.asString());
        }
        FormatScriptContainer formatScriptContainer = format = formatObj == null ? null : (FormatScriptContainer)formatObj.getContainer();
        if (targets == null) {
            Bukkit.getServer().getConsoleSender().sendMessage(format != null ? format.getFormattedText(text, scriptEntry) : text);
            return;
        }
        for (PlayerTag player : targets) {
            if (player != null) {
                if (!player.isOnline()) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Player is offline, can't narrate to them. Skipping.");
                    continue;
                }
                String personalText = text;
                if (perPlayer) {
                    context.player = player;
                    personalText = TagManager.tag(personalText, context);
                }
                BaseComponent[] component = FormattedTextHelper.parse(format != null ? format.getFormattedText(personalText, scriptEntry) : personalText, ChatColor.WHITE);
                if (fromId == null) {
                    player.getPlayerEntity().spigot().sendMessage(component);
                    continue;
                }
                player.getPlayerEntity().spigot().sendMessage(ChatMessageType.CHAT, fromId, component);
                continue;
            }
            Debug.echoError("Narrated to non-existent player!?");
        }
    }
}

