/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemEnchantments
implements Property {
    public static final String[] handledTags = new String[]{"is_enchanted", "enchantments", "enchantment_map"};
    public static final String[] handledMechs = new String[]{"remove_enchantments", "enchantments"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag;
    }

    public static ItemEnchantments getFrom(ObjectTag _item) {
        if (!ItemEnchantments.describes(_item)) {
            return null;
        }
        return new ItemEnchantments((ItemTag)_item);
    }

    private ItemEnchantments(ItemTag _item) {
        this.item = _item;
    }

    public static String getName(Enchantment enchantment) {
        return enchantment.getKey().getKey();
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("is_enchanted")) {
            return new ElementTag(this.getEnchantments().size() > 0).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("enchantments.with_levels")) {
            Deprecations.itemEnchantmentTags.warn(attribute.context);
            Set<Map.Entry<Enchantment, Integer>> enchantments = this.getEnchantments();
            ListTag enchants = new ListTag();
            for (Map.Entry<Enchantment, Integer> enchantment : enchantments) {
                enchants.add(ItemEnchantments.getName(enchantment.getKey()) + "," + enchantment.getValue());
            }
            return enchants.getObjectAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("enchantments.levels")) {
            Deprecations.itemEnchantmentTags.warn(attribute.context);
            Set<Map.Entry<Enchantment, Integer>> enchantments = this.getEnchantments();
            ListTag enchants = new ListTag();
            for (Map.Entry<Enchantment, Integer> enchantment : enchantments) {
                enchants.add(String.valueOf(enchantment.getValue()));
            }
            return enchants.getObjectAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("enchantments.level") && attribute.hasContext(2)) {
            Deprecations.itemEnchantmentTags.warn(attribute.context);
            Set<Map.Entry<Enchantment, Integer>> enchantments = this.getEnchantments();
            if (enchantments.size() > 0) {
                for (Map.Entry<Enchantment, Integer> enchantment : enchantments) {
                    if (!enchantment.getKey().getName().equalsIgnoreCase(attribute.getContext(2)) && !ItemEnchantments.getName(enchantment.getKey()).equalsIgnoreCase(attribute.getContext(2))) continue;
                    return new ElementTag(enchantment.getValue()).getObjectAttribute(attribute.fulfill(2));
                }
            }
            return new ElementTag(0).getObjectAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("enchantments")) {
            Set<Map.Entry<Enchantment, Integer>> enchantments = this.getEnchantments();
            ListTag enchants = new ListTag();
            for (Map.Entry<Enchantment, Integer> enchantment : enchantments) {
                enchants.add(ItemEnchantments.getName(enchantment.getKey()));
            }
            return enchants.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("enchantment_map")) {
            return this.getEnchantmentMap().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public MapTag getEnchantmentMap() {
        MapTag enchants = new MapTag();
        for (Map.Entry<Enchantment, Integer> enchantment : this.getEnchantments()) {
            enchants.putObject(ItemEnchantments.getName(enchantment.getKey()), new ElementTag(enchantment.getValue()));
        }
        return enchants;
    }

    public Set<Map.Entry<Enchantment, Integer>> getEnchantments() {
        if (this.item.getItemStack().getEnchantments().size() > 0) {
            return this.item.getItemStack().getEnchantments().entrySet();
        }
        if (this.item.getItemMeta() instanceof EnchantmentStorageMeta) {
            return ((EnchantmentStorageMeta)this.item.getItemMeta()).getStoredEnchants().entrySet();
        }
        return new HashSet<Map.Entry<Enchantment, Integer>>();
    }

    @Override
    public String getPropertyString() {
        MapTag map = this.getEnchantmentMap();
        if (map.map.isEmpty()) {
            return null;
        }
        return map.toString();
    }

    @Override
    public String getPropertyId() {
        return "enchantments";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        block19: {
            Enchantment ench;
            if (mechanism.matches("remove_enchantments")) {
                HashSet<String> names = null;
                if (mechanism.hasValue()) {
                    names = new HashSet<String>();
                    for (String string : mechanism.valueAsType(ListTag.class)) {
                        names.add(CoreUtilities.toLowerCase(string));
                    }
                }
                if (this.item.getBukkitMaterial() == Material.ENCHANTED_BOOK) {
                    EnchantmentStorageMeta meta = (EnchantmentStorageMeta)this.item.getItemMeta();
                    for (Enchantment ench3 : new ArrayList(meta.getStoredEnchants().keySet())) {
                        if (names != null && !names.contains(CoreUtilities.toLowerCase(ench3.getName())) && !names.contains(CoreUtilities.toLowerCase(ItemEnchantments.getName(ench3)))) continue;
                        meta.removeStoredEnchant(ench3);
                    }
                    this.item.setItemMeta((ItemMeta)meta);
                } else {
                    for (Enchantment enchantment : new ArrayList(this.item.getItemStack().getEnchantments().keySet())) {
                        if (names != null && !names.contains(CoreUtilities.toLowerCase(enchantment.getName())) && !names.contains(CoreUtilities.toLowerCase(ItemEnchantments.getName(enchantment)))) continue;
                        this.item.getItemStack().removeEnchantment(enchantment);
                        this.item.resetCache();
                    }
                }
            }
            if (!mechanism.matches("enchantments")) break block19;
            if (mechanism.getValue().asString().startsWith("map@")) {
                MapTag map = mechanism.valueAsType(MapTag.class);
                for (Map.Entry entry : map.map.entrySet()) {
                    ench = Utilities.getEnchantmentByName(((StringHolder)entry.getKey()).low);
                    int level = ((ObjectTag)entry.getValue()).asType(ElementTag.class, mechanism.context).asInt();
                    if (ench != null) {
                        if (this.item.getBukkitMaterial() == Material.ENCHANTED_BOOK) {
                            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)this.item.getItemMeta();
                            meta.addStoredEnchant(ench, level, true);
                            this.item.setItemMeta((ItemMeta)meta);
                            continue;
                        }
                        this.item.getItemStack().addUnsafeEnchantment(ench, level);
                        this.item.resetCache();
                        continue;
                    }
                    mechanism.echoError("Unknown enchantment '" + ((StringHolder)entry.getKey()).str + "'");
                }
            } else {
                for (String enchant : mechanism.valueAsType(ListTag.class)) {
                    if (!enchant.contains(",")) {
                        mechanism.echoError("Invalid enchantment format, use name,level|...");
                        continue;
                    }
                    String[] stringArray = enchant.split(",", 2);
                    try {
                        ench = Utilities.getEnchantmentByName(stringArray[0]);
                        if (ench != null) {
                            if (this.item.getBukkitMaterial() == Material.ENCHANTED_BOOK) {
                                EnchantmentStorageMeta meta = (EnchantmentStorageMeta)this.item.getItemMeta();
                                meta.addStoredEnchant(ench, Integer.valueOf(stringArray[1]).intValue(), true);
                                this.item.setItemMeta((ItemMeta)meta);
                                continue;
                            }
                            this.item.getItemStack().addUnsafeEnchantment(ench, Integer.valueOf(stringArray[1]).intValue());
                            this.item.resetCache();
                            continue;
                        }
                        mechanism.echoError("Unknown enchantment '" + stringArray[0] + "'");
                    }
                    catch (NullPointerException e) {
                        mechanism.echoError("Unknown enchantment '" + stringArray[0] + "'");
                    }
                    catch (NumberFormatException ex) {
                        mechanism.echoError("Cannot apply enchantment '" + stringArray[0] + "': '" + stringArray[1] + "' is not a valid integer!");
                        if (!Debug.verbose) continue;
                        Debug.echoError(ex);
                    }
                }
            }
        }
    }
}

