/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.Collections;
import java.util.List;

public class AssignmentCommand
extends AbstractCommand {
    public AssignmentCommand() {
        this.setName("assignment");
        this.setSyntax("assignment [set/remove] (script:<name>) (to:<npc>|...)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesEnum(Action.values()) && !scriptEntry.hasObject("action")) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (arg.matchesArgumentType(ScriptTag.class) && !scriptEntry.hasObject("script")) {
                if (arg.asType(ScriptTag.class) != null && arg.asType(ScriptTag.class).getContainer() instanceof AssignmentScriptContainer) {
                    scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                    continue;
                }
                throw new InvalidArgumentsException("Script specified is not an 'assignment-type' container.");
            }
            if (!scriptEntry.hasObject("npcs") && arg.matchesArgumentList(NPCTag.class)) {
                scriptEntry.addObject("npcs", arg.asType(ListTag.class).filter(NPCTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("npcs")) {
            if (!Utilities.entryHasNPC(scriptEntry)) {
                throw new InvalidArgumentsException("This command requires a linked NPC!");
            }
            scriptEntry.addObject("npcs", Collections.singletonList(Utilities.getEntryNPC(scriptEntry)));
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action!");
        }
        if (scriptEntry.getObject("action").equals((Object)Action.SET) && !scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Script specified was missing or invalid.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        List npcs = (List)scriptEntry.getObject("npcs");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("action", (Object)action) + (script != null ? script.debug() : "") + ArgumentHelper.debugList("npc", npcs));
        }
        for (NPCTag npc : npcs) {
            if (action.equals((Object)Action.SET)) {
                ((AssignmentTrait)npc.getCitizen().getOrAddTrait(AssignmentTrait.class)).setAssignment(script.getName(), Utilities.getEntryPlayer(scriptEntry));
                continue;
            }
            if (!action.equals((Object)Action.REMOVE)) continue;
            ((AssignmentTrait)npc.getCitizen().getOrAddTrait(AssignmentTrait.class)).removeAssignment(Utilities.getEntryPlayer(scriptEntry));
        }
    }

    private static enum Action {
        SET,
        REMOVE;

    }
}

