/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.LingeringPotionSplashEvent;

public class LingeringPotionSplashScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static LingeringPotionSplashScriptEvent instance;
    public LingeringPotionSplashEvent event;
    public LocationTag location;
    public ItemTag item;

    public LingeringPotionSplashScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(0).equals("lingering")) {
            return false;
        }
        String cmd = path.eventArgLowerAt(2);
        if (!cmd.equals("splash") && !cmd.equals("splashes")) {
            return false;
        }
        return this.couldMatchItem(path.eventArgLowerAt(1));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String iTest = CoreUtilities.getXthArg(1, path.event);
        if (!this.tryItem(this.item, iTest)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "LingeringPotionSplash";
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "radius": {
                return new ElementTag(this.event.getAreaEffectCloud().getRadius());
            }
            case "duration": {
                return new DurationTag((long)this.event.getAreaEffectCloud().getDuration());
            }
            case "potion": {
                return this.item;
            }
            case "entity": {
                return new EntityTag((Entity)this.event.getEntity());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onLingeringPotionSplash(LingeringPotionSplashEvent event) {
        this.item = new ItemTag(event.getEntity().getItem());
        this.location = new LocationTag(event.getAreaEffectCloud().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

