/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.scripts.commands.world.ModifyBlockCommand;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public class AdjustBlockCommand
extends AbstractCommand {
    public AdjustBlockCommand() {
        this.setName("adjustblock");
        this.setSyntax("adjustblock [<location>|...] [<mechanism>](:<value>) (no_physics)");
        this.setRequiredArguments(2, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("locations") && arg.matchesArgumentList(LocationTag.class)) {
                scriptEntry.addObject("locations", arg.asType(ListTag.class).filter(LocationTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("no_physics") && arg.matches("no_physics")) {
                scriptEntry.addObject("no_physics", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("mechanism")) {
                if (arg.hasPrefix()) {
                    scriptEntry.addObject("mechanism", new ElementTag(arg.getPrefix().getValue()));
                    scriptEntry.addObject("mechanism_value", arg.object);
                    continue;
                }
                scriptEntry.addObject("mechanism", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("locations")) {
            throw new InvalidArgumentsException("You must specify a location!");
        }
        if (!scriptEntry.hasObject("mechanism")) {
            throw new InvalidArgumentsException("You must specify a mechanism!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag mechanismName = scriptEntry.getElement("mechanism");
        ObjectTag value = (ObjectTag)scriptEntry.getObjectTag("mechanism_value");
        ElementTag noPhysics = scriptEntry.getElement("no_physics");
        List locations = (List)scriptEntry.getObject("locations");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugList("locations", locations) + mechanismName.debug() + (noPhysics == null ? "" : noPhysics.debug()) + (value == null ? "" : value.debug()));
        }
        boolean doPhysics = noPhysics == null || !noPhysics.asBoolean();
        for (LocationTag location : locations) {
            Block block = location.getBlock();
            BlockData data = block.getBlockData();
            MaterialTag specialMaterial = new MaterialTag(data);
            Mechanism mechanism = new Mechanism(mechanismName, value, scriptEntry.entryData.getTagContext());
            specialMaterial.safeAdjust(mechanism);
            if (doPhysics) {
                block.setBlockData(data, false);
                AdjustBlockCommand.applyPhysicsAt(location);
                continue;
            }
            ModifyBlockCommand.setBlock(block.getLocation(), specialMaterial, false, null);
        }
    }

    public static void applyPhysicsAt(Location location) {
        NMSHandler.getBlockHelper().applyPhysics(location);
        NMSHandler.getBlockHelper().applyPhysics(location.clone().add(1.0, 0.0, 0.0));
        NMSHandler.getBlockHelper().applyPhysics(location.clone().add(-1.0, 0.0, 0.0));
        NMSHandler.getBlockHelper().applyPhysics(location.clone().add(0.0, 0.0, 1.0));
        NMSHandler.getBlockHelper().applyPhysics(location.clone().add(0.0, 0.0, -1.0));
        NMSHandler.getBlockHelper().applyPhysics(location.clone().add(0.0, 1.0, 0.0));
        NMSHandler.getBlockHelper().applyPhysics(location.clone().add(0.0, -1.0, 0.0));
    }
}

