/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.material.MaterialDirectional;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.MaterialCompat;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;

public class SignCommand
extends AbstractCommand {
    public SignCommand() {
        this.setName("sign");
        this.setSyntax("sign (type:{automatic}/sign_post/wall_sign) (material:<material>) [<line>|...] [<location>] (direction:north/east/south/west)");
        this.setRequiredArguments(1, 5);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class).setPrefix("location"));
                continue;
            }
            if (!scriptEntry.hasObject("direction") && arg.matchesPrefix("direction", "dir")) {
                scriptEntry.addObject("direction", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("material") && arg.matchesPrefix("material") && arg.matchesArgumentType(MaterialTag.class)) {
                scriptEntry.addObject("material", arg.asType(MaterialTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("text")) {
                scriptEntry.addObject("text", arg.asType(ListTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a Sign location!");
        }
        if (!scriptEntry.hasObject("text")) {
            throw new InvalidArgumentsException("Must specify sign text!");
        }
        scriptEntry.defaultObject("type", new ElementTag(Type.AUTOMATIC.name()));
    }

    public void setWallSign(Block sign, BlockFace bf, MaterialTag material) {
        sign.setType(material == null ? Material.OAK_WALL_SIGN : material.getMaterial(), false);
        MaterialTag signMaterial = new MaterialTag(sign);
        MaterialDirectional.getFrom(signMaterial).setFacing(bf);
        sign.setBlockData(signMaterial.getModernData());
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        BlockFace bf;
        String direction = scriptEntry.hasObject("direction") ? ((ElementTag)scriptEntry.getObject("direction")).asString() : null;
        ElementTag typeElement = scriptEntry.getElement("type");
        ListTag text = (ListTag)scriptEntry.getObjectTag("text");
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        MaterialTag material = (MaterialTag)scriptEntry.getObjectTag("material");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), typeElement.debug() + location.debug() + (direction == null ? "" : ArgumentHelper.debugObj("direction", direction)) + (material == null ? "" : material.debug()) + text.debug());
        }
        Type type = Type.valueOf(typeElement.asString().toUpperCase());
        Block sign = location.getBlock();
        if (type != Type.AUTOMATIC || !MaterialCompat.isAnySign(sign.getType())) {
            if (type == Type.WALL_SIGN) {
                bf = direction != null ? Utilities.chooseSignRotation(direction) : Utilities.chooseSignRotation(sign);
                this.setWallSign(sign, bf, material);
            } else {
                sign.setType(material == null ? Material.OAK_SIGN : material.getMaterial(), false);
                if (direction != null) {
                    Utilities.setSignRotation(sign.getState(), direction);
                }
            }
        } else if (!MaterialCompat.isAnySign(sign.getType())) {
            if (sign.getRelative(BlockFace.DOWN).getType().isSolid()) {
                sign.setType(material == null ? Material.OAK_SIGN : material.getMaterial(), false);
            } else {
                bf = Utilities.chooseSignRotation(sign);
                this.setWallSign(sign, bf, material);
            }
        }
        BlockState signState = sign.getState();
        Utilities.setSignLines((Sign)signState, text.toArray(new String[4]));
    }

    private static enum Type {
        AUTOMATIC,
        SIGN_POST,
        WALL_SIGN;

    }
}

