/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.item;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;

public class ItemMoveScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ItemMoveScriptEvent instance;
    public InventoryTag origin;
    public InventoryTag destination;
    public ItemTag item;
    public InventoryMoveItemEvent event;

    public ItemMoveScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("moves") || !path.eventArgLowerAt(2).equals("from")) {
            return false;
        }
        if (!this.couldMatchItem(path.eventArgLowerAt(0))) {
            return false;
        }
        return this.couldMatchInventory(path.eventArgLowerAt(3));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryItem(this.item, CoreUtilities.getXthArg(0, path.eventLower))) {
            return false;
        }
        if (!this.tryInventory(this.origin, CoreUtilities.getXthArg(3, path.eventLower))) {
            return false;
        }
        if (CoreUtilities.xthArgEquals(4, path.eventLower, "to") && !this.tryInventory(this.destination, CoreUtilities.getXthArg(5, path.eventLower))) {
            return false;
        }
        if (!this.runInCheck(path, this.origin.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "ItemMoves";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (ItemTag.matches(determination)) {
            this.item = ItemTag.valueOf(determination, path.container);
            this.event.setItem(this.item.getItemStack());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "origin": {
                return this.origin;
            }
            case "destination": {
                return this.destination;
            }
            case "initiator": {
                return InventoryTag.mirrorBukkitInventory(this.event.getInitiator());
            }
            case "item": {
                return this.item;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onInventoryMoveItemEvent(InventoryMoveItemEvent event) {
        this.event = event;
        this.origin = InventoryTag.mirrorBukkitInventory(event.getSource());
        this.destination = InventoryTag.mirrorBukkitInventory(event.getDestination());
        this.item = new ItemTag(event.getItem());
        this.fire((Event)event);
    }
}

