/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.interfaces.EntityAnimation;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.interfaces.FakePlayer;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.npc.traits.MirrorTrait;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.properties.entity.EntityAge;
import com.denizenscript.denizen.objects.properties.entity.EntityColor;
import com.denizenscript.denizen.objects.properties.entity.EntityTame;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptHelper;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizen.utilities.entity.Position;
import com.denizenscript.denizen.utilities.flags.DataPersistenceFlagTracker;
import com.denizenscript.denizen.utilities.nbt.CustomNBT;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Villager;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class EntityTag
implements ObjectTag,
Adjustable,
EntityFormObject,
FlaggableObject,
Cloneable {
    public static HashSet<String> earlyValidMechanisms = new HashSet<String>(Arrays.asList("max_health", "health_data", "health", "visible", "armor_pose", "arms", "base_plate", "is_small", "marker", "velocity", "age", "is_using_riptide", "size"));
    private static final Map<UUID, Entity> rememberedEntities = new HashMap<UUID, Entity>();
    public Entity entity = null;
    public long cleanRateProtect = -60000L;
    public DenizenEntityType entity_type = null;
    private String data1 = null;
    private DespawnedEntity despawned_entity = null;
    private NPCTag npc = null;
    public UUID uuid = null;
    private String entityScript = null;
    public boolean isFake = false;
    public boolean isFakeValid = false;
    private String prefix = "Entity";
    public static ObjectTagProcessor<EntityTag> tagProcessor = new ObjectTagProcessor();
    private ArrayList<Mechanism> mechanisms = new ArrayList();

    public static void rememberEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        rememberedEntities.put(entity.getUniqueId(), entity);
    }

    public static void forgetEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        rememberedEntities.remove(entity.getUniqueId());
    }

    public static boolean isNPC(Entity entity) {
        return entity != null && entity.hasMetadata("NPC") && ((MetadataValue)entity.getMetadata("NPC").get(0)).asBoolean();
    }

    public static boolean isCitizensNPC(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (Depends.citizens == null) {
            return false;
        }
        if (!CitizensAPI.hasImplementation()) {
            return false;
        }
        if (!(entity instanceof NPCHolder)) {
            return false;
        }
        NPC npc = ((NPCHolder)entity).getNPC();
        return npc != null;
    }

    public static NPCTag getNPCFrom(Entity entity) {
        if (EntityTag.isCitizensNPC(entity)) {
            return NPCTag.fromEntity(entity);
        }
        return null;
    }

    public static boolean isPlayer(Entity entity) {
        return entity instanceof Player && !EntityTag.isNPC(entity);
    }

    public static PlayerTag getPlayerFrom(Entity entity) {
        if (EntityTag.isPlayer(entity)) {
            return PlayerTag.mirrorBukkitPlayer((OfflinePlayer)((Player)entity));
        }
        return null;
    }

    public ItemTag getItemInHand() {
        if (this.isLivingEntity() && this.getLivingEntity().getEquipment() != null) {
            ItemStack its = this.getLivingEntity().getEquipment().getItemInMainHand();
            if (its == null) {
                return null;
            }
            return new ItemTag(its.clone());
        }
        return null;
    }

    @Deprecated
    public static EntityTag valueOf(String string) {
        return EntityTag.valueOf(string, null);
    }

    @Fetchable(value="e")
    public static EntityTag valueOf(String string, TagContext context) {
        Object entity3;
        if (string == null) {
            return null;
        }
        if (ObjectFetcher.isObjectWithProperties(string)) {
            return ObjectFetcher.getObjectFromWithProperties(EntityTag.class, string, context);
        }
        if (string.equalsIgnoreCase("RANDOM")) {
            EntityType randomType = null;
            while (randomType == null || randomType.name().matches("^(COMPLEX_PART|DROPPED_ITEM|ENDER_CRYSTAL|ENDER_DRAGON|FISHING_HOOK|ITEM_FRAME|LEASH_HITCH|LIGHTNING|PAINTING|PLAYER|UNKNOWN|WEATHER|WITHER|WITHER_SKULL)$")) {
                randomType = EntityType.values()[CoreUtilities.getRandom().nextInt(EntityType.values().length)];
            }
            return new EntityTag(randomType, "RANDOM");
        }
        if (string.startsWith("e@fake:")) {
            try {
                UUID entityID = UUID.fromString(string.substring("e@fake:".length()));
                FakeEntity entity2 = FakeEntity.idsToEntities.get(entityID);
                if (entity2 != null) {
                    return entity2.entity;
                }
                return null;
            }
            catch (Exception entityID) {
                // empty catch block
            }
        }
        if (string.startsWith("e@")) {
            string = string.substring("e@".length());
        }
        if (string.startsWith("n@")) {
            NPCTag npc = NPCTag.valueOf(string, context);
            if (npc != null) {
                if (npc.isSpawned()) {
                    return new EntityTag(npc);
                }
                if (context != null && context.showErrors()) {
                    Debug.echoDebug((Debuggable)context.entry, "NPC '" + string + "' is not spawned, errors may follow!");
                }
                return new EntityTag(npc);
            }
            Debug.echoError("NPC '" + string + "' does not exist!");
        } else if (string.startsWith("p@")) {
            Player returnable = PlayerTag.valueOf(string, context).getPlayerEntity();
            if (returnable != null) {
                return new EntityTag((Entity)returnable);
            }
            if (context == null || context.showErrors()) {
                Debug.echoError("Invalid Player! '" + string + "' could not be found. Has the player logged off?");
            }
        }
        UUID id = null;
        int slash = string.indexOf(47);
        if (slash != -1) {
            try {
                id = UUID.fromString(string.substring(0, slash));
                entity3 = EntityTag.getEntityForID(id);
                if (entity3 != null) {
                    return new EntityTag((Entity)entity3);
                }
                string = string.substring(slash + 1);
            }
            catch (Exception entity3) {
                // empty catch block
            }
        }
        if (ScriptRegistry.containsScript(string, EntityScriptContainer.class)) {
            entity3 = ScriptRegistry.getScriptContainerAs(string, EntityScriptContainer.class).getEntityFrom();
            entity3.uuid = id;
            return entity3;
        }
        List<String> data = CoreUtilities.split(string, ',');
        if (DenizenEntityType.isRegistered(data.get(0))) {
            EntityTag entity4 = new EntityTag(DenizenEntityType.getByName(data.get(0)), data.size() > 1 ? data.get(1) : null);
            entity4.uuid = id;
            return entity4;
        }
        try {
            UUID entityID = id != null ? id : UUID.fromString(string);
            Entity entity5 = EntityTag.getEntityForID(entityID);
            if (entity5 != null) {
                return new EntityTag(entity5);
            }
            return null;
        }
        catch (Exception exception) {
            if (context == null || context.showErrors()) {
                Debug.log("valueOf EntityTag returning null: " + string);
            }
            return null;
        }
    }

    public static Entity getEntityForID(UUID id) {
        if (rememberedEntities.containsKey(id)) {
            return rememberedEntities.get(id);
        }
        for (World world : Bukkit.getWorlds()) {
            Entity entity = NMSHandler.getEntityHelper().getEntity(world, id);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("n@") || arg.startsWith("e@") || arg.startsWith("p@")) {
            return true;
        }
        if ((arg = arg.replace("e@", "").toUpperCase()).equals("RANDOM")) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, EntityScriptContainer.class)) {
            return true;
        }
        return DenizenEntityType.isRegistered(CoreUtilities.split(arg, ',').get(0));
    }

    public EntityTag(Entity entity) {
        if (entity != null) {
            this.entity = entity;
            this.entityScript = EntityScriptHelper.getEntityScript(entity);
            this.uuid = entity.getUniqueId();
            this.entity_type = DenizenEntityType.getByEntity(entity);
            if (EntityTag.isCitizensNPC(entity)) {
                this.npc = EntityTag.getNPCFrom(entity);
            }
        } else {
            Debug.echoError("Entity referenced is null!");
        }
    }

    public EntityTag(EntityType entityType) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
        } else {
            Debug.echoError("Entity_type referenced is null!");
        }
    }

    public EntityTag(EntityType entityType, ArrayList<Mechanism> mechanisms) {
        this(entityType);
        this.mechanisms = mechanisms;
    }

    public EntityTag(EntityType entityType, String data1) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
            this.data1 = data1;
        } else {
            Debug.echoError("Entity_type referenced is null!");
        }
    }

    public EntityTag(DenizenEntityType entityType) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
        } else {
            Debug.echoError("DenizenEntityType referenced is null!");
        }
    }

    public EntityTag(DenizenEntityType entityType, ArrayList<Mechanism> mechanisms) {
        this(entityType);
        this.mechanisms = mechanisms;
    }

    public EntityTag(DenizenEntityType entityType, String data1) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
            this.data1 = data1;
        } else {
            Debug.echoError("DenizenEntityType referenced is null!");
        }
    }

    public EntityTag(NPCTag npc) {
        if (Depends.citizens == null) {
            return;
        }
        if (npc != null) {
            this.npc = npc;
            if (npc.isSpawned()) {
                this.entity = npc.getEntity();
                this.entity_type = DenizenEntityType.getByName(npc.getEntityType().name());
                this.uuid = this.entity.getUniqueId();
            }
        } else {
            Debug.echoError("NPC referenced is null!");
        }
    }

    @Override
    public EntityTag duplicate() {
        if (this.isUnique()) {
            return this;
        }
        try {
            EntityTag copy = (EntityTag)this.clone();
            if (copy.mechanisms != null) {
                copy.mechanisms = new ArrayList<Mechanism>(copy.mechanisms);
            }
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC().getFlagTracker();
        }
        if (this.isPlayer()) {
            return this.getDenizenPlayer().getFlagTracker();
        }
        Entity ent = this.getBukkitEntity();
        if (ent != null) {
            return new DataPersistenceFlagTracker((PersistentDataHolder)ent);
        }
        return null;
    }

    @Override
    public String getReasonNotFlaggable() {
        if (!this.isSpawned() || this.getBukkitEntity() == null) {
            return "the entity is not spawned";
        }
        return "unknown reason - something went wrong";
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
        if (this.cleanRateProtect + 60000L > DenizenCore.serverTimeMillis) {
            ((DataPersistenceFlagTracker)tracker).doTotalClean();
            this.cleanRateProtect = DenizenCore.serverTimeMillis;
        }
    }

    public DenizenEntityType getEntityType() {
        return this.entity_type;
    }

    public EntityType getBukkitEntityType() {
        return this.entity_type.getBukkitEntityType();
    }

    public void setEntityScript(String entityScript) {
        this.entityScript = entityScript;
    }

    public String getEntityScript() {
        return this.entityScript;
    }

    public UUID getUUID() {
        if (this.uuid == null && this.entity != null) {
            this.uuid = this.entity.getUniqueId();
        }
        return this.uuid;
    }

    @Override
    public EntityTag getDenizenEntity() {
        return this;
    }

    public EntityFormObject getDenizenObject() {
        if (this.entity == null && this.npc == null) {
            return null;
        }
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC();
        }
        if (this.isPlayer()) {
            return new PlayerTag(this.getPlayer());
        }
        return this;
    }

    public Entity getBukkitEntity() {
        return this.entity;
    }

    public LivingEntity getLivingEntity() {
        if (this.entity instanceof LivingEntity) {
            return (LivingEntity)this.entity;
        }
        return null;
    }

    public boolean isLivingEntity() {
        return this.entity instanceof LivingEntity;
    }

    public boolean hasInventory() {
        return this.getBukkitEntity() instanceof InventoryHolder || this.isCitizensNPC();
    }

    public NPCTag getDenizenNPC() {
        if (this.npc != null) {
            return this.npc;
        }
        return EntityTag.getNPCFrom(this.entity);
    }

    public boolean isNPC() {
        return this.npc != null || EntityTag.isNPC(this.entity);
    }

    public boolean isCitizensNPC() {
        return this.npc != null || EntityTag.isCitizensNPC(this.entity);
    }

    public Player getPlayer() {
        if (this.isPlayer()) {
            return (Player)this.entity;
        }
        return null;
    }

    public PlayerTag getDenizenPlayer() {
        if (this.isPlayer()) {
            return new PlayerTag(this.getPlayer());
        }
        return null;
    }

    public boolean isPlayer() {
        return this.entity instanceof Player && !this.isNPC();
    }

    public Projectile getProjectile() {
        return (Projectile)this.entity;
    }

    public boolean isProjectile() {
        return this.entity instanceof Projectile;
    }

    public EntityTag getShooter() {
        if (this.hasShooter()) {
            return new EntityTag((Entity)((LivingEntity)this.getProjectile().getShooter()));
        }
        return null;
    }

    public void setShooter(EntityTag shooter) {
        if (this.isProjectile() && shooter.isLivingEntity()) {
            this.getProjectile().setShooter((ProjectileSource)shooter.getLivingEntity());
        }
    }

    public boolean hasShooter() {
        return this.isProjectile() && this.getProjectile().getShooter() != null && this.getProjectile().getShooter() instanceof LivingEntity;
    }

    public Inventory getBukkitInventory() {
        if (this.hasInventory() && !this.isCitizensNPC()) {
            return ((InventoryHolder)this.getBukkitEntity()).getInventory();
        }
        return null;
    }

    public InventoryTag getInventory() {
        return this.hasInventory() ? (this.isCitizensNPC() ? this.getDenizenNPC().getDenizenInventory() : InventoryTag.mirrorBukkitInventory(this.getBukkitInventory())) : null;
    }

    public String getName() {
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC().getCitizen().getName();
        }
        if (this.entity instanceof FakePlayer) {
            return ((FakePlayer)this.entity).getFullName();
        }
        if (this.entity instanceof Player) {
            return this.entity.getName();
        }
        String customName = this.entity.getCustomName();
        if (customName != null) {
            return customName;
        }
        return this.entity_type.getName();
    }

    public ListTag getEquipment() {
        ItemStack[] equipment = this.getLivingEntity().getEquipment().getArmorContents();
        ListTag equipmentList = new ListTag();
        for (ItemStack item : equipment) {
            equipmentList.addObject(new ItemTag(item));
        }
        return equipmentList;
    }

    public boolean isGeneric() {
        return !this.isUnique();
    }

    @Override
    public LocationTag getLocation() {
        if (this.entity != null) {
            return new LocationTag(this.entity.getLocation());
        }
        return null;
    }

    public LocationTag getEyeLocation() {
        if (this.isPlayer()) {
            return new LocationTag(this.getPlayer().getEyeLocation());
        }
        if (!this.isGeneric() && this.isLivingEntity()) {
            return new LocationTag(this.getLivingEntity().getEyeLocation());
        }
        if (!this.isGeneric()) {
            return new LocationTag(this.getBukkitEntity().getLocation());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getTargetBlockSafe(Set<Material> mats, int range) {
        try {
            NMSHandler.getChunkHelper().changeChunkServerThread(this.getWorld());
            Location location = this.getLivingEntity().getTargetBlock(mats, range).getLocation();
            return location;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.getWorld());
        }
    }

    public Vector getVelocity() {
        if (!this.isGeneric()) {
            return this.entity.getVelocity();
        }
        return null;
    }

    public void setVelocity(Vector vector) {
        if (!this.isGeneric()) {
            this.entity.setVelocity(vector);
        }
    }

    public World getWorld() {
        if (!this.isGeneric()) {
            return this.entity.getWorld();
        }
        return null;
    }

    public void spawnAt(Location location) {
        if (this.isCitizensNPC()) {
            if (this.getDenizenNPC().getCitizen().isSpawned()) {
                this.getDenizenNPC().getCitizen().teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
            } else {
                this.getDenizenNPC().getCitizen().spawn(location);
                this.entity = this.getDenizenNPC().getCitizen().getEntity();
                this.uuid = this.getDenizenNPC().getCitizen().getEntity().getUniqueId();
            }
        } else if (this.entity != null && this.isUnique()) {
            this.entity.teleport(location);
            if (this.entity.getWorld().equals(location.getWorld())) {
                NMSHandler.getEntityHelper().teleport(this.entity, location);
            } else {
                List passengers = this.entity.getPassengers();
                if (!passengers.isEmpty()) {
                    Position.dismount(passengers);
                    this.entity.teleport(location);
                    for (Entity passenger : passengers) {
                        passenger.teleport(location);
                        this.entity.addPassenger(passenger);
                    }
                }
            }
        } else {
            if (this.entity_type != null) {
                if (this.despawned_entity != null) {
                    if (this.despawned_entity.custom_script == null) {
                        this.entity = this.entity_type.spawnNewEntity(location, this.mechanisms, this.entityScript);
                    }
                    this.getLivingEntity().teleport(location);
                    this.getLivingEntity().getEquipment().setArmorContents(this.despawned_entity.equipment);
                    this.getLivingEntity().setHealth(this.despawned_entity.health.doubleValue());
                    this.despawned_entity = null;
                } else if (this.entity_type.getBukkitEntityType() == EntityType.PLAYER) {
                    if (Depends.citizens == null) {
                        Debug.echoError("Cannot spawn entity of type PLAYER!");
                        return;
                    }
                    NPCTag npc = new NPCTag(CitizensAPI.getNPCRegistry().createNPC(EntityType.PLAYER, this.data1));
                    npc.getCitizen().spawn(location);
                    this.entity = npc.getEntity();
                    this.uuid = this.entity.getUniqueId();
                } else if (this.entity_type.getBukkitEntityType() == EntityType.FALLING_BLOCK) {
                    MaterialTag material = null;
                    if (this.data1 != null && MaterialTag.matches(this.data1)) {
                        material = MaterialTag.valueOf(this.data1, CoreUtilities.basicContext);
                        while (this.data1.equalsIgnoreCase("RANDOM") && (!material.getMaterial().isBlock() || material.getMaterial() == Material.AIR || material.getMaterial() == Material.NETHER_PORTAL || material.getMaterial() == Material.END_PORTAL)) {
                            material = MaterialTag.valueOf(this.data1, CoreUtilities.basicContext);
                        }
                    } else {
                        for (Mechanism mech : this.mechanisms) {
                            if (!mech.getName().equalsIgnoreCase("fallingblock_type")) continue;
                            material = mech.valueAsType(MaterialTag.class);
                            this.mechanisms.remove(mech);
                            break;
                        }
                    }
                    if (material == null || !material.getMaterial().isBlock() || !material.hasModernData()) {
                        material = new MaterialTag(Material.SAND);
                    }
                    this.entity = location.getWorld().spawnFallingBlock(location, material.getModernData());
                    this.uuid = this.entity.getUniqueId();
                } else {
                    this.entity = this.entity_type.spawnNewEntity(location, this.mechanisms, this.entityScript);
                    if (this.entity == null) {
                        if (Debug.verbose) {
                            Debug.echoError("Failed to spawn entity of type " + this.entity_type.getName());
                        }
                        return;
                    }
                    this.uuid = this.entity.getUniqueId();
                    if (this.entityScript != null) {
                        EntityScriptHelper.setEntityScript(this.entity, this.entityScript);
                    }
                }
            } else {
                Debug.echoError("Cannot spawn a null EntityTag!");
            }
            if (!this.isUnique()) {
                Debug.echoError("Error spawning entity - bad entity type, blocked by another plugin, or tried to spawn in an unloaded chunk?");
                return;
            }
            for (Mechanism mechanism : this.mechanisms) {
                this.safeAdjust(new Mechanism(new ElementTag(mechanism.getName()), mechanism.value, mechanism.context));
            }
            this.mechanisms.clear();
        }
    }

    public void despawn() {
        this.despawned_entity = new DespawnedEntity(this);
        this.getLivingEntity().remove();
    }

    public void respawn() {
        if (this.despawned_entity != null) {
            this.spawnAt(this.despawned_entity.location);
        } else if (this.entity == null) {
            Debug.echoError("Cannot respawn a null EntityTag!");
        }
    }

    public boolean isSpawnedOrValidForTag() {
        return this.entity != null && (this.isValidForTag() || rememberedEntities.containsKey(this.entity.getUniqueId()));
    }

    public boolean isSpawned() {
        return this.isValid();
    }

    public boolean isValid() {
        return this.entity != null && (this.entity.isValid() || this.isFake && this.isFakeValid);
    }

    public boolean isValidForTag() {
        if (this.isFake) {
            return true;
        }
        NMSHandler.getChunkHelper().changeChunkServerThread(this.entity.getWorld());
        try {
            boolean bl = this.entity.isValid();
            return bl;
        }
        finally {
            NMSHandler.getChunkHelper().restoreServerThread(this.entity.getWorld());
        }
    }

    public void remove() {
        this.entity.remove();
    }

    public void teleport(Location location) {
        if (this.isCitizensNPC()) {
            this.getDenizenNPC().getCitizen().teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        } else if (this.isFake) {
            NMSHandler.getEntityHelper().snapPositionTo(this.entity, location.toVector());
            NMSHandler.getEntityHelper().look(this.entity, location.getYaw(), location.getPitch());
        } else {
            this.entity.teleport(location);
            if (this.entity.getWorld().equals(location.getWorld())) {
                NMSHandler.getEntityHelper().teleport(this.entity, location);
            }
        }
    }

    public void target(LivingEntity target) {
        if (!this.isSpawned()) {
            return;
        }
        if (this.entity instanceof Creature) {
            NMSHandler.getEntityHelper().setTarget((Creature)this.entity, target);
        } else if (this.entity instanceof ShulkerBullet) {
            ((ShulkerBullet)this.entity).setTarget((Entity)target);
        } else {
            Debug.echoError(this.identify() + " is not an entity type that can hold a target!");
        }
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public int comparesTo(EntityTag entity) {
        if (entity == null) {
            return 0;
        }
        if (entity.isUnique() && entity.identify().equals(this.identify())) {
            return 1;
        }
        if (!entity.isUnique()) {
            if (!this.isUnique() && entity.identify().equals(this.identify())) {
                return 1;
            }
            if (this.entity_type == entity.entity_type) {
                return 1;
            }
        }
        return 0;
    }

    public boolean comparedTo(String compare) {
        if ((compare = CoreUtilities.toLowerCase(compare)).equals("entity")) {
            return true;
        }
        if (compare.equals("player")) {
            return this.isPlayer();
        }
        if (compare.equals("npc")) {
            return this.isCitizensNPC() || this.isNPC();
        }
        if (this.getEntityScript() != null && compare.equals(CoreUtilities.toLowerCase(this.getEntityScript()))) {
            return true;
        }
        return compare.equals(this.getEntityType().getLowercaseName());
    }

    @Override
    public String getObjectType() {
        return "Entity";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public EntityTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.npc != null) {
            return this.npc.debuggable();
        }
        if (this.entity != null) {
            if (this.isPlayer()) {
                return this.getDenizenPlayer().debuggable();
            }
            if (this.isFake) {
                return "e@FAKE: " + this.getUUID() + "<GR>(FAKE-" + this.entity.getType().name() + "/" + this.entity.getName() + ")";
            }
            if (this.isSpawnedOrValidForTag()) {
                return "e@ " + this.getUUID() + "<GR>(" + this.entity.getType().name() + "/" + this.entity.getName() + ")";
            }
        }
        return this.identify();
    }

    @Override
    public String savable() {
        if (this.npc != null) {
            return this.npc.savable();
        }
        if (this.isPlayer()) {
            return this.getDenizenPlayer().savable();
        }
        if (this.isFake) {
            return "e@fake:" + this.getUUID();
        }
        return this.identify();
    }

    @Override
    public String identify() {
        if (this.npc != null) {
            return this.npc.identify();
        }
        if (this.isPlayer()) {
            return this.getDenizenPlayer().identify();
        }
        if (this.isFake) {
            return "e@fake:" + this.getUUID();
        }
        if (this.getUUID() != null) {
            if (this.entityScript != null) {
                return "e@" + this.getUUID() + "/" + this.entityScript + this.getWaitingMechanismsString();
            }
            if (this.entity_type != null) {
                return "e@" + this.getUUID() + "/" + this.entity_type.getLowercaseName() + this.getWaitingMechanismsString();
            }
        }
        if (this.entityScript != null) {
            return "e@" + this.entityScript + this.getWaitingMechanismsString();
        }
        if (this.entity_type != null) {
            return "e@" + this.entity_type.getLowercaseName() + this.getWaitingMechanismsString();
        }
        return "null";
    }

    public String getWaitingMechanismsString() {
        StringBuilder properties = new StringBuilder();
        for (Mechanism mechanism : this.mechanisms) {
            properties.append(mechanism.getName()).append("=").append(PropertyParser.escapePropertyValue(mechanism.getValue().asString())).append(";");
        }
        if (properties.length() > 0) {
            return "[" + properties.substring(0, properties.length() - 1) + "]";
        }
        return "";
    }

    @Override
    public String identifySimple() {
        if (this.npc != null && this.npc.isValid()) {
            return "n@" + this.npc.getId();
        }
        if (this.isPlayer()) {
            return "p@" + this.getPlayer().getName();
        }
        if (this.entityScript != null) {
            return "e@" + this.entityScript;
        }
        if (this.entity_type != null) {
            return "e@" + this.entity_type.getLowercaseName();
        }
        return "null";
    }

    public String identifySimpleType() {
        if (this.isCitizensNPC()) {
            return "npc";
        }
        if (this.isPlayer()) {
            return "player";
        }
        return this.entity_type.getLowercaseName();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public boolean isUnique() {
        return this.isPlayer() || this.isCitizensNPC() || this.isSpawned() || this.isLivingEntity() || this.entity != null && rememberedEntities.containsKey(this.entity.getUniqueId()) || this.isFake;
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        PropertyParser.registerPropertyTagHandlers(tagProcessor);
        EntityTag.registerTag("entity_type", (attribute, object) -> new ElementTag(object.entity_type.getName()), new String[0]);
        EntityTag.registerTag("translated_name", (attribute, object) -> {
            String key = object.getEntityType().getBukkitEntityType().getKey().getKey();
            return new ElementTag("\u00a7[translate=entity.minecraft." + key + "]");
        }, new String[0]);
        EntityTag.registerTag("is_spawned", (attribute, object) -> new ElementTag(object.isSpawned()), new String[0]);
        EntityTag.registerTag("eid", (attribute, object) -> new ElementTag(object.entity.getEntityId()), new String[0]);
        EntityTag.registerTag("uuid", (attribute, object) -> new ElementTag(object.getUUID().toString()), new String[0]);
        EntityTag.registerTag("script", (attribute, object) -> {
            if (object.entityScript == null) {
                return null;
            }
            ScriptTag tag = new ScriptTag(object.entityScript);
            if (tag.isValid()) {
                return tag;
            }
            return null;
        }, new String[0]);
        EntityTag.registerTag("scriptname", (attribute, object) -> {
            Deprecations.hasScriptTags.warn(attribute.context);
            if (object.entityScript == null) {
                return null;
            }
            return new ElementTag(object.entityScript);
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("custom_id", (attribute, object) -> {
            Deprecations.entityCustomIdTag.warn(attribute.context);
            if (CustomNBT.hasCustomNBT((Entity)object.getLivingEntity(), "denizen-script-id")) {
                return new ScriptTag(CustomNBT.getCustomNBT((Entity)object.getLivingEntity(), "denizen-script-id"));
            }
            return new ElementTag(object.entity.getType().name());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("name", (attribute, object) -> new ElementTag(object.getName()), new String[0]);
        EntityTag.registerSpawnedOnlyTag("saddle", (attribute, object) -> {
            if (object.getLivingEntity().getType() == EntityType.HORSE) {
                return new ItemTag(((Horse)object.getLivingEntity()).getInventory().getSaddle());
            }
            if (object.getLivingEntity().getType() == EntityType.PIG) {
                return new ItemTag(((Pig)object.getLivingEntity()).hasSaddle() ? Material.SADDLE : Material.AIR);
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("horse_armor", (attribute, object) -> {
            if (object.getBukkitEntityType() == EntityType.HORSE) {
                return new ItemTag(((Horse)object.getLivingEntity()).getInventory().getArmor());
            }
            return null;
        }, "horse_armour");
        EntityTag.registerSpawnedOnlyTag("has_saddle", (attribute, object) -> {
            if (object.getBukkitEntityType() == EntityType.HORSE) {
                return new ElementTag(((Horse)object.getLivingEntity()).getInventory().getSaddle().getType() == Material.SADDLE);
            }
            if (object.getBukkitEntityType() == EntityType.PIG) {
                return new ElementTag(((Pig)object.getLivingEntity()).hasSaddle());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("item_in_hand", (attribute, object) -> new ItemTag(object.getLivingEntity().getEquipment().getItemInMainHand()), "iteminhand");
        EntityTag.registerSpawnedOnlyTag("item_in_offhand", (attribute, object) -> new ItemTag(object.getLivingEntity().getEquipment().getItemInOffHand()), "iteminoffhand");
        EntityTag.registerSpawnedOnlyTag("is_trading", (attribute, object) -> {
            if (object.entity instanceof Merchant) {
                return new ElementTag(((Merchant)object.entity).isTrading());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("trading_with", (attribute, object) -> {
            if (object.entity instanceof Merchant && ((Merchant)object.entity).getTrader() != null) {
                return new EntityTag((Entity)((Merchant)object.entity).getTrader());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("map_trace", (attribute, object) -> {
            EntityHelper.MapTraceResult mtr = NMSHandler.getEntityHelper().mapTrace(object.getLivingEntity(), 200.0);
            if (mtr != null) {
                double x = 0.0;
                double basex = mtr.hitLocation.getX() - Math.floor(mtr.hitLocation.getX());
                double basey = mtr.hitLocation.getY() - Math.floor(mtr.hitLocation.getY());
                double basez = mtr.hitLocation.getZ() - Math.floor(mtr.hitLocation.getZ());
                if (mtr.angle == BlockFace.NORTH) {
                    x = 128.0 - basex * 128.0;
                } else if (mtr.angle == BlockFace.SOUTH) {
                    x = basex * 128.0;
                } else if (mtr.angle == BlockFace.WEST) {
                    x = basez * 128.0;
                } else if (mtr.angle == BlockFace.EAST) {
                    x = 128.0 - basez * 128.0;
                }
                double y = 128.0 - basey * 128.0;
                return new LocationTag(null, Math.round(x), Math.round(y));
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("can_see", (attribute, object) -> {
            EntityTag toEntity;
            if (object.isLivingEntity() && attribute.hasContext(1) && EntityTag.matches(attribute.getContext(1)) && (toEntity = attribute.contextAsType(1, EntityTag.class)) != null && toEntity.isSpawnedOrValidForTag()) {
                return new ElementTag(object.getLivingEntity().hasLineOfSight(toEntity.getBukkitEntity()));
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("eye_location", (attribute, object) -> new LocationTag(object.getEyeLocation()), new String[0]);
        EntityTag.registerSpawnedOnlyTag("eye_height", (attribute, object) -> {
            if (object.isLivingEntity()) {
                return new ElementTag(object.getLivingEntity().getEyeHeight());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("cursor_on", (attribute, object) -> {
            RayTraceResult traced;
            double range = attribute.getDoubleContext(1);
            if (range <= 0.0) {
                range = 200.0;
            }
            if ((traced = object.getWorld().rayTraceBlocks((Location)object.getEyeLocation(), object.getEyeLocation().getDirection(), range)) != null && traced.getHitBlock() != null) {
                return new LocationTag(traced.getHitBlock().getLocation());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("location", (attribute, object) -> {
            if (attribute.startsWith("cursor_on", 2)) {
                Deprecations.entityLocationCursorOnTag.warn(attribute.context);
                int range = attribute.getIntContext(2);
                if (range < 1) {
                    range = 50;
                }
                HashSet<Material> set = new HashSet<Material>();
                set.add(Material.AIR);
                if (attribute.startsWith("ignore", 3) && attribute.hasContext(3)) {
                    List<MaterialTag> ignoreList = attribute.contextAsType(3, ListTag.class).filter(MaterialTag.class, attribute.context);
                    for (MaterialTag material : ignoreList) {
                        set.add(material.getMaterial());
                    }
                    attribute.fulfill(1);
                }
                attribute.fulfill(1);
                return new LocationTag(object.getTargetBlockSafe(set, range));
            }
            if (attribute.startsWith("standing_on", 2)) {
                attribute.fulfill(1);
                return new LocationTag(object.entity.getLocation().clone().add(0.0, -0.5, 0.0));
            }
            return new LocationTag(object.entity.getLocation());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("body_yaw", (attribute, object) -> new ElementTag(NMSHandler.getEntityHelper().getBaseYaw(object.entity)), new String[0]);
        EntityTag.registerSpawnedOnlyTag("velocity", (attribute, object) -> new LocationTag(object.entity.getVelocity().toLocation(object.entity.getWorld())), new String[0]);
        EntityTag.registerSpawnedOnlyTag("world", (attribute, object) -> new WorldTag(object.entity.getWorld()), new String[0]);
        EntityTag.registerSpawnedOnlyTag("can_pickup_items", (attribute, object) -> {
            if (object.isLivingEntity()) {
                return new ElementTag(object.getLivingEntity().getCanPickupItems());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("fallingblock_material", (attribute, object) -> {
            if (!(object.entity instanceof FallingBlock)) {
                return null;
            }
            return new MaterialTag(((FallingBlock)object.entity).getBlockData());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("fall_distance", (attribute, object) -> new ElementTag(object.entity.getFallDistance()), new String[0]);
        EntityTag.registerSpawnedOnlyTag("fire_time", (attribute, object) -> new DurationTag(object.entity.getFireTicks() / 20), new String[0]);
        EntityTag.registerSpawnedOnlyTag("on_fire", (attribute, object) -> new ElementTag(object.entity.getFireTicks() > 0), new String[0]);
        EntityTag.registerSpawnedOnlyTag("leash_holder", (attribute, object) -> {
            if (object.isLivingEntity() && object.getLivingEntity().isLeashed()) {
                return new EntityTag(object.getLivingEntity().getLeashHolder());
            }
            return null;
        }, "get_leash_holder");
        EntityTag.registerSpawnedOnlyTag("passengers", (attribute, object) -> {
            ArrayList<EntityTag> passengers = new ArrayList<EntityTag>();
            for (Entity ent : object.entity.getPassengers()) {
                passengers.add(new EntityTag(ent));
            }
            return new ListTag((Collection<? extends ObjectTag>)passengers);
        }, "get_passengers");
        EntityTag.registerSpawnedOnlyTag("passenger", (attribute, object) -> {
            if (!object.entity.isEmpty()) {
                return new EntityTag(object.entity.getPassenger());
            }
            return null;
        }, "get_passenger");
        EntityTag.registerSpawnedOnlyTag("shooter", (attribute, object) -> {
            EntityTag shooter = object.getShooter();
            if (shooter == null) {
                return null;
            }
            return shooter.getDenizenObject();
        }, "get_shooter");
        EntityTag.registerSpawnedOnlyTag("left_shoulder", (attribute, object) -> {
            if (!(object.getLivingEntity() instanceof HumanEntity)) {
                return null;
            }
            return new EntityTag(((HumanEntity)object.getLivingEntity()).getShoulderEntityLeft());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("right_shoulder", (attribute, object) -> {
            if (!(object.getLivingEntity() instanceof HumanEntity)) {
                return null;
            }
            return new EntityTag(((HumanEntity)object.getLivingEntity()).getShoulderEntityRight());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("vehicle", (attribute, object) -> {
            if (object.entity.isInsideVehicle()) {
                return new EntityTag(object.entity.getVehicle());
            }
            return null;
        }, "get_vehicle");
        EntityTag.registerSpawnedOnlyTag("can_breed", (attribute, object) -> {
            if (!(object.getLivingEntity() instanceof Breedable)) {
                return new ElementTag(false);
            }
            return new ElementTag(((Breedable)object.getLivingEntity()).canBreed());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("breeding", (attribute, object) -> {
            if (!(object.getLivingEntity() instanceof Animals)) {
                return null;
            }
            return new ElementTag(((Animals)object.getLivingEntity()).getLoveModeTicks() > 0);
        }, "is_breeding");
        EntityTag.registerSpawnedOnlyTag("has_passenger", (attribute, object) -> new ElementTag(!object.entity.isEmpty()), new String[0]);
        EntityTag.registerSpawnedOnlyTag("is_empty", (attribute, object) -> new ElementTag(object.entity.isEmpty()), "empty");
        EntityTag.registerSpawnedOnlyTag("is_inside_vehicle", (attribute, object) -> new ElementTag(object.entity.isInsideVehicle()), "inside_vehicle");
        EntityTag.registerSpawnedOnlyTag("is_leashed", (attribute, object) -> new ElementTag(object.isLivingEntity() && object.getLivingEntity().isLeashed()), "leashed");
        EntityTag.registerSpawnedOnlyTag("is_sheared", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof Sheep)) {
                return null;
            }
            return new ElementTag(((Sheep)object.getBukkitEntity()).isSheared());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("is_on_ground", (attribute, object) -> new ElementTag(object.entity.isOnGround()), "on_ground");
        EntityTag.registerSpawnedOnlyTag("is_persistent", (attribute, object) -> new ElementTag(object.isLivingEntity() && !object.getLivingEntity().getRemoveWhenFarAway()), "persistent");
        EntityTag.registerSpawnedOnlyTag("is_collidable", (attribute, object) -> {
            if (object.isCitizensNPC()) {
                return new ElementTag((Boolean)object.getDenizenNPC().getCitizen().data().get("collidable", (Object)true));
            }
            return new ElementTag(object.getLivingEntity().isCollidable());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("is_sleeping", (attribute, object) -> {
            if (object.getBukkitEntity() instanceof Player) {
                return new ElementTag(((Player)object.getBukkitEntity()).isSleeping());
            }
            if (object.getBukkitEntity() instanceof Villager) {
                return new ElementTag(((Villager)object.getBukkitEntity()).isSleeping());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("killer", (attribute, object) -> EntityTag.getPlayerFrom((Entity)object.getLivingEntity().getKiller()), new String[0]);
        EntityTag.registerSpawnedOnlyTag("last_damage", (attribute, object) -> {
            if (attribute.startsWith("amount", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getLivingEntity().getLastDamage());
            }
            if (attribute.startsWith("cause", 2)) {
                attribute.fulfill(1);
                if (object.entity.getLastDamageCause() == null) {
                    return null;
                }
                return new ElementTag(object.entity.getLastDamageCause().getCause().name());
            }
            if (attribute.startsWith("duration", 2)) {
                attribute.fulfill(1);
                return new DurationTag((long)object.getLivingEntity().getNoDamageTicks());
            }
            if (attribute.startsWith("max_duration", 2)) {
                attribute.fulfill(1);
                return new DurationTag((long)object.getLivingEntity().getMaximumNoDamageTicks());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("absorption_health", (attribute, object) -> new ElementTag(NMSHandler.getEntityHelper().getAbsorption(object.getLivingEntity())), new String[0]);
        EntityTag.registerSpawnedOnlyTag("max_oxygen", (attribute, object) -> new DurationTag((long)object.getLivingEntity().getMaximumAir()), new String[0]);
        EntityTag.registerSpawnedOnlyTag("oxygen", (attribute, object) -> {
            if (attribute.startsWith("max", 2)) {
                Deprecations.entityMaxOxygenTag.warn(attribute.context);
                attribute.fulfill(1);
                return new DurationTag((long)object.getLivingEntity().getMaximumAir());
            }
            return new DurationTag((long)object.getLivingEntity().getRemainingAir());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("persistent", (attribute, object) -> new ElementTag(!object.getLivingEntity().getRemoveWhenFarAway()), new String[0]);
        EntityTag.registerSpawnedOnlyTag("remove_when_far", (attribute, object) -> {
            Deprecations.entityRemoveWhenFar.warn(attribute.context);
            return new ElementTag(object.getLivingEntity().getRemoveWhenFarAway());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("target", (attribute, object) -> {
            Entity target;
            if (object.getBukkitEntity() instanceof Creature) {
                LivingEntity target2 = ((Creature)object.getLivingEntity()).getTarget();
                if (target2 != null) {
                    return new EntityTag((Entity)target2);
                }
            } else if (object.getBukkitEntity() instanceof ShulkerBullet && (target = ((ShulkerBullet)object.getLivingEntity()).getTarget()) != null) {
                return new EntityTag(target);
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("precise_target", (attribute, object) -> {
            RayTraceResult result;
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 200;
            }
            if (attribute.startsWith("type", 2) && attribute.hasContext(2)) {
                attribute.fulfill(1);
                HashSet<EntityType> types = new HashSet<EntityType>();
                for (String str : attribute.contextAsType(1, ListTag.class)) {
                    types.add(EntityTag.valueOf(str, attribute.context).getBukkitEntityType());
                }
                result = object.getWorld().rayTrace((Location)object.getEyeLocation(), object.getEyeLocation().getDirection(), (double)range, FluidCollisionMode.NEVER, true, 0.0, e -> !e.equals(object.getBukkitEntity()) && types.contains(e.getType()));
            } else {
                result = object.getWorld().rayTrace((Location)object.getEyeLocation(), object.getEyeLocation().getDirection(), (double)range, FluidCollisionMode.NEVER, true, 0.0, e -> !e.equals(object.getBukkitEntity()));
            }
            if (result != null && result.getHitEntity() != null) {
                return new EntityTag(result.getHitEntity());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("precise_target_position", (attribute, object) -> {
            RayTraceResult result;
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 200;
            }
            if (attribute.startsWith("type", 2) && attribute.hasContext(2)) {
                attribute.fulfill(1);
                HashSet<EntityType> types = new HashSet<EntityType>();
                for (String str : attribute.contextAsType(1, ListTag.class)) {
                    types.add(EntityTag.valueOf(str, attribute.context).getBukkitEntityType());
                }
                result = object.getWorld().rayTrace((Location)object.getEyeLocation(), object.getEyeLocation().getDirection(), (double)range, FluidCollisionMode.NEVER, true, 0.0, e -> !e.equals(object.getBukkitEntity()) && types.contains(e.getType()));
            } else {
                result = object.getWorld().rayTrace((Location)object.getEyeLocation(), object.getEyeLocation().getDirection(), (double)range, FluidCollisionMode.NEVER, true, 0.0, e -> !e.equals(object.getBukkitEntity()));
            }
            if (result != null) {
                return new LocationTag(object.getWorld(), result.getHitPosition());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("time_lived", (attribute, object) -> new DurationTag(object.entity.getTicksLived() / 20), new String[0]);
        EntityTag.registerSpawnedOnlyTag("pickup_delay", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof Item)) {
                return null;
            }
            return new DurationTag(((Item)object.getBukkitEntity()).getPickupDelay() * 20);
        }, "pickupdelay");
        EntityTag.registerSpawnedOnlyTag("is_in_block", (attribute, object) -> {
            if (object.getBukkitEntity() instanceof Arrow) {
                return new ElementTag(((Arrow)object.getBukkitEntity()).isInBlock());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("attached_block", (attribute, object) -> {
            if (object.getBukkitEntity() instanceof Arrow) {
                Block attachedBlock = ((Arrow)object.getBukkitEntity()).getAttachedBlock();
                if (attachedBlock != null) {
                    return new LocationTag(attachedBlock.getLocation());
                }
            } else if (object.getBukkitEntity() instanceof Hanging) {
                Vector dir = ((Hanging)object.getBukkitEntity()).getAttachedFace().getDirection();
                return new LocationTag(object.getLocation().clone().add(dir.multiply(0.5))).getBlockLocation();
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("gliding", (attribute, object) -> new ElementTag(object.getLivingEntity().isGliding()), new String[0]);
        EntityTag.registerSpawnedOnlyTag("swimming", (attribute, object) -> new ElementTag(object.getLivingEntity().isSwimming()), new String[0]);
        EntityTag.registerSpawnedOnlyTag("glowing", (attribute, object) -> new ElementTag(object.getBukkitEntity().isGlowing()), new String[0]);
        EntityTag.registerTag("is_living", (attribute, object) -> {
            if (object.entity == null && object.entity_type != null) {
                return new ElementTag(object.entity_type.getBukkitEntityType().isAlive());
            }
            return new ElementTag(object.isLivingEntity());
        }, new String[0]);
        EntityTag.registerTag("is_monster", (attribute, object) -> {
            if (object.entity == null && object.entity_type != null) {
                return new ElementTag(Monster.class.isAssignableFrom(object.entity_type.getBukkitEntityType().getEntityClass()));
            }
            return new ElementTag(object.getBukkitEntity() instanceof Monster);
        }, new String[0]);
        EntityTag.registerTag("is_mob", (attribute, object) -> {
            if (object.entity == null && object.entity_type != null) {
                EntityType type = object.entity_type.getBukkitEntityType();
                return new ElementTag(Mob.class.isAssignableFrom(type.getEntityClass()));
            }
            return new ElementTag(!object.isNPC() && object.getBukkitEntity() instanceof Mob);
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("is_npc", (attribute, object) -> new ElementTag(object.isCitizensNPC()), new String[0]);
        EntityTag.registerSpawnedOnlyTag("is_player", (attribute, object) -> new ElementTag(object.isPlayer()), new String[0]);
        EntityTag.registerTag("is_projectile", (attribute, object) -> {
            if (object.entity == null && object.entity_type != null) {
                return new ElementTag(Projectile.class.isAssignableFrom(object.entity_type.getBukkitEntityType().getEntityClass()));
            }
            return new ElementTag(object.isProjectile());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("tameable", (attribute, object) -> new ElementTag(EntityTame.describes(object)), "is_tameable");
        EntityTag.registerSpawnedOnlyTag("ageable", (attribute, object) -> new ElementTag(EntityAge.describes(object)), "is_ageable");
        EntityTag.registerSpawnedOnlyTag("colorable", (attribute, object) -> new ElementTag(EntityColor.describes(object)), "is_colorable");
        EntityTag.registerSpawnedOnlyTag("experience", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof ExperienceOrb)) {
                return null;
            }
            return new ElementTag(((ExperienceOrb)object.getBukkitEntity()).getExperience());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("fuse_ticks", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof TNTPrimed)) {
                return null;
            }
            return new ElementTag(((TNTPrimed)object.getBukkitEntity()).getFuseTicks());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("dragon_phase", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof EnderDragon)) {
                return null;
            }
            return new ElementTag(((EnderDragon)object.getLivingEntity()).getPhase().name());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("weapon_damage", (attribute, object) -> {
            Entity target = null;
            if (attribute.hasContext(1)) {
                target = attribute.contextAsType(1, EntityTag.class).getBukkitEntity();
            }
            return new ElementTag(NMSHandler.getEntityHelper().getDamageTo(object.getLivingEntity(), target));
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag("skin_layers", (attribute, object) -> {
            byte flags = NMSHandler.getPlayerHelper().getSkinLayers((Player)object.getBukkitEntity());
            ListTag result = new ListTag();
            for (PlayerHelper.SkinLayer layer : PlayerHelper.SkinLayer.values()) {
                if ((flags & layer.flag) == 0) continue;
                result.add(layer.name());
            }
            return result;
        }, new String[0]);
        EntityTag.registerTag("is_disguised", (attribute, object) -> {
            HashMap<UUID, DisguiseCommand.TrackedDisguise> map = DisguiseCommand.disguises.get(object.getUUID());
            if (map == null) {
                return new ElementTag(false);
            }
            if (attribute.hasContext(1)) {
                PlayerTag player = attribute.contextAsType(1, PlayerTag.class);
                if (player == null) {
                    attribute.echoError("Invalid player for is_disguised tag.");
                    return null;
                }
                return new ElementTag(map.containsKey(player.getUUID()) || map.containsKey(null));
            }
            return new ElementTag(map.containsKey(null));
        }, new String[0]);
        EntityTag.registerTag("disguised_type", (attribute, object) -> {
            DisguiseCommand.TrackedDisguise disguise;
            HashMap<UUID, DisguiseCommand.TrackedDisguise> map = DisguiseCommand.disguises.get(object.getUUID());
            if (map == null) {
                return null;
            }
            if (attribute.hasContext(1)) {
                PlayerTag player = attribute.contextAsType(1, PlayerTag.class);
                if (player == null) {
                    attribute.echoError("Invalid player for is_disguised tag.");
                    return null;
                }
                disguise = map.get(player.getUUID());
                if (disguise == null) {
                    disguise = map.get(null);
                }
            } else {
                disguise = map.get(null);
            }
            if (disguise == null) {
                return null;
            }
            return disguise.as.duplicate();
        }, new String[0]);
        EntityTag.registerTag("disguise_to_others", (attribute, object) -> {
            DisguiseCommand.TrackedDisguise disguise;
            HashMap<UUID, DisguiseCommand.TrackedDisguise> map = DisguiseCommand.disguises.get(object.getUUID());
            if (map == null) {
                return null;
            }
            if (attribute.hasContext(1)) {
                PlayerTag player = attribute.contextAsType(1, PlayerTag.class);
                if (player == null) {
                    attribute.echoError("Invalid player for is_disguised tag.");
                    return null;
                }
                disguise = map.get(player.getUUID());
                if (disguise == null) {
                    disguise = map.get(null);
                }
            } else {
                disguise = map.get(null);
            }
            if (disguise == null) {
                return null;
            }
            if (disguise.toOthers == null) {
                return null;
            }
            return disguise.toOthers.entity;
        }, new String[0]);
        EntityTag.registerTag("describe", (attribute, object) -> {
            ArrayList<Mechanism> waitingMechs;
            if (object.isSpawnedOrValidForTag()) {
                waitingMechs = new ArrayList();
                for (Map.Entry<StringHolder, ObjectTag> property : PropertyParser.getPropertiesMap((ObjectTag)object).map.entrySet()) {
                    waitingMechs.add(new Mechanism(new ElementTag(property.getKey().str), property.getValue()));
                }
            } else {
                waitingMechs = new ArrayList<Mechanism>(object.getWaitingMechanisms());
            }
            return new EntityTag(object.entity_type, waitingMechs);
        }, new String[0]);
    }

    public static void registerSpawnedOnlyTag(String name, TagRunnable.ObjectInterface<EntityTag> runnable, String ... variants) {
        TagRunnable.ObjectInterface<EntityTag> newRunnable = (attribute, object) -> {
            if (!object.isSpawnedOrValidForTag()) {
                if (!attribute.hasAlternative()) {
                    com.denizenscript.denizen.utilities.debugging.Debug.echoError("Entity is not spawned, but tag '" + attribute.getAttributeWithoutContext(1) + "' requires the entity be spawned, for entity: " + object.debuggable());
                }
                return null;
            }
            return runnable.run(attribute, (EntityTag)object);
        };
        EntityTag.registerTag(name, newRunnable, variants);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<EntityTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    public ArrayList<Mechanism> getWaitingMechanisms() {
        return this.mechanisms;
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        if (this.isGeneric()) {
            this.mechanisms.add(mechanism);
            mechanism.fulfill();
        } else {
            Debug.echoError("Cannot apply properties to an already-spawned entity!");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void adjust(Mechanism mechanism) {
        Entity bukkitEnt;
        if (this.isGeneric()) {
            this.mechanisms.add(mechanism);
            mechanism.fulfill();
            return;
        }
        if (this.getBukkitEntity() == null) {
            if (this.isCitizensNPC()) {
                Debug.echoError("Cannot adjust not-spawned NPC " + this.getDenizenNPC());
            } else {
                Debug.echoError("Cannot adjust entity " + this);
            }
            return;
        }
        if (mechanism.matches("item_in_hand")) {
            this.getLivingEntity().getEquipment().setItemInMainHand(mechanism.valueAsType(ItemTag.class).getItemStack());
        }
        if (mechanism.matches("item_in_offhand")) {
            this.getLivingEntity().getEquipment().setItemInOffHand(mechanism.valueAsType(ItemTag.class).getItemStack());
        }
        if (mechanism.matches("attach_to")) {
            Deprecations.attachToMech.warn(mechanism.context);
            if (mechanism.hasValue()) {
                void var3_9;
                ListTag list = mechanism.valueAsType(ListTag.class);
                Object var3_7 = null;
                boolean rotateWith = true;
                if (list.size() > 1) {
                    Vector vector = LocationTag.valueOf(list.get(1), mechanism.context).toVector();
                    if (list.size() > 2) {
                        rotateWith = new ElementTag(list.get(2)).asBoolean();
                    }
                }
                EntityAttachmentHelper.forceAttachMove(this, EntityTag.valueOf(list.get(0), mechanism.context), (Vector)var3_9, rotateWith);
            } else {
                EntityAttachmentHelper.forceAttachMove(this, null, null, false);
            }
        }
        if (mechanism.matches("shooter")) {
            this.setShooter(mechanism.valueAsType(EntityTag.class));
        }
        if (mechanism.matches("can_pickup_items") && mechanism.requireBoolean()) {
            this.getLivingEntity().setCanPickupItems(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fall_distance") && mechanism.requireFloat()) {
            this.entity.setFallDistance(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("fallingblock_drop_item") && mechanism.requireBoolean() && this.entity instanceof FallingBlock) {
            ((FallingBlock)this.entity).setDropItem(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fallingblock_hurt_entities") && mechanism.requireBoolean() && this.entity instanceof FallingBlock) {
            ((FallingBlock)this.entity).setHurtEntities(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fire_time") && mechanism.requireObject(DurationTag.class)) {
            this.entity.setFireTicks(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("leash_holder") && mechanism.requireObject(EntityTag.class)) {
            this.getLivingEntity().setLeashHolder(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
        }
        if (mechanism.matches("can_breed") && mechanism.requireBoolean()) {
            ((Ageable)this.getLivingEntity()).setBreed(true);
        }
        if (mechanism.matches("breed") && mechanism.requireBoolean()) {
            ((Animals)this.getLivingEntity()).setLoveModeTicks(mechanism.getValue().asBoolean() ? 600 : 0);
        }
        if (mechanism.matches("passengers")) {
            this.entity.eject();
            for (EntityTag entityTag : mechanism.valueAsType(ListTag.class).filter(EntityTag.class, mechanism.context)) {
                if (this.comparesTo(entityTag) == 1) continue;
                if (!entityTag.isSpawned()) {
                    entityTag.spawnAt(this.getLocation());
                }
                if (!entityTag.isSpawned()) continue;
                this.entity.addPassenger(entityTag.getBukkitEntity());
            }
        }
        if (mechanism.matches("passenger") && mechanism.requireObject(EntityTag.class)) {
            EntityTag ent3 = mechanism.valueAsType(EntityTag.class);
            if (!ent3.isSpawned()) {
                ent3.spawnAt(this.getLocation());
            }
            this.entity.eject();
            if (ent3.isSpawned()) {
                this.entity.addPassenger(ent3.getBukkitEntity());
            }
        }
        if (mechanism.matches("time_lived") && mechanism.requireObject(DurationTag.class)) {
            NMSHandler.getEntityHelper().setTicksLived(this.entity, mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("absorption_health") && mechanism.requireFloat()) {
            NMSHandler.getEntityHelper().setAbsorption(this.getLivingEntity(), mechanism.getValue().asDouble());
        }
        if (mechanism.matches("oxygen") && mechanism.requireObject(DurationTag.class)) {
            this.getLivingEntity().setRemainingAir(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("remaining_air") && mechanism.requireInteger()) {
            Deprecations.entityRemainingAir.warn(mechanism.context);
            this.getLivingEntity().setRemainingAir(mechanism.getValue().asInt());
        }
        if (mechanism.matches("remove_effects")) {
            for (PotionEffect potionEffect : this.getLivingEntity().getActivePotionEffects()) {
                this.getLivingEntity().removePotionEffect(potionEffect.getType());
            }
        }
        if (mechanism.matches("release_left_shoulder") && this.getLivingEntity() instanceof HumanEntity && (bukkitEnt = ((HumanEntity)this.getLivingEntity()).getShoulderEntityLeft()) != null) {
            EntityTag entityTag = new EntityTag(bukkitEnt);
            String escript = entityTag.getEntityScript();
            EntityTag entityTag2 = EntityTag.valueOf("e@" + (escript != null && escript.length() > 0 ? escript : entityTag.getEntityType().getLowercaseName()) + PropertyParser.getPropertiesString(entityTag), mechanism.context);
            entityTag2.spawnAt(this.getEyeLocation());
            ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(null);
        }
        if (mechanism.matches("release_right_shoulder") && this.getLivingEntity() instanceof HumanEntity && (bukkitEnt = ((HumanEntity)this.getLivingEntity()).getShoulderEntityRight()) != null) {
            EntityTag entityTag = new EntityTag(bukkitEnt);
            String escript = entityTag.getEntityScript();
            EntityTag entityTag3 = EntityTag.valueOf("e@" + (escript != null && escript.length() > 0 ? escript : entityTag.getEntityType().getLowercaseName()) + PropertyParser.getPropertiesString(entityTag), mechanism.context);
            entityTag3.spawnAt(this.getEyeLocation());
            ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(null);
        }
        if (mechanism.matches("left_shoulder") && this.getLivingEntity() instanceof HumanEntity) {
            if (mechanism.hasValue()) {
                if (mechanism.requireObject(EntityTag.class)) {
                    ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
                }
            } else {
                ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(null);
            }
        }
        if (mechanism.matches("right_shoulder") && this.getLivingEntity() instanceof HumanEntity) {
            if (mechanism.hasValue()) {
                if (mechanism.requireObject(EntityTag.class)) {
                    ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
                }
            } else {
                ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(null);
            }
        }
        if (mechanism.matches("persistent") && mechanism.requireBoolean()) {
            this.getLivingEntity().setRemoveWhenFarAway(!mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("remove_when_far_away") && mechanism.requireBoolean()) {
            Deprecations.entityRemoveWhenFar.warn(mechanism.context);
            this.getLivingEntity().setRemoveWhenFarAway(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("sheared") && mechanism.requireBoolean() && this.getBukkitEntity() instanceof Sheep) {
            ((Sheep)this.getBukkitEntity()).setSheared(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("collidable") && mechanism.requireBoolean()) {
            if (this.isCitizensNPC()) {
                this.getDenizenNPC().getCitizen().data().setPersistent("collidable", (Object)mechanism.getValue().asBoolean());
            } else {
                this.getLivingEntity().setCollidable(mechanism.getValue().asBoolean());
            }
        }
        if (mechanism.matches("no_damage_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getLivingEntity().setNoDamageTicks(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("max_no_damage_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getLivingEntity().setMaximumNoDamageTicks(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("velocity") && mechanism.requireObject(LocationTag.class)) {
            this.setVelocity(mechanism.valueAsType(LocationTag.class).toVector());
        }
        if (mechanism.matches("move") && mechanism.requireObject(LocationTag.class)) {
            NMSHandler.getEntityHelper().move(this.getBukkitEntity(), mechanism.valueAsType(LocationTag.class).toVector());
        }
        if (mechanism.matches("interact_with") && mechanism.requireObject(LocationTag.class)) {
            LocationTag interactLocation = mechanism.valueAsType(LocationTag.class);
            NMSHandler.getEntityHelper().forceInteraction(this.getPlayer(), interactLocation);
        }
        if (mechanism.matches("play_death")) {
            Deprecations.entityPlayDeath.warn(mechanism.context);
            this.getLivingEntity().playEffect(EntityEffect.DEATH);
        }
        if ((mechanism.matches("pickup_delay") || mechanism.matches("pickupdelay")) && this.getBukkitEntity() instanceof Item && mechanism.requireObject(DurationTag.class)) {
            ((Item)this.getBukkitEntity()).setPickupDelay(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("gliding") && mechanism.requireBoolean()) {
            this.getLivingEntity().setGliding(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("glowing") && mechanism.requireBoolean()) {
            this.getBukkitEntity().setGlowing(mechanism.getValue().asBoolean());
            if (Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC((Entity)this.getLivingEntity())) {
                CitizensAPI.getNPCRegistry().getNPC((Entity)this.getLivingEntity()).data().setPersistent("glowing", (Object)mechanism.getValue().asBoolean());
            }
        }
        if (mechanism.matches("dragon_phase")) {
            EnderDragon ed = (EnderDragon)this.getLivingEntity();
            ed.setPhase(EnderDragon.Phase.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("experience") && this.getBukkitEntity() instanceof ExperienceOrb && mechanism.requireInteger()) {
            ((ExperienceOrb)this.getBukkitEntity()).setExperience(mechanism.getValue().asInt());
        }
        if (mechanism.matches("fuse_ticks") && this.getBukkitEntity() instanceof TNTPrimed && mechanism.requireInteger()) {
            ((TNTPrimed)this.getBukkitEntity()).setFuseTicks(mechanism.getValue().asInt());
        }
        if (mechanism.matches("show_to_players")) {
            NMSHandler.getEntityHelper().unhideEntity(null, this.getBukkitEntity());
        }
        if (mechanism.matches("hide_from_players")) {
            NMSHandler.getEntityHelper().hideEntity(null, this.getBukkitEntity());
        }
        if (mechanism.matches("skin_layers")) {
            int flags = 0;
            for (String str : mechanism.valueAsType(ListTag.class)) {
                String upper = str.toUpperCase();
                if (upper.equals("ALL")) {
                    flags = 255;
                    continue;
                }
                PlayerHelper.SkinLayer layer = PlayerHelper.SkinLayer.valueOf(upper);
                flags |= layer.flag;
            }
            NMSHandler.getPlayerHelper().setSkinLayers((Player)this.getBukkitEntity(), (byte)flags);
        }
        if (mechanism.matches("mirror_player") && mechanism.requireBoolean()) {
            if (this.isNPC()) {
                NPC npc = this.getDenizenNPC().getCitizen();
                if (!npc.hasTrait(MirrorTrait.class)) {
                    npc.addTrait(MirrorTrait.class);
                }
                MirrorTrait mirrorTrait = (MirrorTrait)npc.getOrAddTrait(MirrorTrait.class);
                if (mechanism.getValue().asBoolean()) {
                    mirrorTrait.enableMirror();
                } else {
                    mirrorTrait.disableMirror();
                }
            } else if (mechanism.getValue().asBoolean()) {
                ProfileEditor.mirrorUUIDs.add(this.getUUID());
            } else {
                ProfileEditor.mirrorUUIDs.remove(this.getUUID());
            }
        }
        if (mechanism.matches("swimming") && mechanism.requireBoolean()) {
            this.getLivingEntity().setSwimming(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("detonate")) {
            if (this.getBukkitEntity() instanceof Firework) {
                ((Firework)this.getBukkitEntity()).detonate();
            } else if (this.getBukkitEntity() instanceof Creeper) {
                ((Creeper)this.getBukkitEntity()).explode();
            } else {
                Debug.echoError("Cannot detonate entity of type '" + this.getBukkitEntityType().name() + "'.");
            }
        }
        if (mechanism.matches("ignite")) {
            if (this.getBukkitEntity() instanceof Creeper) {
                ((Creeper)this.getBukkitEntity()).ignite();
            } else {
                Debug.echoError("Cannot ignite entity of type '" + this.getBukkitEntityType().name() + "'.");
            }
        }
        if (mechanism.matches("head_angle") && mechanism.requireFloat()) {
            NMSHandler.getEntityHelper().setHeadAngle(this.getBukkitEntity(), mechanism.getValue().asFloat());
        }
        if (mechanism.matches("skeleton_arms_raised") && mechanism.requireBoolean()) {
            EntityAnimation entityAnimation = NMSHandler.getAnimationHelper().getEntityAnimation(mechanism.getValue().asBoolean() ? "SKELETON_START_SWING_ARM" : "SKELETON_STOP_SWING_ARM");
            entityAnimation.play(this.entity);
        }
        if (mechanism.matches("polar_bear_standing") && mechanism.requireBoolean()) {
            EntityAnimation entityAnimation = NMSHandler.getAnimationHelper().getEntityAnimation(mechanism.getValue().asBoolean() ? "POLAR_BEAR_START_STANDING" : "POLAR_BEAR_STOP_STANDING");
            entityAnimation.play(this.entity);
        }
        if (mechanism.matches("ghast_attacking") && mechanism.requireBoolean()) {
            NMSHandler.getEntityHelper().setGhastAttacking(this.getBukkitEntity(), mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("enderman_angry") && mechanism.requireBoolean()) {
            NMSHandler.getEntityHelper().setEndermanAngry(this.getBukkitEntity(), mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("melee_attack") && mechanism.requireObject(EntityTag.class)) {
            this.getLivingEntity().attack(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }

    private class DespawnedEntity {
        Double health = null;
        Location location = null;
        ItemStack[] equipment = null;
        String custom_script = null;

        public DespawnedEntity(EntityTag entity) {
            if (entity != null) {
                this.health = entity.getLivingEntity().getHealth();
                this.location = entity.getLivingEntity().getLocation();
                this.equipment = entity.getLivingEntity().getEquipment().getArmorContents();
                if (CustomNBT.hasCustomNBT((Entity)entity.getLivingEntity(), "denizen-script-id")) {
                    this.custom_script = CustomNBT.getCustomNBT((Entity)entity.getLivingEntity(), "denizen-script-id");
                }
            }
        }
    }
}

