/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.TargetType;

public class AttackCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel", "stop")) {
                scriptEntry.addObject("cancel", "true");
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentType(dEntity.class) && arg.matchesPrefix("target", "t")) {
                scriptEntry.addObject("target", arg.asType(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class) && !arg.matchesPrefix("target", "t")) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("target")) {
            scriptEntry.addObject("target", ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getDenizenEntity() : null);
        }
        scriptEntry.defaultObject("entities", ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() ? Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getDenizenEntity()) : null);
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!scriptEntry.hasObject("target") && !scriptEntry.hasObject("cancel")) {
            throw new InvalidArgumentsException("Must specify a target!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List entities = (List)scriptEntry.getObject("entities");
        dEntity target = (dEntity)scriptEntry.getObject("target");
        boolean cancel = scriptEntry.hasObject("cancel");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), (cancel ? aH.debugObj("cancel", "true") : "") + aH.debugObj("entities", entities.toString()) + (target != null ? aH.debugObj("target", target) : ""));
        }
        for (dEntity entity : entities) {
            if (entity.isCitizensNPC()) {
                Navigator nav = entity.getDenizenNPC().getCitizen().getNavigator();
                if (!cancel) {
                    nav.setTarget(target.getBukkitEntity(), true);
                    continue;
                }
                if (!nav.isNavigating() || !nav.getTargetType().equals((Object)TargetType.ENTITY) || !nav.getEntityTarget().isAggressive()) continue;
                nav.cancelNavigation();
                continue;
            }
            if (!cancel) {
                entity.target(target.getLivingEntity());
                continue;
            }
            entity.target(null);
        }
    }
}

