/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.jnbt.StringTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.objects.properties.item.ItemBook;
import com.denizenscript.denizen.objects.properties.item.ItemColor;
import com.denizenscript.denizen.objects.properties.item.ItemDurability;
import com.denizenscript.denizen.objects.properties.item.ItemFirework;
import com.denizenscript.denizen.objects.properties.item.ItemInventory;
import com.denizenscript.denizen.objects.properties.item.ItemLock;
import com.denizenscript.denizen.scripts.containers.core.BookScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.nbt.CustomNBT;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.MapTagFlagTracker;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemTag
implements ObjectTag,
Notable,
Adjustable,
FlaggableObject {
    private ItemStack item;
    public ItemMeta metaCache;
    public AbstractFlagTracker flagTrackerCache;
    private String prefix = this.getObjectType();
    public static ObjectTagProcessor<ItemTag> tagProcessor = new ObjectTagProcessor();

    @Deprecated
    public static ItemTag valueOf(String string) {
        return ItemTag.valueOf(string, null);
    }

    public static ItemTag valueOf(String string, PlayerTag player, NPCTag npc) {
        return ItemTag.valueOf(string, new BukkitTagContext(player, npc, null));
    }

    public static ItemTag valueOf(String string, Debuggable debugMe) {
        return ItemTag.valueOf(string, new BukkitTagContext(null, null, null, debugMe == null || debugMe.shouldDebug(), null));
    }

    public static ItemTag valueOf(String string, boolean debugMe) {
        return ItemTag.valueOf(string, new BukkitTagContext(null, null, null, debugMe, null));
    }

    @Fetchable(value="i")
    public static ItemTag valueOf(String string, TagContext context) {
        block18: {
            ItemTag stack;
            block17: {
                if (string == null || string.equals("")) {
                    return null;
                }
                stack = null;
                if (ObjectFetcher.isObjectWithProperties(string)) {
                    return ObjectFetcher.getObjectFromWithProperties(ItemTag.class, string, context);
                }
                Notable noted = NotableManager.getSavedObject(string);
                if (noted instanceof ItemTag) {
                    Deprecations.notableItems.warn();
                    return (ItemTag)noted;
                }
                if (string.startsWith("i@")) {
                    string = string.substring("i@".length());
                }
                string = CoreUtilities.toLowerCase(string);
                try {
                    BookScriptContainer book;
                    if (ScriptRegistry.containsScript(string, ItemScriptContainer.class)) {
                        ItemScriptContainer isc = ScriptRegistry.getScriptContainerAs(string, ItemScriptContainer.class);
                        stack = isc.getItemFrom(context);
                        if (stack == null && (context == null || context.showErrors())) {
                            Debug.echoError("Item script '" + isc.getName() + "' returned a null item.");
                        }
                    } else if (ScriptRegistry.containsScript(string, BookScriptContainer.class) && (stack = (book = ScriptRegistry.getScriptContainerAs(string, BookScriptContainer.class)).getBookFrom(context)) == null && (context == null || context.showErrors())) {
                        Debug.echoError("Book script '" + book.getName() + "' returned a null item.");
                    }
                    if (stack != null) {
                        return stack;
                    }
                }
                catch (Exception ex) {
                    if (!Debug.verbose) break block17;
                    Debug.echoError(ex);
                }
            }
            try {
                MaterialTag mat = MaterialTag.valueOf(string.toUpperCase(), context);
                if (mat != null) {
                    stack = new ItemTag(mat.getMaterial());
                }
                if (stack != null) {
                    return stack;
                }
            }
            catch (Exception ex) {
                if (!string.equalsIgnoreCase("none") && (context == null || context.showErrors())) {
                    Debug.log("Does not match a valid item ID or material: " + string);
                }
                if (!Debug.verbose) break block18;
                Debug.echoError(ex);
            }
        }
        if (context == null || context.showErrors()) {
            Debug.log("valueOf ItemTag returning null: " + string);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg == null) {
            return false;
        }
        if (CoreUtilities.toLowerCase(arg).startsWith("i@")) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, ItemScriptContainer.class)) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, BookScriptContainer.class)) {
            return true;
        }
        return ItemTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public static ItemTag getItemFor(ObjectTag object, TagContext context) {
        return object instanceof ItemTag ? (ItemTag)object : ItemTag.valueOf(object.toString(), context);
    }

    @Override
    public ObjectTag duplicate() {
        return new ItemTag(this.item.clone());
    }

    public ItemTag(Material material) {
        this(new ItemStack(material));
    }

    public ItemTag(Material material, int qty) {
        this(new ItemStack(material, qty));
    }

    public ItemTag(MaterialTag material, int qty) {
        this.item = new ItemStack(material.getMaterial(), qty);
    }

    public ItemTag(ItemStack item) {
        this.item = item == null || item.getType() == Material.AIR ? new ItemStack(Material.AIR, 0) : item;
    }

    public ItemTag(Item item) {
        this(item.getItemStack());
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        if (this.flagTrackerCache == null) {
            String value = CustomNBT.getCustomNBT(this.getItemStack(), "flags", "Denizen");
            if (value == null) {
                return new MapTagFlagTracker();
            }
            this.flagTrackerCache = new MapTagFlagTracker(value, CoreUtilities.noDebugContext);
        }
        return this.flagTrackerCache;
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
        this.setItemStack(CustomNBT.addCustomNBT(this.getItemStack(), "flags", tracker.toString(), "Denizen"));
        this.flagTrackerCache = tracker;
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public ItemMeta getItemMeta() {
        if (this.metaCache == null) {
            this.metaCache = this.item.getItemMeta();
        }
        return this.metaCache;
    }

    public void setItemMeta(ItemMeta meta) {
        this.metaCache = meta;
        this.item.setItemMeta(meta);
    }

    public void setItemStack(ItemStack item) {
        this.item = item;
        this.resetCache();
    }

    public void resetCache() {
        this.metaCache = null;
        this.flagTrackerCache = null;
    }

    public int comparesTo(ItemTag item) {
        return this.comparesTo(item.getItemStack());
    }

    public int comparesTo(ItemStack compared_to) {
        if (this.item == null) {
            return -1;
        }
        int determination = 0;
        ItemStack compared = this.getItemStack();
        if (compared.getType() != compared_to.getType()) {
            return -1;
        }
        if (compared_to.hasItemMeta()) {
            if (!compared.hasItemMeta()) {
                return -1;
            }
            ItemMeta thisMeta = this.getItemMeta();
            ItemMeta comparedItemMeta = compared_to.getItemMeta();
            if (comparedItemMeta.hasDisplayName()) {
                if (!thisMeta.hasDisplayName()) {
                    return -1;
                }
                if (comparedItemMeta.getDisplayName().toUpperCase().startsWith(thisMeta.getDisplayName().toUpperCase())) {
                    if (thisMeta.getDisplayName().length() > comparedItemMeta.getDisplayName().length()) {
                        ++determination;
                    }
                } else {
                    return -1;
                }
            }
            if (comparedItemMeta.hasLore()) {
                if (!thisMeta.hasLore()) {
                    return -1;
                }
                for (String string : comparedItemMeta.getLore()) {
                    if (thisMeta.getLore().contains(string)) continue;
                    return -1;
                }
                if (thisMeta.getLore().size() > comparedItemMeta.getLore().size()) {
                    ++determination;
                }
            }
            if (!comparedItemMeta.getEnchants().isEmpty()) {
                if (thisMeta.getEnchants().isEmpty()) {
                    return -1;
                }
                for (Map.Entry entry : comparedItemMeta.getEnchants().entrySet()) {
                    if (thisMeta.getEnchants().containsKey(entry.getKey()) && (Integer)thisMeta.getEnchants().get(entry.getKey()) >= (Integer)entry.getValue()) continue;
                    return -1;
                }
                if (thisMeta.getEnchants().size() > comparedItemMeta.getEnchants().size()) {
                    ++determination;
                }
            }
            if (this.isRepairable() && ((Damageable)thisMeta).getDamage() < ((Damageable)comparedItemMeta).getDamage()) {
                ++determination;
            }
        }
        return determination;
    }

    public boolean isItemscript() {
        return ItemScriptHelper.isItemscript(this.getItemStack());
    }

    public String getScriptName() {
        ItemScriptContainer cont = ItemScriptHelper.getItemScriptContainer(this.getItemStack());
        if (cont != null) {
            return cont.getName();
        }
        return null;
    }

    public void setItemScript(ItemScriptContainer script) {
        if (script.contains("NO_ID") && Boolean.valueOf(script.getString("NO_ID")).booleanValue()) {
            return;
        }
        this.setItemStack(NMSHandler.getItemHelper().addNbtData(this.getItemStack(), "DenizenItemScript", new StringTag(CoreUtilities.toLowerCase(script.getName()))));
    }

    public Material getBukkitMaterial() {
        return this.getItemStack().getType();
    }

    public MaterialTag getMaterial() {
        return new MaterialTag(this.getBukkitMaterial());
    }

    public String getMaterialName() {
        return CoreUtilities.toLowerCase(this.getBukkitMaterial().name());
    }

    public void setAmount(int value) {
        if (this.item != null) {
            this.item.setAmount(value);
        }
    }

    public int getAmount() {
        if (this.item != null) {
            return this.item.getAmount();
        }
        return 0;
    }

    public void setDurability(short value) {
        ItemMeta meta = this.getItemMeta();
        if (meta instanceof Damageable) {
            ((Damageable)meta).setDamage((int)value);
            this.setItemMeta(meta);
        }
    }

    public boolean isRepairable() {
        return this.getItemMeta() instanceof Damageable;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ItemTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String getObjectType() {
        return "Item";
    }

    @Override
    public String identify() {
        if (this.item == null || this.item.getType() == Material.AIR) {
            return "i@air";
        }
        if (this.isUnique()) {
            Deprecations.notableItems.warn();
            return "i@" + NotableManager.getSavedId(this) + PropertyParser.getPropertiesString(this);
        }
        return "i@" + this.getMaterial().identifyNoPropertiesNoIdentifier().replace("m@", "") + PropertyParser.getPropertiesString(this);
    }

    @Override
    public String identifySimple() {
        if (this.item == null) {
            return "null";
        }
        if (this.item.getType() != Material.AIR) {
            if (this.isUnique()) {
                Deprecations.notableItems.warn();
                return "i@" + NotableManager.getSavedId(this);
            }
            if (this.isItemscript()) {
                return "i@" + this.getScriptName();
            }
        }
        return "i@" + this.identifyMaterial().replace("m@", "");
    }

    public String identifyMaterial() {
        return this.getMaterial().identifySimple();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public boolean isUnique() {
        if (NotableManager.isSaved(this)) {
            Deprecations.notableItems.warn();
            return true;
        }
        return false;
    }

    @Override
    @Note(value="Items")
    public String getSaveObject() {
        return this.identify();
    }

    @Override
    public void makeUnique(String id) {
        Deprecations.notableItems.warn();
        NotableManager.saveAs(this, id);
    }

    @Override
    public void forget() {
        Deprecations.notableItems.warn();
        NotableManager.remove(this);
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        PropertyParser.registerPropertyTagHandlers(tagProcessor);
        ItemTag.registerTag("repairable", (attribute, object) -> new ElementTag(ItemDurability.describes(object)), new String[0]);
        ItemTag.registerTag("is_book", (attribute, object) -> new ElementTag(ItemBook.describes(object)), new String[0]);
        ItemTag.registerTag("is_colorable", (attribute, object) -> new ElementTag(ItemColor.describes(object)), new String[0]);
        ItemTag.registerTag("is_dyeable", (attribute, object) -> new ElementTag(ItemColor.describes(object)), new String[0]);
        ItemTag.registerTag("is_firework", (attribute, object) -> new ElementTag(ItemFirework.describes(object)), new String[0]);
        ItemTag.registerTag("has_inventory", (attribute, object) -> new ElementTag(ItemInventory.describes(object)), new String[0]);
        ItemTag.registerTag("is_lockable", (attribute, object) -> new ElementTag(ItemLock.describes(object)), new String[0]);
        ItemTag.registerTag("material", (attribute, object) -> {
            if (attribute.getAttribute(2).equals("formatted")) {
                return object;
            }
            if (object.getItemMeta() instanceof BlockStateMeta) {
                if (object.getBukkitMaterial() == Material.SHIELD) {
                    MaterialTag material = new MaterialTag(Material.SHIELD);
                    material.setModernData(((BlockStateMeta)object.getItemMeta()).getBlockState().getBlockData());
                    return material;
                }
                return new MaterialTag(((BlockStateMeta)object.getItemMeta()).getBlockState());
            }
            return object.getMaterial();
        }, new String[0]);
        ItemTag.registerTag("json", (attribute, object) -> new ElementTag(NMSHandler.getItemHelper().getJsonString(object.item)), new String[0]);
        ItemTag.registerTag("bukkit_serial", (attribute, object) -> {
            YamlConfiguration config = new YamlConfiguration();
            config.set("item", (Object)object.getItemStack());
            return new ElementTag(config.saveToString());
        }, new String[0]);
        ItemTag.registerTag("simple", (attribute, object) -> new ElementTag(object.identifySimple()), new String[0]);
        ItemTag.registerTag("recipe_ids", (attribute, object) -> {
            String type = attribute.hasContext(1) ? CoreUtilities.toLowerCase(attribute.getContext(1)) : null;
            ItemScriptContainer container = object.isItemscript() ? ItemScriptHelper.getItemScriptContainer(object.getItemStack()) : null;
            ListTag list = new ListTag();
            for (Recipe recipe : Bukkit.getRecipesFor((ItemStack)object.getItemStack())) {
                NamespacedKey key;
                if (!Utilities.isRecipeOfType(recipe, type) || !(recipe instanceof Keyed) || ((key = ((Keyed)recipe).getKey()).getNamespace().equalsIgnoreCase("denizen") ? container != ItemScriptHelper.recipeIdToItemScript.get(key.toString()) : container != null)) continue;
                list.add(key.toString());
            }
            return list;
        }, new String[0]);
        ItemTag.registerTag("notable_name", (attribute, object) -> {
            Deprecations.notableItems.warn();
            String noteName = NotableManager.getSavedId(object);
            if (noteName == null) {
                return null;
            }
            return new ElementTag(noteName);
        }, new String[0]);
        ItemTag.registerTag("formatted", (attribute, object) -> new ElementTag(object.formattedName()), new String[0]);
        ItemTag.registerTag("advanced_matches", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(BukkitScriptEvent.tryItem(object, attribute.getContext(1)));
        }, new String[0]);
    }

    public String formattedName() {
        String id = CoreUtilities.toLowerCase(this.getMaterial().name()).replace('_', ' ');
        if (id.equals("air")) {
            return "nothing";
        }
        if (id.equals("ice") || id.equals("dirt")) {
            return id;
        }
        if (this.getItemStack().getAmount() > 1) {
            if (id.equals("cactus")) {
                return "cactuses";
            }
            if (id.endsWith(" off")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith(" on")) {
                id = id.substring(0, id.length() - 3);
            }
            if (id.equals("rotten flesh") || id.equals("cooked fish") || id.equals("raw fish") || id.endsWith("s")) {
                return id;
            }
            if (id.endsWith("y")) {
                return id.substring(0, id.length() - 1) + "ies";
            }
            if (id.endsWith("sh") || id.endsWith("ch")) {
                return id + "es";
            }
            return id + "s";
        }
        if (id.equals("cactus")) {
            return "a cactus";
        }
        if (id.endsWith("s")) {
            return id;
        }
        if (id.endsWith(" off")) {
            return "a " + id.substring(0, id.length() - 4);
        }
        if (id.endsWith(" on")) {
            return "a " + id.substring(0, id.length() - 3);
        }
        if (id.startsWith("a") || id.startsWith("e") || id.startsWith("i") || id.startsWith("o") || id.startsWith("u")) {
            return "an " + id;
        }
        return "a " + id;
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<ItemTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        if (NotableManager.isExactSavedObject(this)) {
            Deprecations.notableItems.warn();
            Debug.echoError("Cannot apply properties to noted objects.");
            return;
        }
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("material") && mechanism.requireObject(MaterialTag.class)) {
            this.item.setType(mechanism.valueAsType(MaterialTag.class).getMaterial());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

