/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.interfaces;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.util.BoundingBox;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public abstract class EntityHelper {
    public static UUID DEFAULT_HIDE = new UUID(0L, 0L);
    public static Map<UUID, Set<UUID>> hiddenEntitiesEntPl = new HashMap<UUID, Set<UUID>>();
    public static Map<UUID, Set<UUID>> hiddenEntitiesPlEnt = new HashMap<UUID, Set<UUID>>();
    public static EnforcePlayerHides EPH = null;
    public static Set<UUID> hiddenByDefaultPlayers = new HashSet<UUID>();

    public void setInvisible(Entity entity, boolean invisible) {
    }

    public abstract double getAbsorption(LivingEntity var1);

    public abstract void setAbsorption(LivingEntity var1, double var2);

    public abstract void setSneaking(Entity var1, boolean var2);

    public abstract double getDamageTo(LivingEntity var1, Entity var2);

    public abstract String getRawHoverText(Entity var1);

    public List<String> getDiscoveredRecipes(Player player) {
        throw new UnsupportedOperationException();
    }

    public void setRiptide(Entity entity, boolean state) {
        Debug.echoError("Riptide control not available on this server version.");
    }

    public void setCarriedItem(Enderman entity, ItemStack item) {
        entity.setCarriedMaterial(item.getData());
    }

    public abstract int getBodyArrows(Entity var1);

    public abstract void setBodyArrows(Entity var1, int var2);

    public abstract double getArrowDamage(Entity var1);

    public abstract void setArrowDamage(Entity var1, double var2);

    public abstract String getArrowPickupStatus(Entity var1);

    public abstract void setArrowPickupStatus(Entity var1, String var2);

    public abstract Entity getFishHook(PlayerFishEvent var1);

    public abstract ItemStack getItemFromTrident(Entity var1);

    public abstract void setItemForTrident(Entity var1, ItemStack var2);

    public abstract void forceInteraction(Player var1, Location var2);

    public abstract Entity getEntity(World var1, UUID var2);

    public abstract void setTarget(Creature var1, LivingEntity var2);

    public abstract CompoundTag getNbtData(Entity var1);

    public abstract void setNbtData(Entity var1, CompoundTag var2);

    public abstract void stopFollowing(Entity var1);

    public abstract void stopWalking(Entity var1);

    public abstract double getSpeed(Entity var1);

    public abstract void setSpeed(Entity var1, double var2);

    public abstract void follow(Entity var1, Entity var2, double var3, double var5, double var7, boolean var9, boolean var10);

    public abstract void walkTo(LivingEntity var1, Location var2, double var3, Runnable var5);

    public void ensurePlayerHiding() {
        if (EPH == null) {
            Plugin pl = Bukkit.getPluginManager().getPlugin("Denizen");
            EPH = new EnforcePlayerHides();
            EntityHelper.EPH.denizenPlugin = pl;
            Bukkit.getPluginManager().registerEvents((Listener)EPH, pl);
        }
    }

    public boolean addHide(UUID player, UUID entity) {
        Set hidden = hiddenEntitiesEntPl.computeIfAbsent(entity, k -> new HashSet());
        if (player.equals(DEFAULT_HIDE)) {
            for (UUID pl : hidden) {
                Set<UUID> plHid = hiddenEntitiesPlEnt.get(pl);
                if (plHid == null) continue;
                plHid.remove(entity);
            }
            hidden.clear();
        } else {
            Set plHid = hiddenEntitiesPlEnt.computeIfAbsent(player, k -> new HashSet());
            plHid.add(entity);
        }
        return hidden.add(player);
    }

    public void hideEntity(Player player, Entity entity) {
        if (player == null) {
            this.addHide(DEFAULT_HIDE, entity.getUniqueId());
            if (entity instanceof Player) {
                hiddenByDefaultPlayers.add(entity.getUniqueId());
            }
            for (Player pl : Bukkit.getOnlinePlayers()) {
                this.sendHidePacket(pl, entity);
            }
            return;
        }
        if (this.isHiddenByDefault(entity.getUniqueId())) {
            EntityHelper.removeHide(player.getUniqueId(), entity.getUniqueId());
        } else {
            this.addHide(player.getUniqueId(), entity.getUniqueId());
        }
        this.sendHidePacket(player, entity);
    }

    public static boolean removeHide(UUID player, UUID entity) {
        Set<UUID> hidden = hiddenEntitiesEntPl.get(entity);
        if (hidden == null) {
            return false;
        }
        boolean toRet = hidden.remove(player);
        if (player.equals(DEFAULT_HIDE)) {
            for (UUID pl : hidden) {
                Set<UUID> plHid = hiddenEntitiesPlEnt.get(pl);
                if (plHid == null) continue;
                plHid.remove(entity);
            }
            hidden.clear();
        } else {
            Set<UUID> plHid = hiddenEntitiesPlEnt.get(player);
            if (plHid != null) {
                plHid.remove(entity);
            }
        }
        return toRet;
    }

    public void unhideEntity(Player player, Entity entity) {
        if (player == null) {
            EntityHelper.removeHide(DEFAULT_HIDE, entity.getUniqueId());
            if (entity instanceof Player) {
                hiddenByDefaultPlayers.remove(entity.getUniqueId());
            }
            for (Player pl : Bukkit.getOnlinePlayers()) {
                this.sendShowPacket(pl, entity);
            }
            return;
        }
        if (this.isHiddenByDefault(entity.getUniqueId())) {
            this.addHide(player.getUniqueId(), entity.getUniqueId());
        } else {
            EntityHelper.removeHide(player.getUniqueId(), entity.getUniqueId());
        }
        this.sendShowPacket(player, entity);
    }

    public boolean isHiddenByDefault(UUID id) {
        Set<UUID> hiding = hiddenEntitiesEntPl.get(id);
        return hiding != null && hiding.contains(DEFAULT_HIDE);
    }

    public boolean isHidden(Player player, UUID id) {
        if (this.isHiddenByDefault(id)) {
            Set<UUID> hiding = hiddenEntitiesEntPl.get(id);
            return hiding == null || !hiding.contains(player.getUniqueId());
        }
        Set<UUID> hiding = hiddenEntitiesEntPl.get(id);
        return hiding != null && hiding.contains(player.getUniqueId());
    }

    public abstract void sendHidePacket(Player var1, Entity var2);

    public abstract void sendShowPacket(Player var1, Entity var2);

    public abstract void rotate(Entity var1, float var2, float var3);

    public abstract float getBaseYaw(Entity var1);

    public abstract void look(Entity var1, float var2, float var3);

    public abstract boolean canTrace(World var1, Vector var2, Vector var3);

    public abstract MapTraceResult mapTrace(LivingEntity var1, double var2);

    public Location faceLocation(Location from, Location at) {
        Vector direction = from.toVector().subtract(at.toVector()).normalize();
        Location newLocation = from.clone();
        newLocation.setYaw(180.0f - (float)Math.toDegrees(Math.atan2(direction.getX(), direction.getZ())));
        newLocation.setPitch(90.0f - (float)Math.toDegrees(Math.acos(direction.getY())));
        return newLocation;
    }

    public void faceLocation(Entity from, Location at) {
        if (from.getWorld() != at.getWorld()) {
            return;
        }
        Location origin = from instanceof LivingEntity ? ((LivingEntity)from).getEyeLocation() : new LocationTag(from.getLocation()).getBlockLocation().add(0.5, 0.5, 0.5);
        Location rotated = this.faceLocation(origin, at);
        this.rotate(from, rotated.getYaw(), rotated.getPitch());
    }

    public boolean isFacingLocation(Location from, Location at, float yawLimitDegrees, float pitchLimitDegrees) {
        Vector direction = from.toVector().subtract(at.toVector()).normalize();
        float pitch = 90.0f - (float)Math.toDegrees(Math.acos(direction.getY()));
        if (from.getPitch() > pitch + pitchLimitDegrees || from.getPitch() < pitch - pitchLimitDegrees) {
            return false;
        }
        return this.isFacingLocation(from, at, yawLimitDegrees);
    }

    public boolean isFacingLocation(Location from, Location at, float degreeLimit) {
        double currentYaw = EntityHelper.normalizeYaw(from.getYaw());
        double requiredYaw = EntityHelper.normalizeYaw(this.getYaw(at.toVector().subtract(from.toVector()).normalize()));
        return Math.abs(requiredYaw - currentYaw) < (double)degreeLimit || Math.abs(requiredYaw + 360.0 - currentYaw) < (double)degreeLimit || Math.abs(currentYaw + 360.0 - requiredYaw) < (double)degreeLimit;
    }

    public boolean isFacingLocation(Entity from, Location at, float degreeLimit) {
        return this.isFacingLocation(from.getLocation(), at, degreeLimit);
    }

    public boolean isFacingEntity(Entity from, Entity at, float degreeLimit) {
        return this.isFacingLocation(from.getLocation(), at.getLocation(), degreeLimit);
    }

    public static float normalizeYaw(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw = (float)((double)yaw + 360.0);
        }
        return yaw;
    }

    public float getYaw(Vector vector) {
        double dx = vector.getX();
        double dz = vector.getZ();
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        return (float)(-yaw * 180.0 / Math.PI);
    }

    public String getCardinal(float yaw) {
        if (0.0f <= (yaw = EntityHelper.normalizeYaw(yaw)) && (double)yaw < 22.5) {
            return "south";
        }
        if (22.5 <= (double)yaw && (double)yaw < 67.5) {
            return "southwest";
        }
        if (67.5 <= (double)yaw && (double)yaw < 112.5) {
            return "west";
        }
        if (112.5 <= (double)yaw && (double)yaw < 157.5) {
            return "northwest";
        }
        if (157.5 <= (double)yaw && (double)yaw < 202.5) {
            return "north";
        }
        if (202.5 <= (double)yaw && (double)yaw < 247.5) {
            return "northeast";
        }
        if (247.5 <= (double)yaw && (double)yaw < 292.5) {
            return "east";
        }
        if (292.5 <= (double)yaw && (double)yaw < 337.5) {
            return "southeast";
        }
        if (337.5 <= (double)yaw && (double)yaw < 360.0) {
            return "south";
        }
        return null;
    }

    public abstract void snapPositionTo(Entity var1, Vector var2);

    public abstract void move(Entity var1, Vector var2);

    public abstract void teleport(Entity var1, Location var2);

    public abstract BoundingBox getBoundingBox(Entity var1);

    public abstract void setBoundingBox(Entity var1, BoundingBox var2);

    public abstract boolean isChestedHorse(Entity var1);

    public abstract boolean isCarryingChest(Entity var1);

    public abstract void setCarryingChest(Entity var1, boolean var2);

    public List<Player> getPlayersThatSee(Entity entity) {
        throw new UnsupportedOperationException();
    }

    public void setTicksLived(Entity entity, int ticks) {
        entity.setTicksLived(ticks);
    }

    public int getShulkerPeek(Entity entity) {
        throw new UnsupportedOperationException();
    }

    public void setShulkerPeek(Entity entity, int peek) {
        throw new UnsupportedOperationException();
    }

    public void setHeadAngle(Entity entity, float angle) {
        throw new UnsupportedOperationException();
    }

    public void setGhastAttacking(Entity entity, boolean attacking) {
        throw new UnsupportedOperationException();
    }

    public void setEndermanAngry(Entity entity, boolean angry) {
        throw new UnsupportedOperationException();
    }

    public static class MapTraceResult {
        public Location hitLocation;
        public BlockFace angle;
    }

    public class EnforcePlayerHides
    implements Listener {
        public Plugin denizenPlugin;

        @EventHandler
        public void onPlayerJoin(PlayerJoinEvent event) {
            for (UUID id : hiddenByDefaultPlayers) {
                Entity pTarget = Bukkit.getEntity((UUID)id);
                if (!(pTarget instanceof Player)) continue;
                event.getPlayer().hidePlayer((Plugin)Denizen.getInstance(), (Player)pTarget);
            }
            final Player pl = event.getPlayer();
            final Set<UUID> hides = hiddenEntitiesPlEnt.get(pl.getUniqueId());
            if (hides == null || hides.isEmpty()) {
                return;
            }
            new BukkitRunnable(){

                public void run() {
                    if (pl.isOnline()) {
                        for (UUID id : hides) {
                            Entity ent = Bukkit.getEntity((UUID)id);
                            if (ent == null) continue;
                            EntityHelper.this.sendHidePacket(pl, ent);
                        }
                    }
                }
            }.runTaskLater(this.denizenPlugin, 5L);
        }
    }
}

