/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.scripts.commands.entity.WalkCommandCitizensEvents;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class WalkCommand
extends AbstractCommand
implements Holdable {
    public static List<ScriptEntry> held = new ArrayList<ScriptEntry>();

    public WalkCommand() {
        this.setName("walk");
        this.setSyntax("walk (<entity>|...) [<location>/stop] (speed:<#.#>) (auto_range) (radius:<#.#>) (lookat:<location>)");
        this.setRequiredArguments(1, 6);
        if (Depends.citizens != null) {
            Denizen.getInstance().getServer().getPluginManager().registerEvents((Listener)new WalkCommandCitizensEvents(), (Plugin)Denizen.getInstance());
        }
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (Notable note : NotableManager.notesByType.get(LocationTag.class)) {
            addOne.accept(NotableManager.getSavedId(note));
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("lookat") && arg.matchesPrefix("lookat") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("lookat", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesFloat() && arg.matchesPrefix("s", "speed")) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("auto_range") && arg.matches("auto_range")) {
                scriptEntry.addObject("auto_range", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesFloat() && arg.matchesPrefix("radius")) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("stop") && arg.matches("stop")) {
                scriptEntry.addObject("stop", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location") && !scriptEntry.hasObject("stop")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        if (!scriptEntry.hasObject("entities")) {
            if (Utilities.getEntryNPC(scriptEntry) == null || !Utilities.getEntryNPC(scriptEntry).isValid() || !Utilities.getEntryNPC(scriptEntry).isSpawned()) {
                throw new InvalidArgumentsException("Must have a valid spawned NPC attached.");
            }
            scriptEntry.addObject("entities", Collections.singletonList(Utilities.getEntryNPC(scriptEntry).getDenizenEntity()));
        }
        scriptEntry.defaultObject("stop", new ElementTag(false));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag loc = (LocationTag)scriptEntry.getObjectTag("location");
        ElementTag speed = scriptEntry.getElement("speed");
        ElementTag auto_range = scriptEntry.getElement("auto_range");
        ElementTag radius = scriptEntry.getElement("radius");
        ElementTag stop = scriptEntry.getElement("stop");
        List entities = (List)scriptEntry.getObject("entities");
        LocationTag lookat = (LocationTag)scriptEntry.getObjectTag("lookat");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (loc != null ? loc.debug() : "") + (speed != null ? speed.debug() : "") + (auto_range != null ? auto_range.debug() : "") + (radius != null ? radius.debug() : "") + (lookat != null ? lookat.debug() : "") + stop.debug() + ArgumentHelper.debugObj("entities", entities));
        }
        boolean shouldStop = stop.asBoolean();
        ArrayList<NPCTag> npcs = new ArrayList<NPCTag>();
        ArrayList<EntityTag> waitForEntities = new ArrayList<EntityTag>();
        for (EntityTag entity : entities) {
            if (entity.isCitizensNPC()) {
                NPCTag npc = entity.getDenizenNPC();
                npcs.add(npc);
                if (!npc.isSpawned()) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "NPC " + npc.identify() + " is not spawned!");
                    continue;
                }
                if (shouldStop) {
                    npc.getNavigator().cancelNavigation();
                    continue;
                }
                if (auto_range != null && auto_range.asBoolean()) {
                    double distance = npc.getLocation().distance(loc);
                    if ((double)npc.getNavigator().getLocalParameters().range() < distance + 10.0) {
                        npc.getNavigator().getLocalParameters().range((float)distance + 10.0f);
                    }
                }
                npc.getNavigator().setTarget((Location)loc);
                if (lookat != null) {
                    npc.getNavigator().getLocalParameters().lookAtFunction(nav -> lookat);
                }
                if (speed != null) {
                    npc.getNavigator().getLocalParameters().speedModifier(speed.asFloat());
                }
                if (radius == null) continue;
                npc.getNavigator().getLocalParameters().addRunCallback((Runnable)WalkCommandCitizensEvents.generateNewFlocker(npc.getCitizen(), radius.asDouble()));
                continue;
            }
            if (shouldStop) {
                NMSHandler.getEntityHelper().stopWalking(entity.getBukkitEntity());
                continue;
            }
            waitForEntities.add(entity);
            NMSHandler.getEntityHelper().walkTo(entity.getLivingEntity(), loc, speed != null ? speed.asDouble() : 0.2, () -> this.checkHeld(entity));
        }
        if (scriptEntry.shouldWaitFor()) {
            held.add(scriptEntry);
            if (!npcs.isEmpty()) {
                scriptEntry.addObject("tally", npcs);
            }
            if (!waitForEntities.isEmpty()) {
                scriptEntry.addObject("entities", waitForEntities);
            }
        }
    }

    public void checkHeld(EntityTag entity) {
        for (int i = 0; i < held.size(); ++i) {
            ScriptEntry entry = held.get(i);
            List waitForEntities = (List)entry.getObject("entities");
            if (waitForEntities == null) continue;
            waitForEntities.remove(entity);
            if (!waitForEntities.isEmpty() || entry.hasObject("tally") && !((List)entry.getObject("tally")).isEmpty()) continue;
            entry.setFinished(true);
            held.remove(i);
            --i;
        }
    }
}

