/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.FormatScriptContainer;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;

public class ActionBarCommand
extends AbstractCommand {
    public ActionBarCommand() {
        this.setName("actionbar");
        this.setSyntax("actionbar [<text>] (targets:<player>|...) (format:<name>) (per_player)");
        this.setRequiredArguments(1, 4);
        this.setParseArgs(false);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : ArgumentHelper.interpret(scriptEntry, scriptEntry.getOriginalArguments())) {
            if (!scriptEntry.hasObject("format") && arg.matchesPrefix("format", "f")) {
                String formatStr = TagManager.tag(arg.getValue(), scriptEntry.getContext());
                FormatScriptContainer format = (FormatScriptContainer)ScriptRegistry.getScriptContainer(formatStr);
                if (format == null) {
                    Debug.echoError("Could not find format script matching '" + formatStr + "'");
                }
                scriptEntry.addObject("format", new ScriptTag(format));
                continue;
            }
            if (!scriptEntry.hasObject("targets") && arg.matchesPrefix("targets", "target")) {
                scriptEntry.addObject("targets", ListTag.getListFor(TagManager.tagObject(arg.getValue(), scriptEntry.getContext()), scriptEntry.getContext()).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("per_player") && arg.matches("per_player")) {
                scriptEntry.addObject("per_player", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("text")) {
                scriptEntry.addObject("text", new ElementTag(arg.getRawValue()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("text")) {
            throw new InvalidArgumentsException("Must specify a message!");
        }
        if (!scriptEntry.hasObject("targets") && !Utilities.entryHasPlayer(scriptEntry)) {
            throw new InvalidArgumentsException("Must specify target(s).");
        }
        if (!scriptEntry.hasObject("targets")) {
            if (!Utilities.entryHasPlayer(scriptEntry)) {
                throw new InvalidArgumentsException("Must specify valid player Targets!");
            }
            scriptEntry.addObject("targets", Collections.singletonList(Utilities.getEntryPlayer(scriptEntry)));
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List targets = (List)scriptEntry.getObject("targets");
        String text = scriptEntry.getElement("text").asString();
        ScriptTag formatObj = (ScriptTag)scriptEntry.getObjectTag("format");
        ElementTag perPlayerObj = scriptEntry.getElement("per_player");
        boolean perPlayer = perPlayerObj != null && perPlayerObj.asBoolean();
        BukkitTagContext context = (BukkitTagContext)scriptEntry.getContext();
        if (!perPlayer) {
            text = TagManager.tag(text, context);
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("Message", text) + ArgumentHelper.debugList("Targets", targets) + (formatObj != null ? formatObj.debug() : "") + (perPlayerObj != null ? perPlayerObj.debug() : ""));
        }
        FormatScriptContainer format = formatObj == null ? null : (FormatScriptContainer)formatObj.getContainer();
        for (PlayerTag player : targets) {
            if (player != null) {
                if (!player.isOnline()) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Player is offline, can't send actionbar to them. Skipping.");
                    continue;
                }
                String personalText = text;
                if (perPlayer) {
                    context.player = player;
                    personalText = TagManager.tag(personalText, context);
                }
                player.getPlayerEntity().spigot().sendMessage(ChatMessageType.ACTION_BAR, FormattedTextHelper.parse(format != null ? format.getFormattedText(personalText, scriptEntry) : personalText, ChatColor.WHITE));
                continue;
            }
            Debug.echoError("Sent actionbar to non-existent player!?");
        }
    }
}

