/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class FakeEquipCommand
extends AbstractCommand {
    public static HashMap<UUID, HashMap<UUID, EquipmentOverride>> overrides = new HashMap();

    public FakeEquipCommand() {
        this.setName("fakeequip");
        this.setSyntax("fakeequip [<entity>|...] (for:<player>|...) (duration:<duration>/reset) (hand:<item>) (offhand:<item>) (head:<item>) (chest:<item>) (legs:<item>) (boots:<item>)");
        this.setRequiredArguments(1, 9);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        EquipmentOverride equipment = new EquipmentOverride();
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (arg.matchesPrefix("duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.matches("reset")) {
                scriptEntry.addObject("reset", new ElementTag(true));
                continue;
            }
            if (arg.matchesPrefix("for") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("for", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (arg.matchesPrefix("head", "helmet") && arg.matchesArgumentType(ItemTag.class)) {
                equipment.head = arg.asType(ItemTag.class);
                continue;
            }
            if (arg.matchesPrefix("chest", "chestplate") && arg.matchesArgumentType(ItemTag.class)) {
                equipment.chest = arg.asType(ItemTag.class);
                continue;
            }
            if (arg.matchesPrefix("legs", "leggings") && arg.matchesArgumentType(ItemTag.class)) {
                equipment.legs = arg.asType(ItemTag.class);
                continue;
            }
            if (arg.matchesPrefix("boots", "feet") && arg.matchesArgumentType(ItemTag.class)) {
                equipment.boots = arg.asType(ItemTag.class);
                continue;
            }
            if (arg.matchesPrefix("offhand") && arg.matchesArgumentType(ItemTag.class)) {
                equipment.offhand = arg.asType(ItemTag.class);
                continue;
            }
            if (arg.matchesPrefix("hand") && arg.matchesArgumentType(ItemTag.class)) {
                equipment.hand = arg.asType(ItemTag.class);
                continue;
            }
            arg.reportUnhandled();
        }
        if (equipment.isEmpty() && !scriptEntry.hasObject("reset")) {
            throw new InvalidArgumentsException("Must specify equipment!");
        }
        if (!scriptEntry.hasObject("for")) {
            PlayerTag player = Utilities.getEntryPlayer(scriptEntry);
            if (player == null) {
                throw new InvalidArgumentsException("Must specify a for player!");
            }
            scriptEntry.addObject("for", Collections.singletonList(player));
        }
        scriptEntry.addObject("equipment", equipment);
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        EquipmentOverride equipment = (EquipmentOverride)scriptEntry.getObject("equipment");
        List entities = (List)scriptEntry.getObject("entities");
        List playersFor = (List)scriptEntry.getObject("for");
        ElementTag reset = scriptEntry.getElement("reset");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("entities", entities.toString()) + ArgumentHelper.debugObj("equipment", equipment.toString()) + (reset == null ? "" : reset.debug()) + (duration == null ? "" : duration.debug()) + ArgumentHelper.debugList("for", playersFor));
        }
        boolean isReset = reset != null && reset.asBoolean();
        for (final PlayerTag player : playersFor) {
            HashMap playersMap = overrides.computeIfAbsent(player.getUUID(), k -> new HashMap());
            for (final EntityTag entity : entities) {
                EquipmentOverride entityData;
                if (entity.isGeneric()) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Cannot equip generic entity " + entity.identify() + "!");
                    continue;
                }
                final LivingEntity livingEntity = entity.getLivingEntity();
                if (livingEntity == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Cannot equip invalid/non-living entity " + entity.identify() + "!");
                    continue;
                }
                if (isReset) {
                    entityData = (EquipmentOverride)playersMap.remove(entity.getUUID());
                    if (playersMap.isEmpty()) {
                        overrides.remove(player.getUUID());
                    }
                } else {
                    entityData = playersMap.computeIfAbsent(entity.getUUID(), k -> new EquipmentOverride());
                    entityData.copyFrom(equipment);
                }
                if (entityData != null) {
                    if (entityData.cancelTask != null && !entityData.cancelTask.isCancelled()) {
                        entityData.cancelTask.cancel();
                        entityData.cancelTask = null;
                    }
                    if (duration != null && duration.getTicks() > 0L) {
                        entityData.cancelTask = new BukkitRunnable(){

                            public void run() {
                                entityData.cancelTask = null;
                                HashMap<UUID, EquipmentOverride> playersMap = overrides.get(player.getUUID());
                                if (playersMap != null && playersMap.remove(entity.getUUID()) != null) {
                                    if (playersMap.isEmpty()) {
                                        overrides.remove(player.getUUID());
                                    }
                                    NMSHandler.getPacketHelper().resetEquipment(player.getPlayerEntity(), livingEntity);
                                }
                            }
                        }.runTaskLater((Plugin)Denizen.getInstance(), duration.getTicks());
                    }
                }
                NMSHandler.getPacketHelper().resetEquipment(player.getPlayerEntity(), livingEntity);
            }
        }
    }

    public static class EquipmentOverride {
        public ItemTag hand;
        public ItemTag offhand;
        public ItemTag head;
        public ItemTag chest;
        public ItemTag legs;
        public ItemTag boots;
        public BukkitTask cancelTask;

        public boolean isEmpty() {
            return this.hand == null && this.offhand == null && this.head == null && this.chest == null && this.legs == null && this.boots == null;
        }

        public String toString() {
            return "Equipment{hand=" + this.hand + ",offhand=" + this.offhand + ",head=" + this.head + ",chest=" + this.chest + ",legs=" + this.legs + ",boots=" + this.boots + "}";
        }

        public void copyFrom(EquipmentOverride override) {
            this.hand = override.hand == null ? this.hand : override.hand;
            this.offhand = override.offhand == null ? this.offhand : override.offhand;
            this.head = override.head == null ? this.head : override.head;
            this.chest = override.chest == null ? this.chest : override.chest;
            this.legs = override.legs == null ? this.legs : override.legs;
            this.boots = override.boots == null ? this.boots : override.boots;
        }
    }
}

