/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.BracedCommand;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ForeachCommand
extends BracedCommand {
    public ForeachCommand() {
        this.setName("foreach");
        this.setSyntax("foreach [stop/next/<object>|...] (as:<name>) (key:<name>) [<commands>]");
        this.setRequiredArguments(1, 3);
        this.isProcedural = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean handled = false;
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!handled && arg.matches("stop")) {
                scriptEntry.addObject("stop", new ElementTag(true));
                handled = true;
                continue;
            }
            if (!handled && arg.matches("next")) {
                scriptEntry.addObject("next", new ElementTag(true));
                handled = true;
                continue;
            }
            if (!handled && arg.matches("\u0000callback")) {
                scriptEntry.addObject("callback", new ElementTag(true));
                handled = true;
                continue;
            }
            if (!scriptEntry.hasObject("as_name") && arg.matchesPrefix("as")) {
                scriptEntry.addObject("as_name", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("key_as") && arg.matchesPrefix("key")) {
                scriptEntry.addObject("key_as", arg.asElement());
                continue;
            }
            if (!handled) {
                if (arg.object instanceof MapTag || arg.object.toString().startsWith("map@")) {
                    scriptEntry.addObject("map", MapTag.getMapFor(arg.object, scriptEntry.context));
                } else {
                    scriptEntry.addObject("list", arg.object instanceof ListTag ? (ListTag)arg.object : ListTag.valueOf(arg.getRawValue(), scriptEntry.getContext()));
                }
                handled = true;
                continue;
            }
            if (arg.matches("{")) break;
            arg.reportUnhandled();
        }
        if (!handled) {
            throw new InvalidArgumentsException("Must specify a valid list or 'stop' or 'next'!");
        }
        scriptEntry.defaultObject("key_as", new ElementTag("key"));
        scriptEntry.defaultObject("as_name", new ElementTag("value"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag stop = scriptEntry.getElement("stop");
        ElementTag next = scriptEntry.getElement("next");
        ElementTag callback = scriptEntry.getElement("callback");
        ListTag list = (ListTag)scriptEntry.getObjectTag("list");
        MapTag map = (MapTag)scriptEntry.getObjectTag("map");
        ElementTag as_name = scriptEntry.getElement("as_name");
        ElementTag key_as = scriptEntry.getElement("key_as");
        ScriptQueue queue = scriptEntry.getResidingQueue();
        if (stop != null && stop.asBoolean()) {
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report(scriptEntry, this.getName(), stop.debug());
            }
            boolean hasnext = false;
            for (int i = 0; i < queue.getQueueSize(); ++i) {
                ScriptEntry entry = queue.getEntry(i);
                List<String> args = entry.getOriginalArguments();
                if (!entry.getCommandName().equals("FOREACH") || args.size() != 1 || !args.get(0).equals("\u0000CALLBACK")) continue;
                hasnext = true;
                break;
            }
            if (hasnext) {
                while (queue.getQueueSize() > 0) {
                    ScriptEntry entry = queue.getEntry(0);
                    List<String> args = entry.getOriginalArguments();
                    if (entry.getCommandName().equals("FOREACH") && args.size() == 1 && args.get(0).equals("\u0000CALLBACK")) {
                        ((ForeachData)entry.getOwner().getData()).reapplyAtEnd(queue);
                        queue.removeEntry(0);
                        break;
                    }
                    queue.removeEntry(0);
                }
            } else {
                Debug.echoError(queue, "Cannot stop foreach: not in one!");
            }
            return;
        }
        if (next != null && next.asBoolean()) {
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report(scriptEntry, this.getName(), next.debug());
            }
            boolean hasnext = false;
            for (int i = 0; i < queue.getQueueSize(); ++i) {
                ScriptEntry entry = queue.getEntry(i);
                List<String> args = entry.getOriginalArguments();
                if (!entry.getCommandName().equals("FOREACH") || args.size() != 1 || !args.get(0).equals("\u0000CALLBACK")) continue;
                hasnext = true;
                break;
            }
            if (hasnext) {
                while (queue.getQueueSize() > 0) {
                    ScriptEntry entry = queue.getEntry(0);
                    List<String> args = entry.getOriginalArguments();
                    if (!entry.getCommandName().equals("FOREACH") || args.size() != 1 || !args.get(0).equals("\u0000CALLBACK")) {
                        queue.removeEntry(0);
                        continue;
                    }
                    break;
                }
            } else {
                Debug.echoError(queue, "Cannot 'foreach next': not in one!");
            }
            return;
        }
        if (callback != null && callback.asBoolean()) {
            if (scriptEntry.getOwner() != null && (scriptEntry.getOwner().getCommandName().equals("FOREACH") || scriptEntry.getOwner().getBracedSet() == null || scriptEntry.getOwner().getBracedSet().isEmpty() || scriptEntry.getBracedSet().get((int)0).value.get(scriptEntry.getBracedSet().get((int)0).value.size() - 1) != scriptEntry)) {
                ForeachData data = (ForeachData)scriptEntry.getOwner().getData();
                ++data.index;
                if (data.index <= data.list.size()) {
                    if (scriptEntry.dbCallShouldDebug()) {
                        Debug.echoDebug(scriptEntry, Debug.DebugElement.Header, "Foreach loop " + data.index);
                    }
                    queue.addDefinition("loop_index", new ElementTag(data.index));
                    if (data.keys != null) {
                        queue.addDefinition(data.keyName, new ElementTag(data.keys.get(data.index - 1)));
                    }
                    queue.addDefinition(data.valueName, data.list.getObject(data.index - 1));
                    List<ScriptEntry> bracedCommands = BracedCommand.getBracedCommands((ScriptEntry)scriptEntry.getOwner()).get((int)0).value;
                    ScriptEntry callbackEntry = scriptEntry.clone();
                    callbackEntry.setOwner(scriptEntry.getOwner());
                    bracedCommands.add(callbackEntry);
                    for (ScriptEntry cmd : bracedCommands) {
                        cmd.setInstant(true);
                        cmd.copyFrom(scriptEntry);
                    }
                    queue.injectEntries(bracedCommands, 0);
                } else {
                    data.reapplyAtEnd(queue);
                    if (scriptEntry.dbCallShouldDebug()) {
                        Debug.echoDebug(scriptEntry, Debug.DebugElement.Header, "Foreach loop complete");
                    }
                }
            } else {
                Debug.echoError(queue, "Foreach CALLBACK invalid: not a real callback!");
            }
        } else {
            int target;
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report(scriptEntry, this.getName(), (list == null ? map.debug() + key_as.debug() : list.debug()) + as_name.debug());
            }
            int n = target = list == null ? map.map.size() : list.size();
            if (target <= 0) {
                if (scriptEntry.dbCallShouldDebug()) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Empty list, not looping...");
                }
                return;
            }
            ForeachData datum = new ForeachData();
            if (list == null) {
                datum.keys = new ArrayList<String>(map.map.size());
                datum.list = new ListTag(map.map.size());
                for (Map.Entry<StringHolder, ObjectTag> entry : map.map.entrySet()) {
                    datum.keys.add(entry.getKey().str);
                    datum.list.addObject(entry.getValue());
                }
            } else {
                datum.keys = null;
                datum.list = list;
            }
            datum.index = 1;
            scriptEntry.setData(datum);
            ScriptEntry callbackEntry = new ScriptEntry("FOREACH", new String[]{"\u0000CALLBACK"}, scriptEntry.getScript() != null ? scriptEntry.getScript().getContainer() : null);
            callbackEntry.copyFrom(scriptEntry);
            callbackEntry.setOwner(scriptEntry);
            List<BracedCommand.BracedData> bdlist = ForeachCommand.getBracedCommands(scriptEntry);
            if (bdlist == null || bdlist.isEmpty()) {
                Debug.echoError(queue, "Empty subsection - did you forget a ':'?");
                return;
            }
            List<ScriptEntry> bracedCommandsList = bdlist.get((int)0).value;
            if (bracedCommandsList == null || bracedCommandsList.isEmpty()) {
                Debug.echoError(queue, "Empty subsection - did you forget to add the sub-commands inside the command?");
                return;
            }
            if (datum.keys != null) {
                datum.keyName = key_as.asString();
                datum.originalKeyValue = queue.getDefinitionObject(datum.keyName);
                queue.addDefinition(datum.keyName, datum.keys.get(0));
            }
            datum.valueName = as_name.asString();
            datum.originalValue = queue.getDefinitionObject(datum.valueName);
            datum.originalIndexValue = queue.getDefinitionObject("loop_index");
            queue.addDefinition(datum.valueName, datum.list.getObject(0));
            queue.addDefinition("loop_index", new ElementTag("1"));
            bracedCommandsList.add(callbackEntry);
            for (ScriptEntry cmd : bracedCommandsList) {
                cmd.setInstant(true);
            }
            scriptEntry.setInstant(true);
            queue.injectEntries(bracedCommandsList, 0);
        }
    }

    private class ForeachData {
        public int index;
        public ListTag list;
        public List<String> keys;
        public String valueName;
        public String keyName;
        public ObjectTag originalValue;
        public ObjectTag originalKeyValue;
        public ObjectTag originalIndexValue;

        private ForeachData() {
        }

        public void reapplyAtEnd(ScriptQueue queue) {
            queue.addDefinition(this.valueName, this.originalValue);
            if (this.keys != null) {
                queue.addDefinition(this.keyName, this.originalKeyValue);
            }
            queue.addDefinition("loop_index", this.originalIndexValue);
        }
    }
}

