/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class GlowCommand
extends AbstractCommand {
    public static HashMap<Integer, HashSet<UUID>> glowViewers = new HashMap();

    public static void unGlow(LivingEntity e) {
        if (glowViewers.containsKey(e.getEntityId())) {
            glowViewers.remove(e.getEntityId());
            e.setGlowing(false);
            if (Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC((Entity)e)) {
                CitizensAPI.getNPCRegistry().getNPC((Entity)e).data().setPersistent("glowing", (Object)false);
            }
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("glowing") && arg.matchesPrimitive(aH.PrimitiveType.Boolean)) {
                scriptEntry.addObject("glowing", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("glowing", new Element("true"));
        if (!((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer()) {
            throw new InvalidArgumentsException("Must have a valid player link!");
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entities to make glow!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        ArrayList entities = (ArrayList)scriptEntry.getObject("entities");
        Element glowing = scriptEntry.getElement("glowing");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugList("entities", entities) + glowing.debug());
        }
        boolean shouldGlow = glowing.asBoolean();
        UUID puuid = ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getOfflinePlayer().getUniqueId();
        if (puuid == null) {
            dB.echoError(scriptEntry.getResidingQueue(), "Invalid/non-spawned player link!");
            return;
        }
        for (dEntity ent : entities) {
            HashSet<UUID> players;
            if (Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC((Entity)ent.getLivingEntity())) {
                CitizensAPI.getNPCRegistry().getNPC((Entity)ent.getLivingEntity()).data().setPersistent("glowing", (Object)shouldGlow);
            }
            if (shouldGlow) {
                players = glowViewers.get(ent.getLivingEntity().getEntityId());
                if (players == null) {
                    players = new HashSet();
                    glowViewers.put(ent.getLivingEntity().getEntityId(), players);
                }
                players.add(puuid);
            } else {
                players = glowViewers.get(ent.getLivingEntity().getEntityId());
                if (players != null) {
                    players.remove(puuid);
                    boolean bl = shouldGlow = !players.isEmpty();
                    if (!shouldGlow) {
                        glowViewers.remove(ent.getLivingEntity().getEntityId());
                    }
                }
            }
            ent.getLivingEntity().setGlowing(shouldGlow);
        }
    }
}

