/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
extends AbstractCommand {
    public GiveCommand() {
        this.setName("give");
        this.setSyntax("give [money/xp/<item>|...] (quantity:<#>) (unlimit_stack_size) (to:<inventory>) (slot:<slot>)");
        this.setRequiredArguments(1, 5);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (Material material : Material.values()) {
            if (!material.isItem()) continue;
            addOne.accept(material.name());
        }
        for (String itemScript : ItemScriptHelper.item_scripts.keySet()) {
            addOne.accept(itemScript);
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("quantity") && arg.matchesPrefix("q", "qty", "quantity") && arg.matchesFloat()) {
                if (arg.matchesPrefix("q", "qty")) {
                    Deprecations.qtyTags.warn(scriptEntry);
                }
                scriptEntry.addObject("quantity", arg.asElement());
                scriptEntry.addObject("set_quantity", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("money", "coins")) {
                scriptEntry.addObject("type", (Object)Type.MONEY);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("xp", "exp", "experience")) {
                scriptEntry.addObject("type", (Object)Type.EXP);
                continue;
            }
            if (!scriptEntry.hasObject("unlimit_stack_size") && arg.matches("unlimit_stack_size")) {
                scriptEntry.addObject("unlimit_stack_size", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("items") && !scriptEntry.hasObject("type") && arg.matchesArgumentList(ItemTag.class)) {
                scriptEntry.addObject("items", arg.asType(ListTag.class).filter(ItemTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("inventory") && arg.matchesPrefix("t", "to") && arg.matchesArgumentType(InventoryTag.class)) {
                scriptEntry.addObject("inventory", arg.asType(InventoryTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("slot") && arg.matchesPrefix("slot")) {
                scriptEntry.addObject("slot", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("type", new Object[]{Type.ITEM}).defaultObject("unlimit_stack_size", new ElementTag(false)).defaultObject("quantity", new ElementTag(1)).defaultObject("slot", new ElementTag(1));
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        if (type != Type.MONEY && scriptEntry.getObject("inventory") == null) {
            scriptEntry.addObject("inventory", Utilities.entryHasPlayer(scriptEntry) ? Utilities.getEntryPlayer(scriptEntry).getInventory() : null);
        }
        if (!scriptEntry.hasObject("inventory") && type != Type.MONEY) {
            throw new InvalidArgumentsException("Must specify an inventory to give to!");
        }
        if (type == Type.ITEM && scriptEntry.getObject("items") == null) {
            throw new InvalidArgumentsException("Must specify item/items!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag unlimit_stack_size = scriptEntry.getElement("unlimit_stack_size");
        InventoryTag inventory = (InventoryTag)scriptEntry.getObjectTag("inventory");
        ElementTag quantity = scriptEntry.getElement("quantity");
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        ElementTag slot = scriptEntry.getElement("slot");
        Object items_object = scriptEntry.getObject("items");
        List items = null;
        if (items_object != null) {
            items = (List)items_object;
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), ArgumentHelper.debugObj("Type", type.name()) + (inventory != null ? inventory.debug() : "") + quantity.debug() + unlimit_stack_size.debug() + (items != null ? ArgumentHelper.debugObj("Items", items) : "") + slot.debug());
        }
        switch (type) {
            case MONEY: {
                if (Depends.economy != null) {
                    Depends.economy.depositPlayer(Utilities.getEntryPlayer(scriptEntry).getOfflinePlayer(), quantity.asDouble());
                    break;
                }
                Debug.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                break;
            }
            case EXP: {
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().giveExp(quantity.asInt());
                break;
            }
            case ITEM: {
                boolean set_quantity = scriptEntry.hasObject("set_quantity");
                boolean limited = !unlimit_stack_size.asBoolean();
                for (ItemTag item : items) {
                    int slotId;
                    ItemStack is = item.getItemStack();
                    if (is.getType() == Material.AIR) {
                        Debug.echoError("Cannot give air!");
                        continue;
                    }
                    if (set_quantity) {
                        is.setAmount(quantity.asInt());
                    }
                    if ((slotId = SlotHelper.nameToIndex(slot.asString())) == -1) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "The input '" + slot.asString() + "' is not a valid slot!");
                        return;
                    }
                    List<ItemStack> leftovers = inventory.addWithLeftovers(slotId, limited, is);
                    if (leftovers.isEmpty()) continue;
                    Debug.echoDebug((Debuggable)scriptEntry, "The inventory didn't have enough space, the rest of the items have been placed on the floor.");
                    for (ItemStack leftoverItem : leftovers) {
                        inventory.getLocation().getWorld().dropItem((Location)inventory.getLocation(), leftoverItem);
                    }
                }
                break;
            }
        }
    }

    static enum Type {
        ITEM,
        MONEY,
        EXP;

    }
}

