/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizen.utilities.nbt.CustomNBT;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;

public class TakeCommand
extends AbstractCommand {
    public static HashSet<Type> requiresPlayerTypes = new HashSet<Type>(Arrays.asList(Type.XP, Type.MONEY, Type.ITEMINHAND, Type.CURSORITEM));

    public TakeCommand() {
        this.setName("take");
        this.setSyntax("take [money/xp/iteminhand/cursoritem/bydisplay:<name>/bycover:<title>|<author>/slot:<slot>/flagged:<flag>/item:<matcher>] (quantity:<#>) (from:<inventory>)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        block3: {
            block2: {
                if (!arg.startsWith("material:")) break block2;
                for (Material material : Material.values()) {
                    if (!material.isItem()) continue;
                    addOne.accept("material:" + material.name());
                }
                break block3;
            }
            if (!arg.startsWith("scriptname:")) break block3;
            for (String itemScript : ItemScriptHelper.item_scripts.keySet()) {
                addOne.accept("scriptname:" + itemScript);
            }
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("type") && arg.matches("money", "coins")) {
                scriptEntry.addObject("type", (Object)Type.MONEY);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("xp", "exp")) {
                scriptEntry.addObject("type", (Object)Type.XP);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("item_in_hand", "iteminhand")) {
                scriptEntry.addObject("type", (Object)Type.ITEMINHAND);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("cursoritem", "cursor_item")) {
                scriptEntry.addObject("type", (Object)Type.CURSORITEM);
                continue;
            }
            if (!scriptEntry.hasObject("quantity") && arg.matchesPrefix("q", "qty", "quantity") && arg.matchesFloat()) {
                if (arg.matchesPrefix("q", "qty")) {
                    Deprecations.qtyTags.warn(scriptEntry);
                }
                scriptEntry.addObject("quantity", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("items") && arg.matchesPrefix("bydisplay") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.BYDISPLAY);
                scriptEntry.addObject("displayname", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("items") && arg.matchesPrefix("nbt") && !scriptEntry.hasObject("type")) {
                Deprecations.itemNbt.warn(scriptEntry);
                scriptEntry.addObject("type", (Object)Type.NBT);
                scriptEntry.addObject("nbt_key", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("items") && arg.matchesPrefix("flagged") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.FLAGGED);
                scriptEntry.addObject("flag_name", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("type") && !scriptEntry.hasObject("items") && arg.matchesPrefix("bycover")) {
                scriptEntry.addObject("type", (Object)Type.BYCOVER);
                scriptEntry.addObject("cover", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("type") && !scriptEntry.hasObject("items") && arg.matchesPrefix("item")) {
                scriptEntry.addObject("type", (Object)Type.MATCHER);
                scriptEntry.addObject("matcher_text", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("type") && !scriptEntry.hasObject("items") && arg.matchesPrefix("material")) {
                Deprecations.takeRawItems.warn(scriptEntry);
                scriptEntry.addObject("type", (Object)Type.MATERIAL);
                scriptEntry.addObject("material", arg.asType(ListTag.class).filter(MaterialTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("type") && !scriptEntry.hasObject("items") && arg.matchesPrefix("script", "scriptname")) {
                Deprecations.takeRawItems.warn(scriptEntry);
                scriptEntry.addObject("type", (Object)Type.SCRIPTNAME);
                scriptEntry.addObject("scriptitem", arg.asType(ListTag.class).filter(ItemTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("slot") && !scriptEntry.hasObject("type") && arg.matchesPrefix("slot")) {
                scriptEntry.addObject("type", (Object)Type.SLOT);
                scriptEntry.addObject("slot", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("items") && !scriptEntry.hasObject("type") && arg.matchesArgumentList(ItemTag.class)) {
                Deprecations.takeRawItems.warn(scriptEntry);
                scriptEntry.addObject("items", arg.asType(ListTag.class).filter(ItemTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("inventory") && arg.matchesPrefix("f", "from") && arg.matchesArgumentType(InventoryTag.class)) {
                scriptEntry.addObject("inventory", arg.asType(InventoryTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("inventory")) {
                Deprecations.takeCommandInventory.warn(scriptEntry);
                scriptEntry.addObject("type", (Object)Type.INVENTORY);
                continue;
            }
            if (!scriptEntry.hasObject("inventory") && arg.matches("npc")) {
                Deprecations.takeCommandInventory.warn(scriptEntry);
                scriptEntry.addObject("inventory", Utilities.getEntryNPC(scriptEntry).getDenizenEntity().getInventory());
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("type", new Object[]{Type.ITEM}).defaultObject("quantity", new ElementTag(1));
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        if (type != Type.MONEY && scriptEntry.getObject("inventory") == null) {
            scriptEntry.addObject("inventory", Utilities.entryHasPlayer(scriptEntry) ? Utilities.getEntryPlayer(scriptEntry).getInventory() : null);
        }
        if (!scriptEntry.hasObject("inventory") && type != Type.MONEY) {
            throw new InvalidArgumentsException("Must specify an inventory to take from!");
        }
        if (requiresPlayerTypes.contains((Object)type) && !Utilities.entryHasPlayer(scriptEntry)) {
            throw new InvalidArgumentsException("Cannot take '" + type.name() + "' without a linked player.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        InventoryTag inventory = (InventoryTag)scriptEntry.getObjectTag("inventory");
        ElementTag quantity = scriptEntry.getElement("quantity");
        ListTag displayNameList = (ListTag)scriptEntry.getObjectTag("displayname");
        List scriptItemList = (List)scriptEntry.getObjectTag("scriptitem");
        ListTag slotList = (ListTag)scriptEntry.getObjectTag("slot");
        ListTag titleAuthor = (ListTag)scriptEntry.getObjectTag("cover");
        ElementTag nbtKey = scriptEntry.getElement("nbt_key");
        ElementTag matcherText = scriptEntry.getElement("matcher_text");
        ListTag flagList = (ListTag)scriptEntry.getObjectTag("flag_name");
        List materialList = (List)scriptEntry.getObjectTag("material");
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        List items = (List)scriptEntry.getObjectTag("items");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), ArgumentHelper.debugObj("Type", type.name()) + quantity.debug() + (inventory != null ? inventory.debug() : "") + (displayNameList != null ? displayNameList.debug() : "") + (scriptItemList != null ? ArgumentHelper.debugList("scriptname", scriptItemList) : "") + (items != null ? ArgumentHelper.debugList("Items", items) : "") + (slotList != null ? slotList.debug() : "") + (nbtKey != null ? nbtKey.debug() : "") + (flagList != null ? flagList.debug() : "") + (matcherText != null ? matcherText.debug() : "") + (materialList != null ? ArgumentHelper.debugList("material", materialList) : "") + (titleAuthor != null ? titleAuthor.debug() : ""));
        }
        switch (type) {
            case INVENTORY: {
                inventory.clear();
                break;
            }
            case ITEMINHAND: {
                Player player = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity();
                int inHandAmt = player.getEquipment().getItemInMainHand().getAmount();
                int theAmount = (int)quantity.asDouble();
                ItemStack newHandItem = new ItemStack(Material.AIR);
                if (theAmount > inHandAmt) {
                    Debug.echoDebug((Debuggable)scriptEntry, "...player did not have enough of the item in hand, taking all...");
                    player.getEquipment().setItemInMainHand(newHandItem);
                    break;
                }
                if (theAmount == inHandAmt) {
                    player.getEquipment().setItemInMainHand(newHandItem);
                    break;
                }
                newHandItem = player.getEquipment().getItemInMainHand().clone();
                newHandItem.setAmount(inHandAmt - theAmount);
                player.getEquipment().setItemInMainHand(newHandItem);
                player.updateInventory();
                break;
            }
            case CURSORITEM: {
                Player player = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity();
                int currentAmount = player.getItemOnCursor().getAmount();
                int takeAmount = (int)quantity.asDouble();
                ItemStack newItem = new ItemStack(Material.AIR);
                if (takeAmount > currentAmount) {
                    Debug.echoDebug((Debuggable)scriptEntry, "...player did not have enough of the item on cursor, taking all...");
                    player.setItemOnCursor(newItem);
                    break;
                }
                if (takeAmount == currentAmount) {
                    player.setItemOnCursor(newItem);
                    break;
                }
                newItem = player.getItemOnCursor().clone();
                newItem.setAmount(currentAmount - takeAmount);
                player.setItemOnCursor(newItem);
                player.updateInventory();
                break;
            }
            case MONEY: {
                if (Depends.economy == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "No economy loaded! Have you installed Vault and a compatible economy plugin?");
                    return;
                }
                Depends.economy.withdrawPlayer(Utilities.getEntryPlayer(scriptEntry).getOfflinePlayer(), quantity.asDouble());
                break;
            }
            case XP: {
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().giveExp(-quantity.asInt());
                break;
            }
            case ITEM: {
                if (items == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify item/items!");
                    return;
                }
                for (ItemTag item2 : items) {
                    ItemStack is = item2.getItemStack();
                    is.setAmount(quantity.asInt());
                    if (this.removeItem(inventory.getInventory(), item2, item2.getAmount())) continue;
                    Debug.echoDebug((Debuggable)scriptEntry, "Inventory does not contain at least " + quantity.asInt() + " of " + item2.identify() + "... Taking all...");
                }
                break;
            }
            case BYDISPLAY: {
                if (displayNameList == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a displayname!");
                    return;
                }
                for (String name : displayNameList) {
                    this.takeByMatcher(inventory, item -> item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().equalsIgnoreCase(name), quantity.asInt());
                }
                break;
            }
            case BYCOVER: {
                if (titleAuthor == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a cover!");
                    return;
                }
                this.takeByMatcher(inventory, item -> item.hasItemMeta() && item.getItemMeta() instanceof BookMeta && TakeCommand.equalOrNull(titleAuthor.get(0), ((BookMeta)item.getItemMeta()).getTitle()) && (titleAuthor.size() == 1 || TakeCommand.equalOrNull(titleAuthor.get(1), ((BookMeta)item.getItemMeta()).getAuthor())), quantity.asInt());
                break;
            }
            case FLAGGED: {
                if (flagList == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a flag name!");
                    return;
                }
                for (String flag : flagList) {
                    this.takeByMatcher(inventory, item -> new ItemTag((ItemStack)item).getFlagTracker().hasFlag(flag), quantity.asInt());
                }
                break;
            }
            case NBT: {
                if (nbtKey == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify an NBT key!");
                    return;
                }
                this.takeByMatcher(inventory, item -> CustomNBT.hasCustomNBT(item, nbtKey.asString(), "Denizen NBT"), quantity.asInt());
                break;
            }
            case SCRIPTNAME: {
                if (scriptItemList == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a valid script name!");
                    return;
                }
                for (ItemTag scriptedItem : scriptItemList) {
                    String script = scriptedItem.getScriptName();
                    if (script == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Item '" + scriptedItem.debuggable() + "' is not a scripted item, cannot take by scriptname.");
                        continue;
                    }
                    this.takeByMatcher(inventory, item -> script.equalsIgnoreCase(new ItemTag((ItemStack)item).getScriptName()), quantity.asInt());
                }
                break;
            }
            case MATERIAL: {
                if (materialList == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a valid material!");
                    return;
                }
                for (MaterialTag material : materialList) {
                    this.takeByMatcher(inventory, item -> item.getType() == material.getMaterial() && !new ItemTag((ItemStack)item).isItemscript(), quantity.asInt());
                }
                break;
            }
            case MATCHER: {
                if (matcherText == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify an item matcher!");
                    return;
                }
                this.takeByMatcher(inventory, item -> BukkitScriptEvent.tryItem(new ItemTag((ItemStack)item), matcherText.asString()), quantity.asInt());
                break;
            }
            case SLOT: {
                for (String slot : slotList) {
                    int slotId = SlotHelper.nameToIndexFor(slot, inventory.getInventory().getHolder());
                    if (slotId == -1 || slotId >= inventory.getSize()) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "The input '" + slot + "' is not a valid slot!");
                        return;
                    }
                    ItemStack original = inventory.getInventory().getItem(slotId);
                    if (original == null || original.getType() == Material.AIR) continue;
                    if (original.getAmount() > quantity.asInt()) {
                        original.setAmount(original.getAmount() - quantity.asInt());
                        inventory.setSlots(slotId, original);
                        continue;
                    }
                    inventory.setSlots(slotId, new ItemStack(Material.AIR));
                }
                break;
            }
        }
    }

    private static boolean equalOrNull(String a, String b) {
        return b == null || a == null || a.equalsIgnoreCase(b);
    }

    public void takeByMatcher(InventoryTag inventory, Function<ItemStack, Boolean> matcher, int quantity) {
        int itemsTaken = 0;
        ItemStack[] contents = inventory.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack it = contents[i];
            if (itemsTaken >= quantity || it == null || !matcher.apply(it).booleanValue()) continue;
            int amt = it.getAmount();
            if (itemsTaken + amt <= quantity) {
                inventory.getInventory().setItem(i, new ItemStack(Material.AIR));
                itemsTaken += amt;
                continue;
            }
            it.setAmount(amt - (quantity - itemsTaken));
            inventory.getInventory().setItem(i, it);
            break;
        }
    }

    public boolean removeItem(Inventory inventory, ItemTag item, int amount) {
        if (item == null) {
            return false;
        }
        item = new ItemTag(item.getItemStack().clone());
        item.setAmount(1);
        String myItem = CoreUtilities.toLowerCase(item.identify());
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack is = inventory.getItem(i);
            if (is == null) continue;
            is = is.clone();
            int count = is.getAmount();
            is.setAmount(1);
            String newItem = CoreUtilities.toLowerCase(ItemTag.valueOf(new ItemTag(is).identify(), false).identify());
            if (!myItem.equals(newItem)) continue;
            if (count <= amount) {
                NMSHandler.getItemHelper().setInventoryItem(inventory, null, i);
                if ((amount -= count) != 0) continue;
                return true;
            }
            is.setAmount(count - amount);
            NMSHandler.getItemHelper().setInventoryItem(inventory, is, i);
            return true;
        }
        return false;
    }

    private static enum Type {
        MONEY,
        XP,
        ITEMINHAND,
        CURSORITEM,
        ITEM,
        INVENTORY,
        BYDISPLAY,
        SLOT,
        BYCOVER,
        SCRIPTNAME,
        NBT,
        MATERIAL,
        FLAGGED,
        MATCHER;

    }
}

