/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ItemChangeMessage
implements Listener {
    private static final Map<UUID, Integer> slotChanged;

    public static void sendMessage(Player player, String message) {
        ItemStack item = NMSHandler.getInstance().getEntityHelper().getItemInHand((LivingEntity)player);
        if (item != null && item.getType() != Material.AIR) {
            item = item.clone();
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(message);
        item.setItemMeta(meta);
        int slot = player.getInventory().getHeldItemSlot() + 36;
        NMSHandler.getInstance().getPacketHelper().setSlot(player, slot, item, true);
        slotChanged.put(player.getUniqueId(), slot);
    }

    public static void resetItem(Player player) {
        if (player == null) {
            return;
        }
        UUID uuid = player.getUniqueId();
        if (slotChanged.containsKey(uuid)) {
            int slot = slotChanged.get(uuid);
            ItemStack itemStack = NMSHandler.getInstance().getEntityHelper().getItemInHand((LivingEntity)player);
            NMSHandler.getInstance().getPacketHelper().setSlot(player, slot, itemStack, true);
            slotChanged.remove(uuid);
        }
    }

    @EventHandler
    public void playerItemHeld(PlayerItemHeldEvent event) {
        ItemChangeMessage.resetItem(event.getPlayer());
    }

    @EventHandler
    public void inventoryOpen(InventoryOpenEvent event) {
        if (event.getPlayer() instanceof Player) {
            ItemChangeMessage.resetItem((Player)event.getPlayer());
        }
    }

    @EventHandler
    public void blockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (player != null && slotChanged.containsKey(player.getUniqueId())) {
            slotChanged.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void playerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (player != null && slotChanged.containsKey(player.getUniqueId())) {
            slotChanged.remove(player.getUniqueId());
        }
    }

    static {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)new ItemChangeMessage(), (Plugin)DenizenAPI.getCurrentInstance());
        slotChanged = new HashMap<UUID, Integer>();
    }
}

