/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.AdvancementHelper;
import com.denizenscript.denizen.nms.util.Advancement;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ToastCommand
extends AbstractCommand {
    public ToastCommand() {
        this.setName("toast");
        this.setSyntax("toast [<text>] (targets:<player>|...) (icon:<item>) (frame:{task}/challenge/goal) (background:<texture>)");
        this.setRequiredArguments(1, 5);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("targets") && arg.matchesPrefix("target", "targets", "t") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("targets", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("icon") && arg.matchesPrefix("icon", "i") && arg.matchesArgumentType(ItemTag.class)) {
                scriptEntry.addObject("icon", arg.asType(ItemTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("frame") && arg.matchesPrefix("frame", "f") && arg.matchesEnum(Advancement.Frame.values())) {
                scriptEntry.addObject("frame", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("background") && arg.matchesPrefix("background")) {
                scriptEntry.addObject("background", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("text")) {
                scriptEntry.addObject("text", new ElementTag(arg.getRawValue()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("text")) {
            throw new InvalidArgumentsException("Must specify a message!");
        }
        if (!scriptEntry.hasObject("targets")) {
            if (!Utilities.entryHasPlayer(scriptEntry)) {
                throw new InvalidArgumentsException("Must specify valid player targets!");
            }
            scriptEntry.addObject("targets", Collections.singletonList(Utilities.getEntryPlayer(scriptEntry)));
        }
        scriptEntry.defaultObject("icon", new ItemTag(Material.AIR));
        scriptEntry.defaultObject("frame", new ElementTag("TASK"));
        scriptEntry.defaultObject("background", new ElementTag("textures/gui/advancements/backgrounds/adventure.png"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        int index;
        ElementTag text = scriptEntry.getElement("text");
        ElementTag frame = scriptEntry.getElement("frame");
        ElementTag background = scriptEntry.getElement("background");
        ItemTag icon = (ItemTag)scriptEntry.getObjectTag("icon");
        List targets = (List)scriptEntry.getObject("targets");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.name, text.debug() + frame.debug() + icon.debug() + background.debug() + ArgumentHelper.debugList("targets", targets));
        }
        NamespacedKey backgroundKey = (index = background.asString().indexOf(58)) == -1 ? NamespacedKey.minecraft((String)background.asString()) : new NamespacedKey(background.asString().substring(0, index), background.asString().substring(index + 1));
        Advancement advancement = new Advancement(true, new NamespacedKey((Plugin)Denizen.getInstance(), UUID.randomUUID().toString()), null, icon.getItemStack(), text.asString(), "", backgroundKey, Advancement.Frame.valueOf(frame.asString().toUpperCase()), true, false, true, 0.0f, 0.0f, 1);
        AdvancementHelper advancementHelper = NMSHandler.getAdvancementHelper();
        for (PlayerTag target : targets) {
            Player player = target.getPlayerEntity();
            if (player == null) continue;
            advancementHelper.grant(advancement, player);
            advancementHelper.revoke(advancement, player);
        }
    }
}

