/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.inventory.ItemStack;

public class NBTCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("key") && arg.raw_value.split(":", 2).length == 2) {
                String[] flagArgs = arg.raw_value.split(":", 2);
                scriptEntry.addObject("key", new Element(flagArgs[0]));
                scriptEntry.addObject("value", new Element(flagArgs[1]));
                continue;
            }
            if (!scriptEntry.hasObject("item") && arg.matchesArgumentType(dItem.class)) {
                scriptEntry.addObject("item", arg.asType(dItem.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("item")) {
            throw new InvalidArgumentsException("Must specify item!");
        }
        if (!scriptEntry.hasObject("key") || !scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify key and value!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dItem item = (dItem)scriptEntry.getdObject("item");
        Element key = scriptEntry.getElement("key");
        Element value = scriptEntry.getElement("value");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), item.debug() + key.debug() + value.debug());
        }
        ItemStack itemStack = item.getItemStack();
        itemStack = value.asString().equals("!") ? CustomNBT.removeCustomNBT(itemStack, key.asString(), "Denizen NBT") : CustomNBT.addCustomNBT(itemStack, key.asString(), value.asString(), "Denizen NBT");
        scriptEntry.addObject("new_item", new dItem(itemStack));
    }
}

