/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.List;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptBuilder;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class InjectCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matches("instant", "instantly")) {
                scriptEntry.addObject("instant", new Element(true));
                continue;
            }
            if (arg.matches("local", "locally")) {
                scriptEntry.addObject("local", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(dScript.class) && !arg.matchesPrefix("p", "path")) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (!scriptEntry.hasObject("path")) {
                scriptEntry.addObject("path", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("script") && !scriptEntry.hasObject("local")) {
            throw new InvalidArgumentsException("Must define a SCRIPT to be injected.");
        }
        if (!scriptEntry.hasObject("path") && scriptEntry.hasObject("local")) {
            throw new InvalidArgumentsException("Must specify a PATH.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), (scriptEntry.hasObject("script") ? scriptEntry.getdObject("script").debug() : scriptEntry.getScript().debug()) + (scriptEntry.hasObject("instant") ? scriptEntry.getdObject("instant").debug() : "") + (scriptEntry.hasObject("path") ? scriptEntry.getElement("path").debug() : "") + (scriptEntry.hasObject("local") ? scriptEntry.getElement("local").debug() : ""));
        }
        dScript script = (dScript)scriptEntry.getdObject("script");
        List<ScriptEntry> entries = scriptEntry.hasObject("local") ? scriptEntry.getScript().getContainer().getEntries(scriptEntry.entryData.clone(), scriptEntry.getElement("path").asString()) : (scriptEntry.hasObject("path") ? script.getContainer().getEntries(scriptEntry.entryData.clone(), scriptEntry.getElement("path").asString()) : script.getContainer().getBaseEntries(scriptEntry.entryData.clone()));
        if (entries == null) {
            dB.echoError(scriptEntry.getResidingQueue(), "Script inject failed (invalid path or script name)!");
            return;
        }
        ScriptBuilder.addObjectToEntries(entries, "reqid", scriptEntry.getObject("reqid"));
        if (scriptEntry.hasObject("instant")) {
            scriptEntry.getResidingQueue().runNow(entries, "INJECT");
        } else {
            scriptEntry.getResidingQueue().injectEntries(entries, 0);
        }
    }
}

