/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.Delayable;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;

public class WaitCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ScriptQueue queue = scriptEntry.getResidingQueue();
        Duration delay = new Duration(3);
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesDuration(arg)) {
                delay = Duration.valueOf(arg);
            }
            if (!aH.matchesQueue(arg)) continue;
            queue = ScriptQueue._getExistingQueue(arg);
        }
        scriptEntry.addObject("queue", queue);
        scriptEntry.addObject("delay", delay);
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        ScriptQueue queue = (ScriptQueue)scriptEntry.getObject("queue");
        Duration delay = (Duration)scriptEntry.getObject("delay");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugObj("queue", queue.id) + delay.debug());
        }
        if (queue instanceof Delayable) {
            ((Delayable)((Object)queue)).delayFor(delay);
        } else {
            scriptEntry.setInstant(false);
            dB.echoDebug((Debuggable)scriptEntry, "Forcing queue " + queue.id + " into a timed queue...");
            queue.forceToTimed(delay);
        }
    }
}

