/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.events.core;

import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;

public class DeltaTimeScriptEvent
extends ScriptEvent {
    public static DeltaTimeScriptEvent instance;
    public ScriptEntryData data = null;
    public Element second;
    boolean enabled = false;

    public DeltaTimeScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer script, String event) {
        return event.startsWith("delta time");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String time = path.eventArgLowerAt(2);
        long seconds = DenizenCore.serverTimeMillis / 1000L;
        return time.equals("secondly") || seconds % 60L == 0L && time.equals("minutely") || seconds % 3600L == 0L && time.equals("hourly");
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return this.data;
    }

    @Override
    public String getName() {
        return "DeltaTime";
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("second")) {
            return this.second;
        }
        return super.getContext(name);
    }

    @Override
    public void init() {
        this.enabled = true;
    }

    @Override
    public void destroy() {
        this.enabled = false;
    }

    public void checkTime() {
        if (!this.enabled) {
            return;
        }
        this.second = new Element(DenizenCore.serverTimeMillis / 1000L);
        this.data = DenizenCore.getImplementation().getEmptyScriptEntryData();
        this.fire();
    }
}

