/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.plugin.Plugin;

public class PlayerFishesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerFishesScriptEvent instance;
    public dEntity hook;
    public Element state;
    public dEntity entity;
    public dItem item;
    public PlayerFishEvent event;

    public PlayerFishesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player fishes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String s = path.event;
        String lower = path.eventLower;
        String fish = CoreUtilities.getXthArg(2, lower);
        if (!(fish.isEmpty() || fish.equals("in") || fish.equals("while"))) {
            if (this.entity == null) {
                return false;
            }
            if (!this.tryEntity(this.entity, fish)) {
                if (this.item == null) {
                    return false;
                }
                if (!this.tryItem(this.item, fish)) {
                    return false;
                }
            }
        }
        List<String> data = CoreUtilities.split(lower, ' ');
        for (int index = 2; index < data.size(); ++index) {
            if (!data.get(index).equals("while") || data.get(index + 1).equalsIgnoreCase(this.state.asString())) continue;
            return false;
        }
        return this.runInCheck(path, this.hook.getLocation());
    }

    @Override
    public String getName() {
        return "PlayerFishes";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        PlayerFishEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(dEntity.isPlayer((Entity)this.event.getPlayer()) ? dEntity.getPlayerFrom((Entity)this.event.getPlayer()) : (dEntity.isPlayer(this.event.getCaught()) ? dEntity.getPlayerFrom(this.event.getCaught()) : null), dEntity.isCitizensNPC((Entity)this.event.getPlayer()) ? dEntity.getNPCFrom((Entity)this.event.getPlayer()) : (dEntity.isCitizensNPC(this.event.getCaught()) ? dEntity.getNPCFrom(this.event.getCaught()) : null));
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("hook")) {
            return this.hook;
        }
        if (name.equals("entity") && this.entity != null) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("item") && this.item != null) {
            return this.item;
        }
        if (name.equals("state")) {
            return this.state;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerFishes(PlayerFishEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        Entity hookEntity = NMSHandler.getInstance().getEntityHelper().getFishHook(event);
        dEntity.rememberEntity(hookEntity);
        this.hook = new dEntity(hookEntity);
        this.state = new Element(event.getState().toString());
        this.item = null;
        this.entity = null;
        Entity caughtEntity = event.getCaught();
        if (caughtEntity != null) {
            dEntity.rememberEntity(caughtEntity);
            this.entity = new dEntity(caughtEntity);
            if (caughtEntity instanceof Item) {
                this.item = new dItem(((Item)caughtEntity).getItemStack());
            }
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        dEntity.forgetEntity(hookEntity);
        dEntity.forgetEntity(caughtEntity);
        event.setCancelled(this.cancelled);
    }
}

