/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.nms.interfaces.BlockData;
import net.aufdemrand.denizen.nms.interfaces.EntityHelper;
import net.aufdemrand.denizen.nms.util.PlayerProfile;
import net.aufdemrand.denizen.objects.dBiome;
import net.aufdemrand.denizen.objects.dChunk;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEllipsoid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.scripts.commands.world.SwitchCommand;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.MaterialCompat;
import net.aufdemrand.denizen.utilities.PathFinder;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.blocks.DirectionalBlocksHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.DenizenEntityType;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.notable.Notable;
import net.aufdemrand.denizencore.objects.notable.Note;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.core.EscapeTags;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Nameable;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Furnace;
import org.bukkit.block.Lockable;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Attachable;
import org.bukkit.material.MaterialData;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class dLocation
extends Location
implements dObject,
Notable,
Adjustable {
    static final java.util.regex.Pattern notablePattern = java.util.regex.Pattern.compile("(\\w+)[;,]((-?\\d+\\.?\\d*,){3,5}.+)", 2);
    private boolean is2D = false;
    private boolean raw = false;
    String prefix = "Location";

    @Override
    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    @Override
    @Note(value="Locations")
    public String getSaveObject() {
        return (double)this.getBlockX() + 0.5 + "," + this.getBlockY() + "," + ((double)this.getBlockZ() + 0.5) + "," + this.getPitch() + "," + this.getYaw() + "," + this.getWorld().getName();
    }

    public static String getSaved(dLocation location) {
        for (dLocation saved : NotableManager.getAllType(dLocation.class)) {
            if ((double)saved.getBlockX() != location.getX() || (double)saved.getBlockY() != location.getY() || (double)saved.getBlockZ() != location.getZ() || (saved.getWorld() != null || location.getWorld() != null) && (saved.getWorld() == null || location.getWorld() == null || !saved.getWorld().getName().equals(location.getWorld().getName()))) continue;
            return NotableManager.getSavedId(saved);
        }
        return null;
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
    }

    public static void _recallLocations() {
        List loclist = DenizenAPI.getCurrentInstance().getSaves().getStringList("dScript.Locations");
        for (String location : loclist) {
            Matcher m = notablePattern.matcher(location);
            if (!m.matches()) continue;
            String id = m.group(1);
            dLocation loc = dLocation.valueOf(m.group(2));
            NotableManager.saveAs(loc, id);
        }
        DenizenAPI.getCurrentInstance().getSaves().set("dScript.Locations", null);
    }

    public static dLocation valueOf(String string) {
        return dLocation.valueOf(string, null);
    }

    @Fetchable(value="l")
    public static dLocation valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("l@")) {
            string = string.substring(2);
        }
        if (NotableManager.isSaved(string) && NotableManager.isType(string, dLocation.class)) {
            return (dLocation)NotableManager.getSavedObject(string);
        }
        List<String> split = CoreUtilities.split(string, ',');
        if (split.size() == 2) {
            try {
                return new dLocation(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)));
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    dB.log("Minor: valueOf dLocation returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 3) {
            try {
                World world = Bukkit.getWorld((String)split.get(2));
                if (world != null) {
                    return new dLocation(world, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)));
                }
                return new dLocation(null, Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)));
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    dB.log("Minor: valueOf dLocation returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 4) {
            try {
                return new dLocation(Bukkit.getWorld((String)split.get(3)), Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)));
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    dB.log("Minor: valueOf dLocation returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 6) {
            try {
                return new dLocation(Bukkit.getWorld((String)split.get(5)), Double.valueOf(split.get(0)), Double.valueOf(split.get(1)), Double.valueOf(split.get(2)), Float.valueOf(split.get(3)).floatValue(), Float.valueOf(split.get(4)).floatValue());
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    dB.log("Minor: valueOf dLocation returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (context == null || context.debug) {
            dB.log("Minor: valueOf dLocation returning null: " + string);
        }
        return null;
    }

    public static boolean matches(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.startsWith("l@")) {
            return true;
        }
        return dLocation.valueOf(string, new BukkitTagContext(null, null, false, null, false, null)) != null;
    }

    public dLocation(Location location) {
        super(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public dLocation(Vector vector) {
        super(null, vector.getX(), vector.getY(), vector.getZ());
    }

    public dLocation(World world, double x, double y) {
        this(world, x, y, 0.0);
        this.is2D = true;
    }

    public dLocation(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public dLocation(World world, double x, double y, double z, float yaw, float pitch) {
        super(world, x, y, z, pitch, yaw);
    }

    private void setRaw(boolean state) {
        this.raw = state;
    }

    public void setPitch(float pitch) {
        super.setPitch(pitch);
    }

    public void setYaw(float yaw) {
        super.setYaw(yaw);
    }

    public boolean hasInventory() {
        return this.getBlock().getState() instanceof InventoryHolder;
    }

    public Inventory getBukkitInventory() {
        return this.hasInventory() ? ((InventoryHolder)this.getBlock().getState()).getInventory() : null;
    }

    public dInventory getInventory() {
        return this.hasInventory() ? dInventory.mirrorBukkitInventory(this.getBukkitInventory()) : null;
    }

    public BlockFace getSkullBlockFace(int rotation) {
        switch (rotation) {
            case 0: {
                return BlockFace.NORTH;
            }
            case 1: {
                return BlockFace.NORTH_NORTH_EAST;
            }
            case 2: {
                return BlockFace.NORTH_EAST;
            }
            case 3: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case 4: {
                return BlockFace.EAST;
            }
            case 5: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case 6: {
                return BlockFace.SOUTH_EAST;
            }
            case 7: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
            case 8: {
                return BlockFace.SOUTH;
            }
            case 9: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case 10: {
                return BlockFace.SOUTH_WEST;
            }
            case 11: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case 12: {
                return BlockFace.WEST;
            }
            case 13: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case 14: {
                return BlockFace.NORTH_WEST;
            }
            case 15: {
                return BlockFace.NORTH_NORTH_WEST;
            }
        }
        return null;
    }

    public byte getSkullRotation(BlockFace face) {
        switch (face) {
            case NORTH: {
                return 0;
            }
            case NORTH_NORTH_EAST: {
                return 1;
            }
            case NORTH_EAST: {
                return 2;
            }
            case EAST_NORTH_EAST: {
                return 3;
            }
            case EAST: {
                return 4;
            }
            case EAST_SOUTH_EAST: {
                return 5;
            }
            case SOUTH_EAST: {
                return 6;
            }
            case SOUTH_SOUTH_EAST: {
                return 7;
            }
            case SOUTH: {
                return 8;
            }
            case SOUTH_SOUTH_WEST: {
                return 9;
            }
            case SOUTH_WEST: {
                return 10;
            }
            case WEST_SOUTH_WEST: {
                return 11;
            }
            case WEST: {
                return 12;
            }
            case WEST_NORTH_WEST: {
                return 13;
            }
            case NORTH_WEST: {
                return 14;
            }
            case NORTH_NORTH_WEST: {
                return 15;
            }
        }
        return -1;
    }

    public int compare(Location loc1, Location loc2) {
        if (loc1 == null || loc2 == null || loc1.equals((Object)loc2)) {
            return 0;
        }
        double dist = this.distanceSquared(loc1) - this.distanceSquared(loc2);
        return dist == 0.0 ? 0 : (dist > 0.0 ? 1 : -1);
    }

    public int hashCode() {
        return (int)(Math.floor(this.getX()) + Math.floor(this.getY()) + Math.floor(this.getZ()));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof dLocation)) {
            return false;
        }
        dLocation other = (dLocation)o;
        if (other.getWorld() == null && this.getWorld() != null || this.getWorld() == null && other.getWorld() != null || this.getWorld() != null && other.getWorld() != null && !this.getWorld().getName().equalsIgnoreCase(other.getWorld().getName())) {
            return false;
        }
        return Math.floor(this.getX()) == Math.floor(other.getX()) && Math.floor(this.getY()) == Math.floor(other.getY()) && Math.floor(this.getZ()) == Math.floor(other.getZ());
    }

    @Override
    public String getObjectType() {
        return "Location";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dLocation setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return this.isUnique() ? "<G>" + this.prefix + "='<A>" + this.identify() + "(<Y>" + this.identifyRaw() + "<A>)<G>'  " : "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return dLocation.getSaved(this) != null;
    }

    @Override
    public String identify() {
        if (!this.raw && this.isUnique()) {
            return "l@" + dLocation.getSaved(this);
        }
        return this.identifyRaw();
    }

    @Override
    public String identifySimple() {
        if (this.isUnique()) {
            return "l@" + dLocation.getSaved(this);
        }
        if (this.getWorld() == null) {
            return "l@" + this.getBlockX() + "," + this.getBlockY() + (!this.is2D ? "," + this.getBlockZ() : "");
        }
        return "l@" + this.getBlockX() + "," + this.getBlockY() + (!this.is2D ? "," + this.getBlockZ() : "") + "," + this.getWorld().getName();
    }

    public String identifyRaw() {
        if ((double)this.getYaw() != 0.0 || (double)this.getPitch() != 0.0) {
            return "l@" + this.getX() + "," + this.getY() + "," + this.getZ() + "," + this.getPitch() + "," + this.getYaw() + (this.getWorld() != null ? "," + this.getWorld().getName() : "");
        }
        return "l@" + this.getX() + "," + this.getY() + (!this.is2D ? "," + this.getZ() : "") + (this.getWorld() != null ? "," + this.getWorld().getName() : "");
    }

    public String toString() {
        return this.identify();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getAttribute(Attribute attribute) {
        dLocation location;
        dLocation target;
        BlockState blockState;
        Vector facing;
        if (attribute == null) {
            return null;
        }
        if (attribute.matches("block_facing") && (facing = DirectionalBlocksHelper.getFacing(this.getBlock())) != null) {
            return new dLocation(this.getWorld(), facing.getX(), facing.getY(), facing.getZ()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("above")) {
            return new dLocation(this.clone().add(0.0, 1.0, 0.0)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("below")) {
            return new dLocation(this.clone().add(0.0, -1.0, 0.0)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.matches("block")) {
            return new dLocation(this.getWorld(), this.getBlockX(), this.getBlockY(), this.getBlockZ()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("center")) {
            return new dLocation(this.getWorld(), (double)this.getBlockX() + 0.5, (double)this.getBlockY() + 0.5, (double)this.getBlockZ() + 0.5).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("highest")) {
            return new dLocation(this.getWorld().getHighestBlockAt((Location)this).getLocation().add(0.0, -1.0, 0.0)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("base_color")) {
            DyeColor color = ((Banner)this.getBlock().getState()).getBaseColor();
            return new Element(color != null ? color.name() : "BLACK").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_inventory")) {
            return new Element(this.getBlock().getState() instanceof InventoryHolder).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("inventory")) {
            dInventory obj = Element.handleNull(this.identify() + ".inventory", this.getInventory(), "dInventory", attribute.hasAlternative());
            return obj == null ? null : obj.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("material")) {
            return dMaterial.getMaterialFrom(this.getBlock().getType(), this.getBlock().getData()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("patterns")) {
            dList list = new dList();
            for (Pattern pattern : ((Banner)this.getBlock().getState()).getPatterns()) {
                list.add(pattern.getColor().name() + "/" + pattern.getPattern().name());
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("head_rotation")) {
            return new Element(this.getSkullRotation(((Skull)this.getBlock().getState()).getRotation()) + 1).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("switched")) {
            return new Element(SwitchCommand.switchState(this.getBlock())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("sign_contents")) {
            if (this.getBlock().getState() instanceof Sign) {
                return new dList(Arrays.asList(((Sign)this.getBlock().getState()).getLines())).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("spawner_type")) {
            if (this.getBlock().getState() instanceof CreatureSpawner) {
                return new dEntity(DenizenEntityType.getByName(((CreatureSpawner)this.getBlock().getState()).getSpawnedType().name())).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_10_R1) && attribute.startsWith("lock") && this.getBlock().getState() instanceof Lockable) {
            Lockable lock = (Lockable)this.getBlock().getState();
            return new Element(lock.isLocked() ? lock.getLock() : null).getAttribute(attribute.fulfill(1));
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_10_R1) && attribute.startsWith("is_locked") && this.getBlock().getState() instanceof Lockable) {
            return new Element(((Lockable)this.getBlock().getState()).isLocked()).getAttribute(attribute.fulfill(1));
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_10_R1) && attribute.startsWith("is_lockable")) {
            return new Element(this.getBlock().getState() instanceof Lockable).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("drops")) {
            Collection its;
            if (attribute.hasContext(1)) {
                dItem item = dItem.valueOf(attribute.getContext(1));
                its = this.getBlock().getDrops(item.getItemStack());
            } else {
                its = this.getBlock().getDrops();
            }
            dList list = new dList();
            for (ItemStack it : its) {
                list.add(new dItem(it).identify());
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("flowerpot_contents")) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
                dB.echoError("As of Minecraft version 1.13 potted flowers each have their own material, such as POTTED_CACTUS.");
            } else if (this.getBlock().getType() == Material.FLOWER_POT) {
                MaterialData contents = NMSHandler.getInstance().getBlockHelper().getFlowerpotContents(this.getBlock());
                return dMaterial.getMaterialFrom(contents.getItemType(), contents.getData()).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("skull_type") && (blockState = this.getBlock().getState()) instanceof Skull) {
            String t = ((Skull)blockState).getSkullType().name();
            return new Element(t).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("skull_name") && (blockState = this.getBlock().getState()) instanceof Skull) {
            PlayerProfile profile = NMSHandler.getInstance().getBlockHelper().getPlayerProfile((Skull)blockState);
            if (profile == null) {
                return null;
            }
            String n = profile.getName();
            if (n == null) {
                n = ((Skull)blockState).getOwningPlayer().getName();
            }
            return new Element(n).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("skull_skin")) {
            blockState = this.getBlock().getState();
            if (blockState instanceof Skull) {
                PlayerProfile profile = NMSHandler.getInstance().getBlockHelper().getPlayerProfile((Skull)blockState);
                if (profile == null) {
                    return null;
                }
                String name = profile.getName();
                UUID uuid = profile.getUniqueId();
                String string = profile.getTexture();
                if ((attribute = attribute.fulfill(1)).startsWith("full")) {
                    return new Element((uuid != null ? uuid : name) + (string != null ? "|" + string : "")).getAttribute(attribute.fulfill(1));
                }
                return new Element(uuid != null ? uuid.toString() : name).getAttribute(attribute);
            }
            return null;
        }
        if (attribute.startsWith("simple.formatted")) {
            return new Element("X '" + this.getBlockX() + "', Y '" + this.getBlockY() + "', Z '" + this.getBlockZ() + "', in world '" + this.getWorld().getName() + "'").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("simple")) {
            if (this.getWorld() == null) {
                return new Element(this.getBlockX() + "," + this.getBlockY() + "," + this.getBlockZ()).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.getBlockX() + "," + this.getBlockY() + "," + this.getBlockZ() + "," + this.getWorld().getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("precise_impact_normal")) {
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 200;
            }
            double xzLen = Math.cos((double)(this.getPitch() % 360.0f) * (Math.PI / 180));
            double nx = xzLen * Math.sin((double)(-this.getYaw()) * (Math.PI / 180));
            double ny = Math.sin((double)this.getPitch() * (Math.PI / 180));
            double nz = xzLen * Math.cos((double)this.getYaw() * (Math.PI / 180));
            Location location2 = NMSHandler.getInstance().getEntityHelper().getImpactNormal(this, new Vector(nx, -ny, nz), range);
            if (location2 != null) {
                return new dLocation(location2).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("precise_cursor_on")) {
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 200;
            }
            double xzLen = Math.cos((double)(this.getPitch() % 360.0f) * (Math.PI / 180));
            double nx = xzLen * Math.sin((double)(-this.getYaw()) * (Math.PI / 180));
            double ny = Math.sin((double)this.getPitch() * (Math.PI / 180));
            double nz = xzLen * Math.cos((double)this.getYaw() * (Math.PI / 180));
            Location location3 = NMSHandler.getInstance().getEntityHelper().rayTrace(this, new Vector(nx, -ny, nz), range);
            if (location3 != null) {
                return new dLocation(location3).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("points_between")) {
            target = dLocation.valueOf(attribute.getContext(1));
            if (target == null) {
                return null;
            }
            attribute = attribute.fulfill(1);
            double rad = 1.0;
            if (attribute.startsWith("distance")) {
                rad = attribute.getDoubleContext(1);
                attribute = attribute.fulfill(1);
            }
            dList list = new dList();
            Vector vector = target.toVector().subtract(this.toVector());
            double len = vector.length();
            Vector vector2 = vector.multiply(1.0 / len);
            for (double i = 0.0; i < len; i += rad) {
                list.add(new dLocation(this.clone().add(vector2.clone().multiply(i))).identify());
            }
            return list.getAttribute(attribute);
        }
        if (attribute.startsWith("facing_blocks")) {
            int range = attribute.getIntContext(1);
            if (range < 1) {
                range = 100;
            }
            dList list = new dList();
            BlockIterator iterator = new BlockIterator((Location)this, 0.0, range);
            while (iterator.hasNext()) {
                list.add(new dLocation(iterator.next().getLocation()).identify());
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("line_of_sight") && attribute.hasContext(1) && (location = dLocation.valueOf(attribute.getContext(1))) != null) {
            return new Element(NMSHandler.getInstance().getEntityHelper().canTrace(this.getWorld(), this.toVector(), location.toVector())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("direction.vector")) {
            double xzLen = Math.cos((double)(this.getPitch() % 360.0f) * (Math.PI / 180));
            double nx = xzLen * Math.sin((double)(-this.getYaw()) * (Math.PI / 180));
            double d = Math.sin((double)this.getPitch() * (Math.PI / 180));
            double nz = xzLen * Math.cos((double)this.getYaw() * (Math.PI / 180));
            return new dLocation(this.getWorld(), nx, -d, nz).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("direction")) {
            if (attribute.hasContext(1) && dLocation.matches(attribute.getContext(1))) {
                target = dLocation.valueOf(attribute.getContext(1));
                attribute = attribute.fulfill(1);
                EntityHelper entityHelper = NMSHandler.getInstance().getEntityHelper();
                if (attribute.startsWith("yaw")) {
                    return new Element(entityHelper.normalizeYaw(entityHelper.getYaw(target.toVector().subtract(this.toVector()).normalize()))).getAttribute(attribute.fulfill(1));
                }
                return new Element(entityHelper.getCardinal(entityHelper.getYaw(target.toVector().subtract(this.toVector()).normalize()))).getAttribute(attribute);
            }
            return new Element(NMSHandler.getInstance().getEntityHelper().getCardinal(this.getYaw())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("face") && attribute.hasContext(1)) {
            dLocation two = dLocation.valueOf(attribute.getContext(1));
            return new dLocation(NMSHandler.getInstance().getEntityHelper().faceLocation(this, (Location)two)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("facing") && attribute.hasContext(1)) {
            int degrees = 45;
            int attributePos = 1;
            if (attribute.getAttribute(2).startsWith("degrees") && attribute.hasContext(2)) {
                String context = attribute.getContext(2);
                if (context.contains(",")) {
                    String yaw = context.substring(0, context.indexOf(44));
                    String string = context.substring(context.indexOf(44) + 1);
                    degrees = aH.getIntegerFrom(yaw);
                    int pitchDegrees = aH.getIntegerFrom(string);
                    if (dLocation.matches(attribute.getContext(1))) {
                        return new Element(NMSHandler.getInstance().getEntityHelper().isFacingLocation(this, dLocation.valueOf(attribute.getContext(1)), degrees, pitchDegrees)).getAttribute(attribute.fulfill(attributePos));
                    }
                    if (dEntity.matches(attribute.getContext(1))) {
                        return new Element(NMSHandler.getInstance().getEntityHelper().isFacingLocation(this, dEntity.valueOf(attribute.getContext(1)).getBukkitEntity().getLocation(), degrees, pitchDegrees)).getAttribute(attribute.fulfill(attributePos));
                    }
                } else {
                    degrees = attribute.getIntContext(2);
                    ++attributePos;
                }
            }
            if (dLocation.matches(attribute.getContext(1))) {
                return new Element(NMSHandler.getInstance().getEntityHelper().isFacingLocation(this, (Location)dLocation.valueOf(attribute.getContext(1)), (float)degrees)).getAttribute(attribute.fulfill(attributePos));
            }
            if (dEntity.matches(attribute.getContext(1))) {
                return new Element(NMSHandler.getInstance().getEntityHelper().isFacingLocation(this, dEntity.valueOf(attribute.getContext(1)).getBukkitEntity().getLocation(), (float)degrees)).getAttribute(attribute.fulfill(attributePos));
            }
        }
        if (attribute.startsWith("pitch")) {
            return new Element(this.getPitch()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("with_pose")) {
            String context = attribute.getContext(1);
            Float pitch = Float.valueOf(0.0f);
            Float yaw = Float.valueOf(0.0f);
            if (dEntity.matches(context)) {
                dEntity ent = dEntity.valueOf(context);
                if (ent.isSpawned()) {
                    pitch = Float.valueOf(ent.getBukkitEntity().getLocation().getPitch());
                    yaw = Float.valueOf(ent.getBukkitEntity().getLocation().getYaw());
                }
            } else if (context.split(",").length == 2) {
                String[] split = context.split(",");
                pitch = Float.valueOf(split[0]);
                yaw = Float.valueOf(split[1]);
            }
            dLocation loc = dLocation.valueOf(this.identify());
            loc.setPitch(pitch.floatValue());
            loc.setYaw(yaw.floatValue());
            return loc.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("yaw.simple")) {
            float yaw = NMSHandler.getInstance().getEntityHelper().normalizeYaw(this.getYaw());
            if (yaw < 45.0f) {
                return new Element("South").getAttribute(attribute.fulfill(2));
            }
            if (yaw < 135.0f) {
                return new Element("West").getAttribute(attribute.fulfill(2));
            }
            if (yaw < 225.0f) {
                return new Element("North").getAttribute(attribute.fulfill(2));
            }
            if (yaw < 315.0f) {
                return new Element("East").getAttribute(attribute.fulfill(2));
            }
            return new Element("South").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("yaw.raw")) {
            return new Element(this.getYaw()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("yaw")) {
            return new Element(NMSHandler.getInstance().getEntityHelper().normalizeYaw(this.getYaw())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("rotate_around_x") && attribute.hasContext(1)) {
            double angle = attribute.getDoubleContext(1);
            double cos = Math.cos(angle);
            double d = Math.sin(angle);
            double y = this.getY() * cos - this.getZ() * d;
            double z = this.getY() * d + this.getZ() * cos;
            Location location4 = this.clone();
            location4.setY(y);
            location4.setZ(z);
            return new dLocation(location4).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("rotate_around_y") && attribute.hasContext(1)) {
            double angle = attribute.getDoubleContext(1);
            double cos = Math.cos(angle);
            double d = Math.sin(angle);
            double x = this.getX() * cos + this.getZ() * d;
            double z = this.getX() * -d + this.getZ() * cos;
            Location location5 = this.clone();
            location5.setX(x);
            location5.setZ(z);
            return new dLocation(location5).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("rotate_around_z") && attribute.hasContext(1)) {
            double angle = attribute.getDoubleContext(1);
            double cos = Math.cos(angle);
            double d = Math.sin(angle);
            double x = this.getX() * cos - this.getY() * d;
            double y = this.getZ() * d + this.getY() * cos;
            Location location6 = this.clone();
            location6.setX(x);
            location6.setY(y);
            return new dLocation(location6).getAttribute(attribute.fulfill(1));
        }
        if (attribute.matches("find") || attribute.startsWith("nearest")) {
            attribute.fulfill(1);
            if (attribute.startsWith("blocks") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<dLocation> found = new ArrayList<dLocation>();
                int radius = aH.matchesInteger(attribute.getContext(2)) ? attribute.getIntContext(2) : 10;
                List<Object> materials = new ArrayList();
                if (attribute.hasContext(1)) {
                    materials = dList.valueOf(attribute.getContext(1)).filter(dMaterial.class);
                }
                if (materials == null) {
                    return null;
                }
                int max = Settings.blockTagsMaxBlocks();
                boolean bl = false;
                attribute.fulfill(2);
                Location tstart = this.getBlock().getLocation();
                double tstartY = tstart.getY();
                block4: for (int x = -radius; x <= radius; ++x) {
                    for (int y = -radius; y <= radius; ++y) {
                        double newY = (double)y + tstartY;
                        if (newY < 0.0 || newY > 255.0) continue;
                        for (int z = -radius; z <= radius; ++z) {
                            void var6_82;
                            if (++var6_82 > max) break block4;
                            if (!Utilities.checkLocation(this, tstart.clone().add((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), (double)radius)) continue;
                            if (!materials.isEmpty()) {
                                for (dMaterial dMaterial2 : materials) {
                                    if (dMaterial2.hasData() && dMaterial2.getData() != 0) {
                                        if (!dMaterial2.matchesMaterialData(tstart.clone().add((double)x, (double)y, (double)z).getBlock().getState().getData())) continue;
                                        found.add(new dLocation(tstart.clone().add((double)x, (double)y, (double)z)));
                                        continue;
                                    }
                                    if (dMaterial2.getMaterial() != tstart.clone().add((double)x, (double)y, (double)z).getBlock().getType()) continue;
                                    found.add(new dLocation(tstart.clone().add((double)x, (double)y, (double)z)));
                                }
                                continue;
                            }
                            found.add(new dLocation(tstart.clone().add((double)x, (double)y, (double)z)));
                        }
                    }
                }
                Collections.sort(found, new Comparator<dLocation>(){

                    @Override
                    public int compare(dLocation loc1, dLocation loc2) {
                        return dLocation.this.compare(loc1, loc2);
                    }
                });
                return new dList((Collection<? extends dObject>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("surface_blocks") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<dLocation> found = new ArrayList<dLocation>();
                double radius = aH.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                Iterator<dNPC> materials = new ArrayList();
                if (attribute.hasContext(1)) {
                    materials = dList.valueOf(attribute.getContext(1)).filter(dMaterial.class);
                }
                if (materials == null) {
                    return null;
                }
                int n = Settings.blockTagsMaxBlocks();
                int index = 0;
                attribute.fulfill(2);
                Location loc = this.getBlock().getLocation().add(0.5, 0.5, 0.5);
                block8: for (double x = -radius; x <= radius; x += 1.0) {
                    for (double y = -radius; y <= radius; y += 1.0) {
                        for (double z = -radius; z <= radius; z += 1.0) {
                            if (++index > n) break block8;
                            if (!Utilities.checkLocation(loc, this.getBlock().getLocation().add(x + 0.5, y + 0.5, z + 0.5), radius)) continue;
                            Location l = this.getBlock().getLocation().clone().add(x, y, z);
                            if (!materials.isEmpty()) {
                                Iterator iterator = materials.iterator();
                                while (iterator.hasNext()) {
                                    dMaterial material = (dMaterial)iterator.next();
                                    if (!material.matchesBlock(this.getBlock().getLocation().clone().add(x, y, z).getBlock()) || l.clone().add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR || l.clone().add(0.0, 2.0, 0.0).getBlock().getType() != Material.AIR || l.getBlock().getType() == Material.AIR) continue;
                                    found.add(new dLocation(this.getBlock().getLocation().clone().add(x + 0.5, y, z + 0.5)));
                                }
                                continue;
                            }
                            if (l.clone().add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR || l.clone().add(0.0, 2.0, 0.0).getBlock().getType() != Material.AIR || l.getBlock().getType() == Material.AIR) continue;
                            found.add(new dLocation(this.getBlock().getLocation().clone().add(x + 0.5, y, z + 0.5)));
                        }
                    }
                }
                Collections.sort(found, new Comparator<dLocation>(){

                    @Override
                    public int compare(dLocation loc1, dLocation loc2) {
                        return dLocation.this.compare(loc1, loc2);
                    }
                });
                return new dList((Collection<? extends dObject>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("players") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<dPlayer> found = new ArrayList<dPlayer>();
                double radius = aH.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                attribute.fulfill(2);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.isDead() || !Utilities.checkLocation(this, player.getLocation(), radius)) continue;
                    found.add(new dPlayer(player));
                }
                Collections.sort(found, new Comparator<dPlayer>(){

                    @Override
                    public int compare(dPlayer pl1, dPlayer pl2) {
                        return dLocation.this.compare(pl1.getLocation(), pl2.getLocation());
                    }
                });
                return new dList((Collection<? extends dObject>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("npcs") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<dNPC> found = new ArrayList<dNPC>();
                double radius = aH.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                attribute.fulfill(2);
                for (dNPC dNPC2 : DenizenAPI.getSpawnedNPCs()) {
                    if (!Utilities.checkLocation(this.getBlock().getLocation(), (Location)dNPC2.getLocation(), radius)) continue;
                    found.add(dNPC2);
                }
                Collections.sort(found, new Comparator<dNPC>(){

                    @Override
                    public int compare(dNPC npc1, dNPC npc2) {
                        return dLocation.this.compare(npc1.getLocation(), npc2.getLocation());
                    }
                });
                return new dList((Collection<? extends dObject>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("entities") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                dList ent_list = new dList();
                if (attribute.hasContext(1)) {
                    ent_list = dList.valueOf(attribute.getContext(1));
                }
                ArrayList<dEntity> found = new ArrayList<dEntity>();
                double radius = aH.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                attribute.fulfill(2);
                block14: for (Entity entity : this.getWorld().getEntities()) {
                    if (!Utilities.checkLocation(this, entity.getLocation(), radius)) continue;
                    dEntity current = new dEntity(entity);
                    if (!ent_list.isEmpty()) {
                        for (String ent : ent_list) {
                            if (!current.comparedTo(ent)) continue;
                            found.add(current);
                            continue block14;
                        }
                        continue;
                    }
                    found.add(current);
                }
                Collections.sort(found, new Comparator<dEntity>(){

                    @Override
                    public int compare(dEntity ent1, dEntity ent2) {
                        return dLocation.this.compare(ent1.getLocation(), ent2.getLocation());
                    }
                });
                return new dList((Collection<? extends dObject>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("living_entities") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<dEntity> found = new ArrayList<dEntity>();
                double radius = aH.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                attribute.fulfill(2);
                for (Entity entity : this.getWorld().getEntities()) {
                    if (!(entity instanceof LivingEntity) || !Utilities.checkLocation(this, entity.getLocation(), radius)) continue;
                    found.add(new dEntity(entity));
                }
                Collections.sort(found, new Comparator<dEntity>(){

                    @Override
                    public int compare(dEntity ent1, dEntity ent2) {
                        return dLocation.this.compare(ent1.getLocation(), ent2.getLocation());
                    }
                });
                return new dList((Collection<? extends dObject>)found).getAttribute(attribute);
            }
        }
        if (attribute.startsWith("find_path") && attribute.hasContext(1)) {
            dLocation two = dLocation.valueOf(attribute.getContext(1));
            if (two == null) {
                return null;
            }
            List<dLocation> locs = PathFinder.getPath(this, two);
            Iterator<dEllipsoid> list = new dList();
            for (dLocation dLocation2 : locs) {
                ((dList)((Object)list)).add(dLocation2.identify());
            }
            return ((dList)((Object)list)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("formatted.citizens")) {
            return new Element(this.getX() + ":" + this.getY() + ":" + this.getZ() + ":" + this.getWorld().getName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("formatted")) {
            return new Element("X '" + this.getX() + "', Y '" + this.getY() + "', Z '" + this.getZ() + "', in world '" + this.getWorld().getName() + "'").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("chunk") || attribute.startsWith("get_chunk")) {
            return new dChunk(this).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("raw")) {
            dLocation rawLocation = new dLocation(this);
            rawLocation.setRaw(true);
            return rawLocation.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("world")) {
            return dWorld.mirrorBukkitWorld(this.getWorld()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("x")) {
            return new Element(this.getX()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("y")) {
            return new Element(this.getY()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("z")) {
            return new Element(this.getZ()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("notable_name")) {
            String notname = NotableManager.getSavedId(this);
            if (notname == null) {
                return null;
            }
            return new Element(notname).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("add") && attribute.hasContext(1)) {
            String[] ints = attribute.getContext(1).replace("l@", "").split(",", 4);
            if (ints.length >= 3) {
                if ((aH.matchesDouble(ints[0]) || aH.matchesInteger(ints[0])) && (aH.matchesDouble(ints[1]) || aH.matchesInteger(ints[1])) && (aH.matchesDouble(ints[2]) || aH.matchesInteger(ints[2]))) {
                    return new dLocation(this.clone().add(Double.valueOf(ints[0]).doubleValue(), Double.valueOf(ints[1]).doubleValue(), Double.valueOf(ints[2]).doubleValue())).getAttribute(attribute.fulfill(1));
                }
            } else if (dLocation.matches(attribute.getContext(1))) {
                return new dLocation(this.clone().add((Location)dLocation.valueOf(attribute.getContext(1)))).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("sub") && attribute.hasContext(1)) {
            String[] ints = attribute.getContext(1).replace("l@", "").split(",", 4);
            if (ints.length == 3 || ints.length == 4) {
                if ((aH.matchesDouble(ints[0]) || aH.matchesInteger(ints[0])) && (aH.matchesDouble(ints[1]) || aH.matchesInteger(ints[1])) && (aH.matchesDouble(ints[2]) || aH.matchesInteger(ints[2]))) {
                    return new dLocation(this.clone().subtract(Double.valueOf(ints[0]).doubleValue(), Double.valueOf(ints[1]).doubleValue(), Double.valueOf(ints[2]).doubleValue())).getAttribute(attribute.fulfill(1));
                }
            } else if (dLocation.matches(attribute.getContext(1))) {
                return new dLocation(this.clone().subtract((Location)dLocation.valueOf(attribute.getContext(1)))).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("mul") && attribute.hasContext(1)) {
            return new dLocation(this.clone().multiply(Double.parseDouble(attribute.getContext(1)))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("div") && attribute.hasContext(1)) {
            return new dLocation(this.clone().multiply(1.0 / Double.parseDouble(attribute.getContext(1)))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("normalize")) {
            double len = Math.sqrt(Math.pow(this.getX(), 2.0) + Math.pow(this.getY(), 2.0) + Math.pow(this.getZ(), 2.0));
            if (len == 0.0) {
                return this.getAttribute(attribute.fulfill(1));
            }
            return new dLocation(this.clone().multiply(1.0 / len)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("vector_length")) {
            return new Element(Math.sqrt(Math.pow(this.getX(), 2.0) + Math.pow(this.getY(), 2.0) + Math.pow(this.getZ(), 2.0))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("distance_squared") && attribute.hasContext(1) && dLocation.matches(attribute.getContext(1))) {
            dLocation toLocation = dLocation.valueOf(attribute.getContext(1));
            if (!this.getWorld().getName().equalsIgnoreCase(toLocation.getWorld().getName())) {
                if (!attribute.hasAlternative()) {
                    dB.echoError("Can't measure distance between two different worlds!");
                }
                return null;
            }
            return new Element(this.distanceSquared(toLocation)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("distance") && attribute.hasContext(1) && dLocation.matches(attribute.getContext(1))) {
            dLocation toLocation = dLocation.valueOf(attribute.getContext(1));
            if (attribute.getAttribute(2).startsWith("horizontal")) {
                if (attribute.getAttribute(3).startsWith("multiworld")) {
                    return new Element(Math.sqrt(Math.pow(this.getX() - toLocation.getX(), 2.0) + Math.pow(this.getZ() - toLocation.getZ(), 2.0))).getAttribute(attribute.fulfill(3));
                }
                if (this.getWorld() == toLocation.getWorld()) {
                    return new Element(Math.sqrt(Math.pow(this.getX() - toLocation.getX(), 2.0) + Math.pow(this.getZ() - toLocation.getZ(), 2.0))).getAttribute(attribute.fulfill(2));
                }
            } else if (attribute.getAttribute(2).startsWith("vertical")) {
                if (attribute.getAttribute(3).startsWith("multiworld")) {
                    return new Element(Math.abs(this.getY() - toLocation.getY())).getAttribute(attribute.fulfill(3));
                }
                if (this.getWorld() == toLocation.getWorld()) {
                    return new Element(Math.abs(this.getY() - toLocation.getY())).getAttribute(attribute.fulfill(2));
                }
            }
            if (!this.getWorld().getName().equalsIgnoreCase(toLocation.getWorld().getName())) {
                if (!attribute.hasAlternative()) {
                    dB.echoError("Can't measure distance between two different worlds!");
                }
                return null;
            }
            return new Element(this.distance(toLocation)).getAttribute(attribute.fulfill(1));
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1) && attribute.startsWith("is_within_border")) {
            return new Element(this.getWorld().getWorldBorder().isInside((Location)this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_within") && attribute.hasContext(1)) {
            if (dEllipsoid.matches(attribute.getContext(1))) {
                dEllipsoid ellipsoid = dEllipsoid.valueOf(attribute.getContext(1));
                if (ellipsoid != null) {
                    return new Element(ellipsoid.contains(this)).getAttribute(attribute.fulfill(1));
                }
            } else {
                dCuboid cuboid = dCuboid.valueOf(attribute.getContext(1));
                if (cuboid != null) {
                    return new Element(cuboid.isInsideCuboid(this)).getAttribute(attribute.fulfill(1));
                }
            }
        }
        if (attribute.startsWith("biome.formatted")) {
            return new Element(CoreUtilities.toLowerCase(this.getBlock().getBiome().name()).replace('_', ' ')).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("biome")) {
            return new dBiome(this.getBlock().getBiome()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("cuboids")) {
            List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(this);
            dList cuboid_list = new dList();
            for (dCuboid cuboid : cuboids) {
                cuboid_list.add(cuboid.identify());
            }
            return cuboid_list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ellipsoids")) {
            List<dEllipsoid> ellipsoids = dEllipsoid.getNotableEllipsoidsContaining(this);
            dList ellipsoid_list = new dList();
            for (dEllipsoid ellipsoid : ellipsoids) {
                ellipsoid_list.add(ellipsoid.identify());
            }
            return ellipsoid_list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_liquid")) {
            return new Element(this.getBlock().isLiquid()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("light.from_blocks") || attribute.startsWith("light.blocks")) {
            return new Element(this.getBlock().getLightFromBlocks()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("light.from_sky") || attribute.startsWith("light.sky")) {
            return new Element(this.getBlock().getLightFromSky()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("light")) {
            return new Element(this.getBlock().getLightLevel()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("power")) {
            return new Element(this.getBlock().getBlockPower()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element("Location").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("command_block_name") && this.getBlock().getType() == MaterialCompat.COMMAND_BLOCK) {
            return new Element(((CommandBlock)this.getBlock().getState()).getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("command_block") && this.getBlock().getType() == MaterialCompat.COMMAND_BLOCK) {
            return new Element(((CommandBlock)this.getBlock().getState()).getCommand()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("furnace_burn_time")) {
            return new Element(((Furnace)this.getBlock().getState()).getBurnTime()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("furnace_cook_time")) {
            return new Element(((Furnace)this.getBlock().getState()).getCookTime()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("attached_to")) {
            BlockFace face = BlockFace.SELF;
            MaterialData data = this.getBlock().getState().getData();
            if (data instanceof Attachable) {
                face = ((Attachable)data).getAttachedFace();
            }
            if (face != BlockFace.SELF) {
                return new dLocation(this.getBlock().getRelative(face).getLocation()).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("custom_name") && this.getBlock().getState() instanceof Nameable) {
            return new Element(((Nameable)this.getBlock().getState()).getCustomName()).getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        dB.echoError("Cannot apply properties to a location!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        boolean generated;
        Furnace furnace;
        CommandBlock block;
        BlockState state;
        Element value = mechanism.getValue();
        if (mechanism.matches("data") && mechanism.hasValue()) {
            dB.echoError("Material ID and data magic number support is deprecated and WILL be removed in a future release.");
            BlockData blockData = NMSHandler.getInstance().getBlockHelper().getBlockData(this.getBlock().getType(), (byte)value.asInt());
            blockData.setBlock(this.getBlock(), false);
        }
        if (mechanism.matches("block_facing") && mechanism.requireObject(dLocation.class)) {
            dLocation faceVec = value.asType(dLocation.class);
            DirectionalBlocksHelper.setFacing(this.getBlock(), faceVec.toVector());
        }
        if (mechanism.matches("block_type") && mechanism.requireObject(dMaterial.class)) {
            dMaterial mat = value.asType(dMaterial.class);
            byte data = mat.hasData() ? mat.getData() : (byte)0;
            BlockData blockData = NMSHandler.getInstance().getBlockHelper().getBlockData(mat.getMaterial(), data);
            blockData.setBlock(this.getBlock(), false);
        }
        if (mechanism.matches("biome") && mechanism.requireObject(dBiome.class)) {
            value.asType(dBiome.class).getBiome().changeBlockBiome(this);
        }
        if (mechanism.matches("spawner_type") && mechanism.requireObject(dEntity.class) && this.getBlock().getState() instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)this.getBlock().getState();
            spawner.setSpawnedType(value.asType(dEntity.class).getBukkitEntityType());
            spawner.update();
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_10_R1) && mechanism.matches("lock") && this.getBlock().getState() instanceof Lockable) {
            state = this.getBlock().getState();
            ((Lockable)state).setLock(mechanism.hasValue() ? mechanism.getValue().asString() : null);
            state.update();
        }
        if (mechanism.matches("sign_contents") && this.getBlock().getState() instanceof Sign) {
            state = (Sign)this.getBlock().getState();
            for (int i = 0; i < 4; ++i) {
                state.setLine(i, "");
            }
            dList list = value.asType(dList.class);
            if (list.size() > 4) {
                dB.echoError("Sign can only hold four lines!");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    state.setLine(i, EscapeTags.unEscape((String)list.get(i)));
                }
            }
            state.update();
        }
        if (mechanism.matches("skull_skin")) {
            BlockState blockState = this.getBlock().getState();
            Material material = this.getBlock().getType();
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2) && material != Material.PLAYER_HEAD && material != Material.PLAYER_WALL_HEAD) {
                dB.echoError("As of Minecraft version 1.13 you may only set the skin of a PLAYER_HEAD or PLAYER_WALL_HEAD.");
            } else if (blockState instanceof Skull) {
                PlayerProfile profile;
                dList list = mechanism.getValue().asType(dList.class);
                String idString = (String)list.get(0);
                String texture = null;
                if (list.size() > 1) {
                    texture = (String)list.get(1);
                }
                if (idString.contains("-")) {
                    UUID uuid = UUID.fromString(idString);
                    String name = null;
                    if (list.size() > 2) {
                        name = (String)list.get(2);
                    }
                    profile = new PlayerProfile(name, uuid, texture);
                } else {
                    profile = new PlayerProfile(idString, null, texture);
                }
                profile = NMSHandler.getInstance().fillPlayerProfile(profile);
                if (texture != null) {
                    profile.setTexture(texture);
                }
                NMSHandler.getInstance().getBlockHelper().setPlayerProfile((Skull)blockState, profile);
            }
        }
        if (mechanism.matches("flowerpot_contents") && mechanism.requireObject(dMaterial.class)) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
                dB.echoError("As of Minecraft version 1.13 potted flowers each have their own material, such as POTTED_CACTUS.");
            } else if (this.getBlock().getType() == Material.FLOWER_POT) {
                MaterialData data = value.asType(dMaterial.class).getMaterialData();
                NMSHandler.getInstance().getBlockHelper().setFlowerpotContents(this.getBlock(), data);
            }
        }
        if (mechanism.matches("command_block_name") && this.getBlock().getType() == MaterialCompat.COMMAND_BLOCK) {
            block = (CommandBlock)this.getBlock().getState();
            block.setName(value.asString());
            block.update();
        }
        if (mechanism.matches("command_block") && this.getBlock().getType() == MaterialCompat.COMMAND_BLOCK) {
            block = (CommandBlock)this.getBlock().getState();
            block.setCommand(value.asString());
            block.update();
        }
        if (mechanism.matches("custom_name") && this.getBlock().getState() instanceof Nameable) {
            String title = null;
            if (mechanism.hasValue()) {
                title = mechanism.getValue().asString();
            }
            BlockState state2 = this.getBlock().getState();
            ((Nameable)state2).setCustomName(title);
            state2.update(true);
        }
        if (mechanism.matches("furnace_burn_time") && MaterialCompat.isFurnace(this.getBlock().getType())) {
            furnace = (Furnace)this.getBlock().getState();
            furnace.setBurnTime((short)value.asInt());
            furnace.update();
        }
        if (mechanism.matches("furnace_cook_time") && MaterialCompat.isFurnace(this.getBlock().getType())) {
            furnace = (Furnace)this.getBlock().getState();
            furnace.setCookTime((short)value.asInt());
            furnace.update();
        }
        if (mechanism.matches("base_color")) {
            Banner banner = (Banner)this.getBlock().getState();
            banner.setBaseColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            banner.update();
        }
        if (mechanism.matches("patterns")) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            dList list = mechanism.getValue().asType(dList.class);
            for (String string : list) {
                try {
                    List<String> split = CoreUtilities.split(string, '/', 2);
                    patterns.add(new Pattern(DyeColor.valueOf((String)split.get(0).toUpperCase()), PatternType.valueOf((String)split.get(1).toUpperCase())));
                }
                catch (Exception e) {
                    dB.echoError("Could not apply pattern to banner: " + string);
                }
            }
            Banner banner = (Banner)this.getBlock().getState();
            banner.setPatterns(patterns);
            banner.update();
        }
        if (mechanism.matches("head_rotation") && mechanism.requireInteger()) {
            Skull sk = (Skull)this.getBlock().getState();
            sk.setRotation(this.getSkullBlockFace(value.asInt() - 1));
            sk.update();
        }
        if (mechanism.matches("generate_tree") && mechanism.requireEnum(false, (Enum<?>[])TreeType.values()) && !(generated = this.getWorld().generateTree((Location)this, TreeType.valueOf((String)value.asString().toUpperCase())))) {
            dB.echoError("Could not generate tree at " + this.identifySimple() + ". Make sure this location can naturally generate a tree!");
        }
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }
}

