/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Chest;
import org.bukkit.util.Vector;

public class MaterialHalf
implements Property {
    public static final String[] handledMechs = new String[]{"half"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && MaterialHalf.isHalfData(((MaterialTag)material).getModernData());
    }

    public static boolean isHalfData(BlockData data) {
        return data instanceof Bisected || data instanceof Bed || data instanceof Chest;
    }

    public static MaterialHalf getFrom(ObjectTag _material) {
        if (!MaterialHalf.describes(_material)) {
            return null;
        }
        return new MaterialHalf((MaterialTag)_material);
    }

    private MaterialHalf(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerTag("half", (attribute, material) -> {
            String halfName = material.getHalfName();
            if (halfName == null) {
                return null;
            }
            return new ElementTag(halfName);
        }, new String[0]);
        PropertyParser.registerTag("relative_vector", (attribute, material) -> {
            Vector vector = material.getRelativeBlockVector();
            if (vector == null) {
                return null;
            }
            return new LocationTag(vector);
        }, new String[0]);
    }

    public static String getHalfName(BlockData data) {
        if (data instanceof Bisected) {
            return ((Bisected)data).getHalf().name();
        }
        if (data instanceof Bed) {
            return ((Bed)data).getPart().name();
        }
        if (data instanceof Chest) {
            if (((Chest)data).getType() == Chest.Type.SINGLE) {
                return null;
            }
            return ((Chest)data).getType().name();
        }
        return null;
    }

    public String getHalfName() {
        return MaterialHalf.getHalfName(this.material.getModernData());
    }

    public static void setHalfByName(BlockData data, String name) {
        if (data instanceof Bisected) {
            ((Bisected)data).setHalf(Bisected.Half.valueOf((String)name));
        } else if (data instanceof Bed) {
            ((Bed)data).setPart(Bed.Part.valueOf((String)name));
        } else if (data instanceof Chest) {
            ((Chest)data).setType(Chest.Type.valueOf((String)name));
        }
    }

    public static Vector getRelativeBlockVector(BlockData data) {
        if (data instanceof Bisected) {
            if (((Bisected)data).getHalf() == Bisected.Half.TOP) {
                return new Vector(0, -1, 0);
            }
            return new Vector(0, 1, 0);
        }
        if (data instanceof Bed) {
            BlockFace face = ((Directional)data).getFacing();
            if (((Bed)data).getPart() == Bed.Part.HEAD) {
                face = face.getOppositeFace();
            }
            return face.getDirection();
        }
        if (data instanceof Chest) {
            if (((Chest)data).getType() == Chest.Type.SINGLE) {
                return null;
            }
            Vector direction = ((Directional)data).getFacing().getDirection();
            if (((Chest)data).getType() == Chest.Type.LEFT) {
                return new Vector(-direction.getZ(), 0.0, direction.getX());
            }
            return new Vector(direction.getZ(), 0.0, -direction.getX());
        }
        return null;
    }

    public Vector getRelativeBlockVector() {
        return MaterialHalf.getRelativeBlockVector(this.material.getModernData());
    }

    @Override
    public String getPropertyString() {
        return this.getHalfName();
    }

    @Override
    public String getPropertyId() {
        return "half";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("half")) {
            MaterialHalf.setHalfByName(this.material.getModernData(), mechanism.getValue().asString().toUpperCase());
        }
    }
}

