/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.ChatColor;

public class TextTags {
    public TextTags(Denizen denizen) {
        TagManager.registerTagEvents(this);
        for (ChatColor color : ChatColor.values()) {
            String nameVal = CoreUtilities.toLowerCase(color.name());
            String codeVal = "&" + String.valueOf(color.getChar());
            final String retVal = color.toString();
            TagManager.registerTagHandler(new TagRunnable.RootForm(){

                @Override
                public void run(ReplaceableTagEvent event) {
                    event.setReplacedObject(new Element(retVal).getObjectAttribute(event.getAttributes().fulfill(1)));
                }
            }, nameVal, codeVal);
        }
    }

    @TagManager.TagEvents
    public void specialCharacterTags(ReplaceableTagEvent event) {
        if (!event.getName().startsWith("&")) {
            return;
        }
        String lower = CoreUtilities.toLowerCase(event.getName());
        Attribute attribute = event.getAttributes();
        if (event.getName().equals("&auml")) {
            event.setReplaced(new Element("\u00e4").getAttribute(attribute.fulfill(1)));
        } else if (event.getName().equals("&Auml")) {
            event.setReplaced(new Element("\u00c4").getAttribute(attribute.fulfill(1)));
        } else if (event.getName().equals("&ouml")) {
            event.setReplaced(new Element("\u00f6").getAttribute(attribute.fulfill(1)));
        } else if (event.getName().equals("&Ouml")) {
            event.setReplaced(new Element("\u00d6").getAttribute(attribute.fulfill(1)));
        } else if (event.getName().equals("&uuml")) {
            event.setReplaced(new Element("\u00fc").getAttribute(attribute.fulfill(1)));
        } else if (event.getName().equals("&Uuml")) {
            event.setReplaced(new Element("\u00dc").getAttribute(attribute.fulfill(1)));
        }
        if (lower.equals("&nl")) {
            event.setReplaced(new Element("\n").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&amp")) {
            event.setReplaced(new Element("&").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&cm")) {
            event.setReplaced(new Element(",").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&ss")) {
            event.setReplaced(new Element("\u00a7").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&sq")) {
            event.setReplaced(new Element("'").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&sp")) {
            event.setReplaced(new Element(String.valueOf(' ')).getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&nbsp")) {
            event.setReplaced(new Element(String.valueOf('\u00a0')).getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&dq")) {
            event.setReplaced(new Element("\"").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&co")) {
            event.setReplaced(new Element(":").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&sc")) {
            event.setReplaced(new Element(String.valueOf('\u2011')).getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&rb")) {
            event.setReplaced(new Element("]").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&lb")) {
            event.setReplaced(new Element("[").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&rc")) {
            event.setReplaced(new Element("}").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&lc")) {
            event.setReplaced(new Element("{").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&ns")) {
            event.setReplaced(new Element("#").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&pc")) {
            event.setReplaced(new Element("%").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&pipe")) {
            event.setReplaced(new Element("|").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&ds")) {
            event.setReplaced(new Element("$").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&lt")) {
            event.setReplaced(new Element(String.valueOf('\u0001')).getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&gt")) {
            event.setReplaced(new Element(String.valueOf('\u0002')).getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&bs")) {
            event.setReplaced(new Element("\\").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&at")) {
            event.setReplaced(new Element("@").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&dot")) {
            event.setReplaced(new Element(".").getAttribute(attribute.fulfill(1)));
        } else if (lower.equals("&hrt")) {
            event.setReplaced(new Element("\u2665").getAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("&chr") && attribute.hasContext(1)) {
            event.setReplaced(String.valueOf((char)Integer.parseInt(attribute.getContext(1), 16)));
        }
    }
}

