/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects.properties;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class PropertyParser {
    static Map<Class<? extends dObject>, Map<String, List<PropertyGetter>>> propgetters = new HashMap<Class<? extends dObject>, Map<String, List<PropertyGetter>>>();
    public static List<Property> empty = new ArrayList<Property>();

    public static void registerProperty(PropertyGetter getter, Class<? extends dObject> object) {
        PropertyParser.registerProperty(getter, object, new String[]{null});
    }

    public static void insert(Map<String, List<PropertyGetter>> gettyByTag, String attrl, PropertyGetter getter) {
        List<PropertyGetter> getters = gettyByTag.get(attrl);
        if (getters == null) {
            getters = new ArrayList<PropertyGetter>();
            gettyByTag.put(attrl, getters);
        }
        getters.add(getter);
    }

    public static void registerProperty(PropertyGetter getter, Class<? extends dObject> object, String ... attrLow) {
        Map<String, List<PropertyGetter>> gettyByTag = propgetters.get(object);
        if (gettyByTag == null) {
            gettyByTag = new HashMap<String, List<PropertyGetter>>();
            propgetters.put(object, gettyByTag);
        }
        for (String attrl : attrLow) {
            PropertyParser.insert(gettyByTag, attrl, getter);
        }
        PropertyParser.insert(gettyByTag, "_all_", getter);
    }

    public static void registerProperty(Class property, Class<? extends dObject> object) {
        try {
            final Method getf = property.getMethod("getFrom", dObject.class);
            getf.setAccessible(true);
            PropertyGetter getter = new PropertyGetter(){

                @Override
                public Property get(dObject obj) {
                    try {
                        Object o = getf.invoke(null, obj);
                        if (o instanceof Property) {
                            return (Property)o;
                        }
                    }
                    catch (IllegalAccessException e) {
                        dB.echoError(e);
                    }
                    catch (InvocationTargetException e) {
                        dB.echoError(e);
                    }
                    return null;
                }
            };
            PropertyParser.registerProperty(getter, object);
        }
        catch (NoSuchMethodException e) {
            dB.echoError("Unable to register property '" + property.getSimpleName() + "'!");
        }
    }

    public static String getPropertiesString(dObject object) {
        StringBuilder prop_string = new StringBuilder();
        for (Property property : PropertyParser.getProperties(object)) {
            String description = property.getPropertyString();
            if (description == null) continue;
            prop_string.append(property.getPropertyId()).append('=').append(description.replace(';', '\u2011')).append(';');
        }
        if (prop_string.length() > 0) {
            return "[" + prop_string.substring(0, prop_string.length() - 1) + "]";
        }
        return "";
    }

    public static List<Property> getProperties(dObject object, String attribLow) {
        Map<String, List<PropertyGetter>> gettyByTag = propgetters.get(object.getClass());
        if (gettyByTag != null) {
            Property propGot;
            List<Property> returnMe = empty;
            List<PropertyGetter> getty = gettyByTag.get(attribLow);
            if (getty != null) {
                returnMe = new ArrayList<Property>(getty.size());
                for (PropertyGetter property : getty) {
                    propGot = property.get(object);
                    if (propGot == null) continue;
                    returnMe.add(propGot);
                }
            }
            if ((getty = gettyByTag.get(null)) != null) {
                if (returnMe == empty) {
                    returnMe = new ArrayList<Property>(getty.size());
                }
                for (PropertyGetter property : getty) {
                    propGot = property.get(object);
                    if (propGot == null) continue;
                    returnMe.add(propGot);
                }
            }
            return returnMe;
        }
        return empty;
    }

    public static List<Property> getProperties(dObject object) {
        List<PropertyGetter> getty;
        Map<String, List<PropertyGetter>> gettyByTag = propgetters.get(object.getClass());
        if (gettyByTag != null && (getty = gettyByTag.get("_all_")) != null) {
            ArrayList<Property> props = new ArrayList<Property>();
            for (PropertyGetter property : getty) {
                Property propGot = property.get(object);
                if (propGot == null) continue;
                props.add(propGot);
            }
            return props;
        }
        return empty;
    }

    public static abstract class PropertyGetter {
        public abstract Property get(dObject var1);
    }
}

