/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.vehicle;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleMoveEvent;

public class VehicleMoveScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static VehicleMoveScriptEvent instance;
    public EntityTag vehicle;
    public LocationTag from;
    public LocationTag to;
    public VehicleMoveEvent event;

    public VehicleMoveScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("moves")) {
            return false;
        }
        return this.couldMatchVehicle(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!VehicleMoveScriptEvent.tryEntity(this.vehicle, path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.runInCheck(path, this.vehicle.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "VehicleMoves";
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "from": {
                return this.from;
            }
            case "to": {
                return this.to;
            }
            case "vehicle": {
                return this.vehicle;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVehicleMove(VehicleMoveEvent event) {
        this.to = new LocationTag(event.getTo());
        this.from = new LocationTag(event.getFrom());
        this.vehicle = new EntityTag((Entity)event.getVehicle());
        this.event = event;
        this.fire((Event)event);
    }
}

