/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.TreeType;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.StructureGrowEvent;

public class StructureGrowsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static StructureGrowsScriptEvent instance;
    public StructureGrowEvent event;

    public StructureGrowsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("grows")) {
            return false;
        }
        String type = path.eventArgLowerAt(0);
        return type.equals("structure") || type.equals("plant") || this.couldMatchEnum(type, (Enum<?>[])TreeType.values());
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String struct = path.eventArgLowerAt(0);
        if (!(struct.equals("structure") || struct.equals("plant") || struct.equals(CoreUtilities.toLowerCase(this.event.getSpecies().name())))) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("from") && !this.event.isFromBonemeal()) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("naturally") && this.event.isFromBonemeal()) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "StructureGrow";
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "world": {
                return new WorldTag(this.event.getWorld());
            }
            case "location": {
                return new LocationTag(this.event.getLocation());
            }
            case "structure": {
                return new ElementTag(this.event.getSpecies().name());
            }
            case "blocks": {
                ListTag blocks = new ListTag();
                for (BlockState block : this.event.getBlocks()) {
                    blocks.addObject(new LocationTag(block.getLocation()));
                }
                return blocks;
            }
            case "new_materials": {
                ListTag new_materials = new ListTag();
                for (BlockState block : this.event.getBlocks()) {
                    new_materials.addObject(new MaterialTag(block));
                }
                return new_materials;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onStructureGrow(StructureGrowEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

