/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.ArrayList;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.interfaces.BlockData;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Jukebox;
import org.bukkit.block.NoteBlock;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.inventory.InventoryHolder;

public class CopyBlockCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesArgumentType(dLocation.class) && !scriptEntry.hasObject("location") && !arg.matchesPrefix("t", "to")) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (arg.matchesArgumentType(dCuboid.class) && !scriptEntry.hasObject("cuboid")) {
                scriptEntry.addObject("cuboid", arg.asType(dCuboid.class));
                continue;
            }
            if (arg.matchesArgumentType(dLocation.class) && arg.matchesPrefix("t", "to")) {
                scriptEntry.addObject("destination", arg.asType(dLocation.class));
                continue;
            }
            if (arg.matches("remove_original")) {
                scriptEntry.addObject("remove", Element.TRUE);
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location") && !scriptEntry.hasObject("cuboid")) {
            throw new InvalidArgumentsException("Must specify a source location or cuboid.");
        }
        if (!scriptEntry.hasObject("destination")) {
            throw new InvalidArgumentsException("Must specify a destination location.");
        }
        scriptEntry.defaultObject("remove", Element.FALSE);
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation copy_location = (dLocation)scriptEntry.getObject("location");
        dLocation destination = (dLocation)scriptEntry.getObject("destination");
        dCuboid copy_cuboid = (dCuboid)scriptEntry.getObject("cuboid");
        Element remove_original = (Element)scriptEntry.getObject("remove");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), (copy_location != null ? copy_location.debug() : "") + (copy_cuboid != null ? copy_cuboid.debug() : "") + destination.debug() + remove_original.debug());
        }
        ArrayList<dLocation> locations = new ArrayList<dLocation>();
        if (copy_location != null) {
            locations.add(copy_location);
        } else if (copy_cuboid != null) {
            locations.addAll(copy_cuboid.getBlockLocations());
        }
        for (Location location : locations) {
            Block source = location.getBlock();
            BlockState sourceState = source.getState();
            Block update = destination.getBlock();
            BlockData blockData = NMSHandler.getInstance().getBlockHelper().getBlockData(source);
            blockData.setBlock(update, false);
            BlockState updateState = update.getState();
            if (sourceState instanceof InventoryHolder) {
                ((InventoryHolder)updateState).getInventory().setContents(((InventoryHolder)sourceState).getInventory().getContents());
            } else if (sourceState instanceof Sign) {
                int n = 0;
                for (String line : ((Sign)sourceState).getLines()) {
                    ((Sign)updateState).setLine(n, line);
                    ++n;
                }
            } else if (sourceState instanceof NoteBlock) {
                ((NoteBlock)updateState).setNote(((NoteBlock)sourceState).getNote());
            } else if (sourceState instanceof Skull) {
                ((Skull)updateState).setSkullType(((Skull)sourceState).getSkullType());
                ((Skull)updateState).setOwner(((Skull)sourceState).getOwner());
                ((Skull)updateState).setRotation(((Skull)sourceState).getRotation());
            } else if (sourceState instanceof Jukebox) {
                ((Jukebox)updateState).setPlaying(((Jukebox)sourceState).getPlaying());
            } else if (sourceState instanceof Banner) {
                ((Banner)updateState).setBaseColor(((Banner)sourceState).getBaseColor());
                ((Banner)updateState).setPatterns(((Banner)sourceState).getPatterns());
            } else if (sourceState instanceof CommandBlock) {
                ((CommandBlock)updateState).setName(((CommandBlock)sourceState).getName());
                ((CommandBlock)updateState).setCommand(((CommandBlock)sourceState).getCommand());
            } else if (sourceState instanceof CreatureSpawner) {
                ((CreatureSpawner)updateState).setSpawnedType(((CreatureSpawner)sourceState).getSpawnedType());
                ((CreatureSpawner)updateState).setDelay(((CreatureSpawner)sourceState).getDelay());
            }
            updateState.update();
            if (!remove_original.asBoolean()) continue;
            location.getBlock().setType(Material.AIR);
        }
    }
}

