/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.server;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.events.ScriptEvent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public class InternalEventScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static InternalEventScriptEvent instance;

    public InternalEventScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("internal bukkit event")) {
            return false;
        }
        return path.switches.containsKey("event");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        return this.currentEvent.getClass().getCanonicalName().equals(path.switches.get("event"));
    }

    @Override
    public String getName() {
        return "InternalBukkitEvent";
    }

    @Override
    public void destroy() {
        if (this.registeredHandlers != null) {
            for (Map.Entry handler : this.registeredHandlers) {
                ((HandlerList)handler.getValue()).unregister((RegisteredListener)handler.getKey());
            }
            this.registeredHandlers = null;
        }
    }

    @Override
    public void init() {
        this.registeredHandlers = new ArrayList();
        HashSet<String> eventsGrabbed = new HashSet<String>();
        for (ScriptEvent.ScriptPath path : new ArrayList(this.eventPaths)) {
            String eventName = path.switches.get("event");
            if (!eventsGrabbed.add(eventName)) continue;
            try {
                Class<?> clazz = Class.forName(eventName);
                if (!Event.class.isAssignableFrom(clazz)) {
                    Debug.echoError("Cannot initialize Internal Bukkit Event for event '" + eventName + "': that class is not an event class.");
                    return;
                }
                EventPriority priority = EventPriority.NORMAL;
                String bukkitPriority = path.switches.get("bukkit_priority");
                if (bukkitPriority != null) {
                    try {
                        priority = EventPriority.valueOf((String)bukkitPriority.toUpperCase());
                    }
                    catch (IllegalArgumentException ex) {
                        Debug.echoError("Invalid 'bukkit_priority' switch for event '" + path.event + "' in script '" + path.container.getName() + "'.");
                        Debug.echoError(ex);
                    }
                }
                InternalEventScriptEvent handler = (InternalEventScriptEvent)this.clone();
                handler.eventPaths = new ArrayList();
                handler.eventPaths.add(path);
                handler.registeredHandlers = null;
                handler.initForPriority(priority, this, clazz);
                this.eventPaths.remove(path);
            }
            catch (ClassNotFoundException ex) {
                Debug.echoError("Cannot initialize Internal Bukkit Event for event '" + eventName + "': that event class does not exist.");
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
    }

    public void initForPriority(EventPriority priority, InternalEventScriptEvent baseEvent, Class<? extends Event> clazz) {
        Denizen plugin = Denizen.getInstance();
        for (Map.Entry entry : plugin.getPluginLoader().createRegisteredListeners((Listener)this, (Plugin)plugin).entrySet()) {
            for (RegisteredListener registeredListener : (Set)entry.getValue()) {
                RegisteredListener newListener = new RegisteredListener((Listener)this, InternalEventScriptEvent.getExecutor(registeredListener), priority, (Plugin)plugin, false);
                HandlerList handlers = InternalEventScriptEvent.getEventListeners(clazz);
                handlers.register(newListener);
                baseEvent.registeredHandlers.add(new AbstractMap.SimpleEntry<RegisteredListener, HandlerList>(newListener, handlers));
            }
        }
    }

    @EventHandler
    public void onEventHappens(Event event) {
        this.fire(event);
    }
}

