/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HealCommand
extends AbstractCommand {
    public HealCommand() {
        this.setName("heal");
        this.setSyntax("heal (<#.#>) ({player}/<entity>|...)");
        this.setRequiredArguments(0, 2);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean specified_targets = false;
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("amount") && arg.matchesFloat()) {
                scriptEntry.addObject("amount", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentType(ListTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                specified_targets = true;
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("entities", Collections.singletonList(arg.asType(EntityTag.class)));
                specified_targets = true;
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("amount")) {
            scriptEntry.addObject("amount", new ElementTag(-1));
        }
        if (!specified_targets) {
            ArrayList<EntityTag> entities = new ArrayList<EntityTag>();
            if (Utilities.getEntryPlayer(scriptEntry) != null) {
                entities.add(Utilities.getEntryPlayer(scriptEntry).getDenizenEntity());
            } else if (Utilities.getEntryNPC(scriptEntry) != null) {
                entities.add(Utilities.getEntryNPC(scriptEntry).getDenizenEntity());
            } else {
                throw new InvalidArgumentsException("No valid target entities found.");
            }
            scriptEntry.addObject("entities", entities);
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List entities = (List)scriptEntry.getObject("entities");
        if (entities == null) {
            return;
        }
        ElementTag amountelement = scriptEntry.getElement("amount");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), amountelement.debug() + ArgumentHelper.debugObj("entities", entities));
        }
        if (amountelement.asDouble() == -1.0) {
            for (EntityTag entity : entities) {
                if (!entity.isLivingEntity()) continue;
                entity.getLivingEntity().setHealth(entity.getLivingEntity().getMaxHealth());
            }
        } else {
            double amount = amountelement.asDouble();
            for (EntityTag entity : entities) {
                if (entity.getLivingEntity().getHealth() + amount < entity.getLivingEntity().getMaxHealth()) {
                    entity.getLivingEntity().setHealth(entity.getLivingEntity().getHealth() + amount);
                    continue;
                }
                entity.getLivingEntity().setHealth(entity.getLivingEntity().getMaxHealth());
            }
        }
    }
}

