/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.triggers.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptHelper;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.tags.TagManager;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class DamageTrigger
extends AbstractTrigger
implements Listener {
    @EventHandler
    public void damageTrigger(EntityDamageByEntityEvent event) {
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        context.put("damage", new ElementTag(event.getDamage()));
        if (CitizensAPI.getNPCRegistry().isNPC(event.getEntity())) {
            Map<String, String> idMap;
            NPCTag npc = new NPCTag(CitizensAPI.getNPCRegistry().getNPC(event.getEntity()));
            if (npc == null) {
                return;
            }
            if (npc.getCitizen() == null) {
                return;
            }
            EntityTag damager = new EntityTag(event.getDamager());
            if (damager.isProjectile() && damager.hasShooter()) {
                damager = damager.getShooter();
            }
            context.put("damager", damager.getDenizenObject());
            String determ = npc.action("damaged", null, context);
            if (determ != null && determ.equalsIgnoreCase("CANCELLED")) {
                event.setCancelled(true);
                return;
            }
            if (!damager.isPlayer()) {
                return;
            }
            PlayerTag dplayer = damager.getDenizenPlayer();
            if (!npc.getCitizen().hasTrait(TriggerTrait.class)) {
                return;
            }
            if (!npc.getTriggerTrait().isEnabled(this.name)) {
                return;
            }
            TriggerTrait.TriggerContext trigger = npc.getTriggerTrait().trigger(this, dplayer);
            if (!trigger.wasTriggered()) {
                return;
            }
            if (trigger.hasDetermination() && trigger.getDetermination().equalsIgnoreCase("cancelled")) {
                event.setCancelled(true);
                return;
            }
            InteractScriptContainer script = InteractScriptHelper.getInteractScript(npc, dplayer, true, this.getClass());
            String id = null;
            if (script != null && !(idMap = script.getIdMapFor(this.getClass(), dplayer)).isEmpty()) {
                for (Map.Entry<String, String> entry : idMap.entrySet()) {
                    String entry_value = TagManager.tag(entry.getValue(), new BukkitTagContext(dplayer, npc, null, false, new ScriptTag(script)));
                    if (ItemTag.valueOf(entry_value, script).comparesTo(dplayer.getPlayerEntity().getEquipment().getItemInMainHand()) < 0) continue;
                    id = entry.getKey();
                }
            }
            if (!this.parse(npc, dplayer, script, id, context)) {
                npc.action("no damage trigger", dplayer);
            }
        }
    }

    @Override
    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
    }
}

