/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.dChunk;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class dWorld
implements dObject,
Adjustable {
    static Map<String, dWorld> worlds = new HashMap<String, dWorld>();
    private String prefix;
    String world_name;
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static dWorld mirrorBukkitWorld(World world) {
        if (world == null) {
            return null;
        }
        if (worlds.containsKey(world.getName())) {
            return worlds.get(world.getName());
        }
        return new dWorld(world);
    }

    public static dWorld valueOf(String string) {
        return dWorld.valueOf(string, null);
    }

    @Fetchable(value="w")
    public static dWorld valueOf(String string, TagContext context) {
        return dWorld.valueOf(string, context == null || context.debug);
    }

    public static dWorld valueOf(String string, boolean announce) {
        if (string == null) {
            return null;
        }
        string = string.replace("w@", "");
        World returnable = null;
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(string)) continue;
            returnable = world;
        }
        if (returnable != null) {
            if (worlds.containsKey(returnable.getName())) {
                return worlds.get(returnable.getName());
            }
            return new dWorld(returnable);
        }
        if (announce) {
            net.aufdemrand.denizen.utilities.debugging.dB.echoError("Invalid World! '" + string + "' could not be found.");
        }
        return null;
    }

    public static boolean matches(String arg) {
        arg = arg.replace("w@", "");
        World returnable = null;
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(arg)) continue;
            returnable = world;
        }
        return returnable != null;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.world_name);
    }

    public String getName() {
        return this.world_name;
    }

    public List<Entity> getEntities() {
        return this.getWorld().getEntities();
    }

    public dWorld(World world) {
        this(null, world);
    }

    public dWorld(String prefix, World world) {
        this.prefix = prefix == null ? "World" : prefix;
        this.world_name = world.getName();
        if (!worlds.containsKey(world.getName())) {
            worlds.put(world.getName(), this);
        }
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "World";
    }

    @Override
    public String identify() {
        return "w@" + this.world_name;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public dObject setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static void registerTags() {
        dWorld.registerTag("entities", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                ArrayList<dEntity> entities = new ArrayList<dEntity>();
                for (Entity entity : ((dWorld)object).getWorld().getEntities()) {
                    entities.add(new dEntity(entity));
                }
                return new dList((Collection<? extends dObject>)entities).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("living_entities", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                ArrayList<dEntity> entities = new ArrayList<dEntity>();
                for (Entity entity : ((dWorld)object).getWorld().getLivingEntities()) {
                    entities.add(new dEntity(entity));
                }
                return new dList((Collection<? extends dObject>)entities).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("players", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                ArrayList<dPlayer> players = new ArrayList<dPlayer>();
                for (Player player : ((dWorld)object).getWorld().getPlayers()) {
                    if (dEntity.isNPC((Entity)player)) continue;
                    players.add(new dPlayer(player));
                }
                return new dList((Collection<? extends dObject>)players).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("spawned_npcs", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                ArrayList<dNPC> npcs = new ArrayList<dNPC>();
                World thisWorld = ((dWorld)object).getWorld();
                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                    if (!npc.isSpawned() || !npc.getEntity().getLocation().getWorld().equals(thisWorld)) continue;
                    npcs.add(dNPC.mirrorCitizensNPC(npc));
                }
                return new dList((Collection<? extends dObject>)npcs).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("npcs", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                ArrayList<dNPC> npcs = new ArrayList<dNPC>();
                World thisWorld = ((dWorld)object).getWorld();
                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                    World world;
                    Location location = npc.getStoredLocation();
                    if (location == null || (world = location.getWorld()) == null || !world.equals(thisWorld)) continue;
                    npcs.add(dNPC.mirrorCitizensNPC(npc));
                }
                return new dList((Collection<? extends dObject>)npcs).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("can_generate_structures", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().canGenerateStructures()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("loaded_chunks", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList chunks = new dList();
                for (Chunk ent : ((dWorld)object).getWorld().getLoadedChunks()) {
                    chunks.add(new dChunk(ent).identify());
                }
                return chunks.getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("random_loaded_chunk", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                int random = CoreUtilities.getRandom().nextInt(((dWorld)object).getWorld().getLoadedChunks().length);
                return new dChunk(((dWorld)object).getWorld().getLoadedChunks()[random]).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("sea_level", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getSeaLevel()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("spawn_location", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new dLocation(((dWorld)object).getWorld().getSpawnLocation()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("world_type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getWorldType().getName()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("name", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getName()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("seed", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getSeed()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("allows_animals", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getAllowAnimals()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("allows_monsters", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getAllowMonsters()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("allows_pvp", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getPVP()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("auto_save", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().isAutoSave()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("ambient_spawn_limit", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getAmbientSpawnLimit()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("animal_spawn_limit", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getAnimalSpawnLimit()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("monster_spawn_limit", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getMonsterSpawnLimit()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("water_animal_spawn_limit", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getWaterAnimalSpawnLimit()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("difficulty", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getDifficulty().name()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("keep_spawn", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getKeepSpawnInMemory()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("max_height", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getMaxHeight()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("ticks_per_animal_spawn", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Duration(((dWorld)object).getWorld().getTicksPerAnimalSpawns()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("ticks_per_monster_spawn", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Duration(((dWorld)object).getWorld().getTicksPerMonsterSpawns()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("time", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if ((attribute = attribute.fulfill(1)).startsWith("duration")) {
                    return new Duration(((dWorld)object).getWorld().getTime()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("full")) {
                    return new Element(((dWorld)object).getWorld().getFullTime()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("period")) {
                    long time = ((dWorld)object).getWorld().getTime();
                    String period = time >= 23000L ? "dawn" : (time >= 13500L ? "night" : (time >= 12500L ? "dusk" : "day"));
                    return new Element(period).getAttribute(attribute.fulfill(1));
                }
                return new Element(((dWorld)object).getWorld().getTime()).getAttribute(attribute);
            }
        });
        dWorld.registerTag("moon_phase", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element((int)(((dWorld)object).getWorld().getFullTime() / 24000L % 8L) + 1).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("moonphase", registeredTags.get("moon_phase"));
        dWorld.registerTag("has_storm", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().hasStorm()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("thunder_duration", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Duration((long)((dWorld)object).getWorld().getThunderDuration()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("thundering", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().isThundering()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("weather_duration", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Duration((long)((dWorld)object).getWorld().getWeatherDuration()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("environment", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getEnvironment().name()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("prefix", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).prefix).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element("World").getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("border_size", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getWorldBorder().getSize()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("border_center", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new dLocation(((dWorld)object).getWorld().getWorldBorder().getCenter()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("border_damage", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getWorldBorder().getDamageAmount()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("border_damage_buffer", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getWorldBorder().getDamageBuffer()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("border_warning_distance", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dWorld)object).getWorld().getWorldBorder().getWarningDistance()).getAttribute(attribute.fulfill(1));
            }
        });
        dWorld.registerTag("border_warning_time", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Duration(((dWorld)object).getWorld().getWorldBorder().getWarningTime()).getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        net.aufdemrand.denizen.utilities.debugging.dB.echoError("Cannot apply properties to a world!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        String upper;
        Difficulty diff;
        Element value = mechanism.getValue();
        if (mechanism.matches("ambient_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setAmbientSpawnLimit(value.asInt());
        }
        if (mechanism.matches("animal_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setAnimalSpawnLimit(value.asInt());
        }
        if (mechanism.matches("auto_save") && mechanism.requireBoolean()) {
            this.getWorld().setAutoSave(value.asBoolean());
        }
        if (mechanism.matches("difficulty") && mechanism.requireEnum(true, (Enum<?>[])Difficulty.values()) && (diff = (upper = value.asString().toUpperCase()).matches("(PEACEFUL|EASY|NORMAL|HARD)") ? Difficulty.valueOf((String)upper) : Difficulty.getByValue((int)value.asInt())) != null) {
            this.getWorld().setDifficulty(diff);
        }
        if (mechanism.matches("save")) {
            this.getWorld().save();
        }
        if (mechanism.matches("destroy")) {
            if (!Settings.allowDelete()) {
                net.aufdemrand.denizen.utilities.debugging.dB.echoError("Unable to delete due to config.");
                return;
            }
            File folder = new File(this.getWorld().getName());
            Bukkit.getServer().unloadWorld(this.getWorld(), false);
            try {
                FileUtils.deleteDirectory((File)folder);
            }
            catch (Exception ex) {
                net.aufdemrand.denizen.utilities.debugging.dB.echoError(ex);
            }
            return;
        }
        if (mechanism.matches("force_unload")) {
            Bukkit.getServer().unloadWorld(this.getWorld(), false);
            return;
        }
        if (mechanism.matches("full_time") && mechanism.requireInteger()) {
            this.getWorld().setFullTime((long)value.asInt());
        }
        if (mechanism.matches("keep_spawn") && mechanism.requireBoolean()) {
            this.getWorld().setKeepSpawnInMemory(value.asBoolean());
        }
        if (mechanism.matches("monster_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setMonsterSpawnLimit(value.asInt());
        }
        if (mechanism.matches("allow_pvp") && mechanism.requireBoolean()) {
            this.getWorld().setPVP(value.asBoolean());
        }
        if (mechanism.matches("spawn_location") && mechanism.requireObject(dLocation.class)) {
            dLocation loc = value.asType(dLocation.class);
            this.getWorld().setSpawnLocation(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        }
        if (mechanism.matches("storming") && mechanism.requireBoolean()) {
            this.getWorld().setStorm(value.asBoolean());
        }
        if (mechanism.matches("thunder_duration") && mechanism.requireObject(Duration.class)) {
            this.getWorld().setThunderDuration(value.asType(Duration.class).getTicksAsInt());
        }
        if (mechanism.matches("thundering") && mechanism.requireBoolean()) {
            this.getWorld().setThundering(value.asBoolean());
        }
        if (mechanism.matches("ticks_per_animal_spawns") && mechanism.requireObject(Duration.class)) {
            this.getWorld().setTicksPerAnimalSpawns(value.asType(Duration.class).getTicksAsInt());
        }
        if (mechanism.matches("ticks_per_monster_spawns") && mechanism.requireObject(Duration.class)) {
            this.getWorld().setTicksPerMonsterSpawns(value.asType(Duration.class).getTicksAsInt());
        }
        if (mechanism.matches("time") && mechanism.requireInteger()) {
            this.getWorld().setTime((long)value.asInt());
        }
        if (mechanism.matches("unload")) {
            Bukkit.getServer().unloadWorld(this.getWorld(), true);
            return;
        }
        if (mechanism.matches("water_animal_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setWaterAnimalSpawnLimit(value.asInt());
        }
        if (mechanism.matches("weather_duration") && mechanism.requireObject(Duration.class)) {
            this.getWorld().setWeatherDuration(value.asType(Duration.class).getTicksAsInt());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

