/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.impl;

import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.IRegistry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftBlock;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    private final BiomeBase biomeBase;

    public BiomeNMSImpl(Biome biome) {
        super(biome);
        World world = (World)Bukkit.getWorlds().get(0);
        this.biomeBase = CraftBlock.biomeToBiomeBase((IRegistry)((CraftWorld)world).getHandle().t().d(IRegistry.aO), (Biome)biome);
    }

    @Override
    public float getHumidity() {
        return this.biomeBase.getHumidity();
    }

    @Override
    public float getTemperature() {
        return this.biomeBase.k();
    }

    @Override
    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(EnumCreatureType.c);
    }

    @Override
    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(EnumCreatureType.b);
    }

    @Override
    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.a);
    }

    @Override
    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.e);
    }

    @Override
    public void setHumidity(float humidity) {
        Object climate = ReflectionHelper.getFieldValue(BiomeBase.class, ReflectionMappingsInfo.Biome_climateSettings, this.biomeBase);
        ReflectionHelper.setFieldValue(climate.getClass(), ReflectionMappingsInfo.Biome_ClimateSettings_downfall, climate, Float.valueOf(humidity));
    }

    @Override
    public void setTemperature(float temperature) {
        Object climate = ReflectionHelper.getFieldValue(BiomeBase.class, ReflectionMappingsInfo.Biome_climateSettings, this.biomeBase);
        ReflectionHelper.setFieldValue(climate.getClass(), ReflectionMappingsInfo.Biome_ClimateSettings_temperature, climate, Float.valueOf(temperature));
    }

    @Override
    protected boolean getDoesRain() {
        return this.biomeBase.c() == BiomeBase.Precipitation.b;
    }

    @Override
    protected boolean getDoesSnow() {
        return this.biomeBase.c() == BiomeBase.Precipitation.c;
    }

    private List<EntityType> getSpawnableEntities(EnumCreatureType creatureType) {
        BiomeSettingsMobs mobs = this.biomeBase.b();
        WeightedRandomList typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (BiomeSettingsMobs.c meta : typeSettingList.d()) {
            try {
                String n = EntityTypes.getName((EntityTypes)meta.b).getKey();
                EntityType et = EntityType.fromName((String)n);
                if (et == null) {
                    et = EntityType.valueOf((String)n.toUpperCase(Locale.ENGLISH));
                }
                entityTypes.add(et);
            }
            catch (Throwable throwable) {}
        }
        return entityTypes;
    }
}

