/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemDisplayname
implements Property {
    public static final String[] handledTags = new String[]{"display", "has_display"};
    public static final String[] handledMechs = new String[]{"display", "display_name"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag;
    }

    public static ItemDisplayname getFrom(ObjectTag _item) {
        if (!ItemDisplayname.describes(_item)) {
            return null;
        }
        return new ItemDisplayname((ItemTag)_item);
    }

    private ItemDisplayname(ItemTag _item) {
        this.item = _item;
    }

    public boolean hasDisplayName() {
        return this.item.getItemMeta() != null && this.item.getItemMeta().hasDisplayName();
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("display") && this.hasDisplayName()) {
            return new ElementTag(NMSHandler.getItemHelper().getDisplayName(this.item), true).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_display")) {
            return new ElementTag(this.hasDisplayName()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        if (this.hasDisplayName()) {
            return NMSHandler.getItemHelper().getDisplayName(this.item);
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "display";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("display")) {
            NMSHandler.getItemHelper().setDisplayName(this.item, mechanism.getValue().asString());
        } else if (mechanism.matches("display_name")) {
            Deprecations.itemDisplayNameMechanism.warn(mechanism.context);
            ItemMeta meta = this.item.getItemMeta();
            meta.setDisplayName(mechanism.hasValue() ? CoreUtilities.clearNBSPs(EscapeTagBase.unEscape(mechanism.getValue().asString())) : null);
            this.item.setItemMeta(meta);
        }
    }
}

