/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.function.Consumer;

public class CooldownCommand
extends AbstractCommand {
    public CooldownCommand() {
        this.setName("cooldown");
        this.setSyntax("cooldown [<duration>] (global) (script:<script>)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (ScriptContainer script : ScriptRegistry.scriptContainers.values()) {
            if (!(script instanceof InteractScriptContainer)) continue;
            addOne.accept(script.getName());
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesPrefix("script", "s") && arg.matchesArgumentType(ScriptTag.class)) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", (Object)Type.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("type", new Object[]{Type.PLAYER});
        scriptEntry.defaultObject("script", scriptEntry.getScript());
        if (!scriptEntry.hasObject("duration")) {
            throw new InvalidArgumentsException("Requires a valid duration!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Type type;
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        Type type2 = type = scriptEntry.hasObject("type") ? (Type)((Object)scriptEntry.getObject("type")) : Type.PLAYER;
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), ArgumentHelper.debugObj("Type", type.name()), script, type.name().equalsIgnoreCase("player") ? Utilities.getEntryPlayer(scriptEntry) : null, duration);
        }
        switch (type) {
            case PLAYER: {
                CooldownCommand.setCooldown(Utilities.getEntryPlayer(scriptEntry), duration, script.getName(), false);
                break;
            }
            case GLOBAL: {
                CooldownCommand.setCooldown(null, duration, script.getName(), true);
            }
        }
    }

    public static DurationTag getCooldownDuration(PlayerTag player, String scriptName) {
        TimeTag expires = Denizen.getInstance().serverFlagMap.getFlagExpirationTime("__interact_cooldown." + scriptName);
        if (expires != null) {
            return new DurationTag((double)(expires.millis() - TimeTag.now().millis()) / 1000.0);
        }
        if (player == null) {
            return new DurationTag(0);
        }
        expires = player.getFlagTracker().getFlagExpirationTime("__interact_cooldown." + scriptName);
        if (expires != null) {
            return new DurationTag((double)(expires.millis() - TimeTag.now().millis()) / 1000.0);
        }
        return new DurationTag(0);
    }

    public static boolean checkCooldown(PlayerTag player, String scriptName) {
        DurationTag cooldown = CooldownCommand.getCooldownDuration(player, scriptName);
        return !(cooldown.getSeconds() > 0.0);
    }

    public static void setCooldown(PlayerTag player, DurationTag duration, String scriptName, boolean global) {
        TimeTag cooldownTime = new TimeTag(TimeTag.now().millis() + duration.getMillis());
        if (global) {
            Denizen.getInstance().serverFlagMap.setFlag("__interact_cooldown." + scriptName, cooldownTime, cooldownTime);
        } else {
            player.getFlagTracker().setFlag("__interact_cooldown." + scriptName, cooldownTime, cooldownTime);
        }
    }

    private static enum Type {
        GLOBAL,
        PLAYER;

    }
}

