/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.interfaces.PacketHelper;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.inventory.SlotHelper;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.scheduling.OneTimeSchedulable;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FakeItemCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("slot") && arg.matchesPrefix("slot")) {
                scriptEntry.addObject("slot", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesPrefix("duration") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("item") && arg.matchesArgumentList(dItem.class)) {
                scriptEntry.addObject("item", arg.asType(dList.class).filter(dItem.class));
                continue;
            }
            if (!scriptEntry.hasObject("players") && arg.matchesArgumentList(dPlayer.class) && arg.matchesPrefix("players")) {
                scriptEntry.addObject("players", arg.asType(dList.class).filter(dPlayer.class));
                continue;
            }
            if (!scriptEntry.hasObject("player_only") && arg.matches("player_only")) {
                scriptEntry.addObject("player_only", new Element(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("item")) {
            throw new InvalidArgumentsException("Must specify a valid item to fake!");
        }
        if (!scriptEntry.hasObject("slot")) {
            throw new InvalidArgumentsException("Must specify a valid slot!");
        }
        scriptEntry.defaultObject("duration", Duration.ZERO).defaultObject("player_only", new Element(false)).defaultObject("players", Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer()));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        int slot;
        List items = (List)scriptEntry.getObject("item");
        Element elSlot = scriptEntry.getElement("slot");
        Duration duration = (Duration)scriptEntry.getdObject("duration");
        final List players = (List)scriptEntry.getObject("players");
        Element player_only = scriptEntry.getElement("player_only");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugList("items", items) + elSlot.debug() + duration.debug() + aH.debugList("players", players) + player_only.debug());
        }
        if ((slot = SlotHelper.nameToIndex(elSlot.asString())) == -1) {
            dB.echoError(scriptEntry.getResidingQueue(), "The input '" + elSlot.asString() + "' is not a valid slot!");
            return;
        }
        final boolean playerOnly = player_only.asBoolean();
        final PacketHelper packetHelper = NMSHandler.getInstance().getPacketHelper();
        for (dItem item : items) {
            if (item == null) {
                ++slot;
                continue;
            }
            for (dPlayer player : players) {
                Player ent = player.getPlayerEntity();
                packetHelper.setSlot(ent, FakeItemCommand.translateSlot(ent, slot, playerOnly), item.getItemStack(), playerOnly);
            }
            final int slotSnapshot = slot++;
            if (!(duration.getSeconds() > 0.0)) continue;
            DenizenCore.schedule(new OneTimeSchedulable(new Runnable(){

                @Override
                public void run() {
                    for (dPlayer player : players) {
                        Player ent = player.getPlayerEntity();
                        ItemStack original = ent.getOpenInventory().getItem(FakeItemCommand.translateSlot(ent, slotSnapshot, playerOnly));
                        packetHelper.setSlot(ent, slotSnapshot, original, playerOnly);
                    }
                }
            }, (float)duration.getSeconds()));
        }
    }

    static int translateSlot(Player player, int slot, boolean player_only) {
        int total;
        if (slot < 0) {
            return 0;
        }
        int n = total = player_only ? 46 : player.getOpenInventory().countSlots();
        if (total == 46) {
            if (slot == 45) {
                return slot;
            }
            if (slot > 35) {
                slot = 8 - (slot - 36);
                return slot;
            }
            --total;
        }
        if (slot > total) {
            return total;
        }
        return (int)((double)(slot + (total - 9)) - 9.0 * (2.0 * Math.floor(slot / 9)));
    }
}

