/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_16.helpers;

import com.denizenscript.denizen.nms.interfaces.FishingHelper;
import java.util.List;
import net.minecraft.server.v1_16_R3.Enchantment;
import net.minecraft.server.v1_16_R3.EnchantmentManager;
import net.minecraft.server.v1_16_R3.Enchantments;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityFishingHook;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.IMaterial;
import net.minecraft.server.v1_16_R3.Items;
import net.minecraft.server.v1_16_R3.LootContextParameterSets;
import net.minecraft.server.v1_16_R3.LootContextParameters;
import net.minecraft.server.v1_16_R3.LootTableInfo;
import net.minecraft.server.v1_16_R3.LootTableRegistry;
import net.minecraft.server.v1_16_R3.LootTables;
import net.minecraft.server.v1_16_R3.MathHelper;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftFishHook;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FishingHelperImpl
implements FishingHelper {
    @Override
    public ItemStack getResult(FishHook fishHook, FishingHelper.CatchType catchType) {
        net.minecraft.server.v1_16_R3.ItemStack result = null;
        EntityFishingHook nmsHook = ((CraftFishHook)fishHook).getHandle();
        if (catchType == FishingHelper.CatchType.DEFAULT) {
            float f = ((CraftWorld)fishHook.getWorld()).getHandle().random.nextFloat();
            int i = EnchantmentManager.g((EntityLiving)((EntityHuman)nmsHook.getShooter()));
            int j = EnchantmentManager.a((Enchantment)Enchantments.LURE, (EntityLiving)((EntityHuman)nmsHook.getShooter()));
            float f1 = 0.1f - (float)i * 0.025f - (float)j * 0.01f;
            float f2 = 0.05f + (float)i * 0.01f - (float)j * 0.01f;
            f1 = MathHelper.a((float)f1, (float)0.0f, (float)1.0f);
            f2 = MathHelper.a((float)f2, (float)0.0f, (float)1.0f);
            result = f < f1 ? this.catchRandomJunk(nmsHook) : ((f -= f1) < f2 ? this.catchRandomTreasure(nmsHook) : this.catchRandomFish(nmsHook));
        } else if (catchType == FishingHelper.CatchType.JUNK) {
            result = this.catchRandomJunk(nmsHook);
        } else if (catchType == FishingHelper.CatchType.TREASURE) {
            result = this.catchRandomTreasure(nmsHook);
        } else if (catchType == FishingHelper.CatchType.FISH) {
            result = this.catchRandomFish(nmsHook);
        }
        if (result != null) {
            return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_16_R3.ItemStack)result);
        }
        return null;
    }

    public net.minecraft.server.v1_16_R3.ItemStack getRandomReward(EntityFishingHook hook, MinecraftKey key) {
        WorldServer worldServer = (WorldServer)hook.getWorld();
        LootTableInfo.Builder playerFishEvent2 = new LootTableInfo.Builder(worldServer);
        LootTableRegistry registry = hook.getWorld().getMinecraftServer().getLootTableRegistry();
        LootTableInfo info = playerFishEvent2.set(LootContextParameters.ORIGIN, (Object)new Vec3D(hook.locX(), hook.locY(), hook.locZ())).set(LootContextParameters.TOOL, (Object)new net.minecraft.server.v1_16_R3.ItemStack((IMaterial)Items.FISHING_ROD)).build(LootContextParameterSets.FISHING);
        List itemStacks = registry.getLootTable(key).populateLoot(info);
        return (net.minecraft.server.v1_16_R3.ItemStack)itemStacks.get(worldServer.random.nextInt(itemStacks.size()));
    }

    @Override
    public FishHook spawnHook(Location location, Player player) {
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        EntityFishingHook hook = new EntityFishingHook((EntityHuman)((CraftPlayer)player).getHandle(), (World)nmsWorld, 0, 0);
        nmsWorld.addEntity((Entity)hook);
        return (FishHook)hook.getBukkitEntity();
    }

    private net.minecraft.server.v1_16_R3.ItemStack catchRandomJunk(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, LootTables.ah);
    }

    private net.minecraft.server.v1_16_R3.ItemStack catchRandomTreasure(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, LootTables.ai);
    }

    private net.minecraft.server.v1_16_R3.ItemStack catchRandomFish(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, LootTables.aj);
    }
}

