/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.maps.DenizenMapManager;
import com.denizenscript.denizen.utilities.maps.DenizenMapRenderer;
import com.denizenscript.denizen.utilities.maps.MapCursor;
import com.denizenscript.denizen.utilities.maps.MapDot;
import com.denizenscript.denizen.utilities.maps.MapImage;
import com.denizenscript.denizen.utilities.maps.MapText;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.NaturalOrderComparator;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import org.bukkit.map.MapView;

public class MapScriptContainer
extends ScriptContainer {
    public MapScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        this.canRunScripts = false;
    }

    public void applyTo(MapView mapView) {
        DenizenMapRenderer renderer = new DenizenMapRenderer(mapView.getRenderers(), this.getString("auto update", "true").equalsIgnoreCase("true"));
        boolean debug = true;
        if (this.contains("original")) {
            renderer.displayOriginal = this.getString("original").equalsIgnoreCase("true");
        }
        if (this.contains("debug")) {
            debug = this.getString("debug").equalsIgnoreCase("true");
        }
        if (this.contains("objects")) {
            YamlConfiguration objectsSection = this.getConfigurationSection("objects");
            ArrayList<StringHolder> objectKeys1 = new ArrayList<StringHolder>(objectsSection.getKeys(false));
            ArrayList<String> objectKeys = new ArrayList<String>(objectKeys1.size());
            for (StringHolder sh : objectKeys1) {
                objectKeys.add(sh.str);
            }
            objectKeys.sort(new NaturalOrderComparator());
            for (String objectKey : objectKeys) {
                YamlConfiguration objectSection = objectsSection.getConfigurationSection(objectKey);
                if (!objectSection.contains("type")) {
                    Debug.echoError("Map script '" + this.getName() + "' has an object without a specified type!");
                    return;
                }
                String type = CoreUtilities.toLowerCase(objectSection.getString("type"));
                String x = objectSection.getString("x", "0");
                String y = objectSection.getString("y", "0");
                String visible = objectSection.getString("visible", "true");
                boolean worldC = objectSection.contains("world_coordinates") && objectSection.getString("world_coordinates", "false").equalsIgnoreCase("true");
                switch (type) {
                    case "image": {
                        if (!objectSection.contains("image")) {
                            Debug.echoError("Map script '" + this.getName() + "'s image '" + objectKey + "' has no specified image location!");
                            return;
                        }
                        String image = objectSection.getString("image");
                        int width = Integer.parseInt(objectSection.getString("width", "0"));
                        int height = Integer.parseInt(objectSection.getString("height", "0"));
                        renderer.addObject(new MapImage(x, y, visible, debug, image, width, height));
                        break;
                    }
                    case "text": {
                        if (!objectSection.contains("text")) {
                            Debug.echoError("Map script '" + this.getName() + "'s text object '" + objectKey + "' has no specified text!");
                            return;
                        }
                        String text = objectSection.getString("text");
                        renderer.addObject(new MapText(x, y, visible, debug, text));
                        break;
                    }
                    case "cursor": {
                        if (!objectSection.contains("cursor")) {
                            Debug.echoError("Map script '" + this.getName() + "'s cursor '" + objectKey + "' has no specified cursor type!");
                            return;
                        }
                        String cursor = objectSection.getString("cursor");
                        if (cursor == null) {
                            Debug.echoError("Map script '" + this.getName() + "'s cursor '" + objectKey + "' is missing a cursor type!");
                            return;
                        }
                        renderer.addObject(new MapCursor(x, y, visible, debug, objectSection.getString("direction", "0"), cursor));
                        break;
                    }
                    case "dot": {
                        renderer.addObject(new MapDot(x, y, visible, debug, objectSection.getString("radius", "1"), objectSection.getString("color", "black")));
                        break;
                    }
                    default: {
                        Debug.echoError("Weird map data!");
                    }
                }
                if (!worldC || renderer.mapObjects.size() <= 0) continue;
                renderer.mapObjects.get((int)(renderer.mapObjects.size() - 1)).worldCoordinates = true;
            }
        }
        DenizenMapManager.setMap(mapView, renderer);
    }
}

