/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects;

import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class Mechanism {
    private boolean fulfilled = false;
    private String raw_mechanism;
    private Element value;
    public TagContext context;
    public boolean isProperty = false;

    public Mechanism(Element mechanism, Element value) {
        this.raw_mechanism = CoreUtilities.toLowerCase(mechanism.asString());
        this.value = value;
    }

    public Mechanism(Element mechanism, Element value, TagContext context) {
        this(mechanism, value);
        this.context = context;
    }

    public void fulfill() {
        this.fulfilled = true;
    }

    public boolean fulfilled() {
        return this.fulfilled;
    }

    public String getName() {
        return this.raw_mechanism;
    }

    public Element getValue() {
        if (this.value == null) {
            return new Element("");
        }
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean matches(String string) {
        if (string.equals(this.raw_mechanism)) {
            this.fulfill();
            return true;
        }
        return false;
    }

    public boolean requireBoolean() {
        return this.requireBoolean("Invalid boolean. Must specify TRUE or FALSE.");
    }

    public boolean requireDouble() {
        return this.requireDouble("Invalid decimal number specified.");
    }

    public boolean requireEnum(boolean allowInt, Enum<?> ... values) {
        return this.requireEnum(null, allowInt, values);
    }

    public boolean requireFloat() {
        return this.requireFloat("Invalid decimal number specified.");
    }

    public boolean requireInteger() {
        return this.requireInteger("Invalid integer number specified.");
    }

    public <T extends dObject> boolean requireObject(Class<T> type) {
        return this.requireObject(null, type);
    }

    public boolean requireBoolean(String error) {
        if (this.hasValue() && this.value.isBoolean()) {
            return true;
        }
        this.echoError(error);
        return false;
    }

    public boolean requireDouble(String error) {
        if (this.hasValue() && this.value.isDouble()) {
            return true;
        }
        this.echoError(error);
        return false;
    }

    public boolean requireEnum(String error, boolean allowInt, Enum<?> ... values) {
        if (this.hasValue() && allowInt && this.value.isInt() && this.value.asInt() < values.length) {
            return true;
        }
        if (this.hasValue() && this.value.isString()) {
            String raw_value = this.value.asString().toUpperCase();
            for (Enum<?> check_value : values) {
                if (!raw_value.equals(check_value.name())) continue;
                return true;
            }
        }
        if (error == null) {
            this.echoError("Invalid " + values[0].getDeclaringClass().getSimpleName() + ". Must specify a valid name" + (allowInt ? " or number" : "") + ".");
        } else {
            this.echoError(error);
        }
        return false;
    }

    public boolean requireFloat(String error) {
        if (this.hasValue() && this.value.isFloat()) {
            return true;
        }
        this.echoError(error);
        return false;
    }

    public boolean requireInteger(String error) {
        if (this.hasValue() && this.value.isInt()) {
            return true;
        }
        this.echoError(error);
        return false;
    }

    public <T extends dObject> boolean requireObject(String error, Class<T> type) {
        if (this.hasValue() && this.value.matchesType(type)) {
            return true;
        }
        if (error == null) {
            this.echoError("Invalid " + type.getSimpleName() + " specified.");
        } else {
            this.echoError(error);
        }
        return false;
    }

    public boolean shouldDebug() {
        return this.context == null || this.context.debug;
    }

    public void echoError(String error) {
        dB.echoError(error);
    }

    public void reportInvalid() {
        this.echoError("Invalid mechanism specified: " + this.raw_mechanism);
    }

    public void autoReport() {
        if (!this.fulfilled()) {
            this.reportInvalid();
        }
    }
}

