/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerHoldsShieldEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerHoldsShieldEvent instance;
    public PlayerTag player;
    public boolean state;
    public boolean enabled = false;
    public static HashSet<UUID> raisedShields;

    public PlayerHoldsShieldEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(0).equals("player")) {
            return false;
        }
        String middleWord = path.eventArgAt(1);
        if (!(middleWord.equals("raises") || middleWord.equals("lowers") || middleWord.equals("toggles"))) {
            return false;
        }
        return path.eventArgLowerAt(2).equals("shield") || this.couldMatchItem(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        if (cmd.equals("raises") && !this.state) {
            return false;
        }
        if (cmd.equals("lowers") && this.state) {
            return false;
        }
        if (!this.runInCheck(path, this.player.getLocation())) {
            return false;
        }
        String shieldItem = path.eventArgLowerAt(2);
        if (!shieldItem.equals("shield") && !PlayerHoldsShieldEvent.tryItem(this.player.getHeldItem(), shieldItem)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerHoldsShield";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("state")) {
            return new ElementTag(this.state);
        }
        return super.getContext(name);
    }

    @Override
    public void init() {
        NetworkInterceptHelper.enable();
        this.enabled = true;
    }

    @Override
    public void destroy() {
        this.enabled = false;
    }

    public static void signalDidRaise(Player player) {
        if (raisedShields.contains(player.getUniqueId())) {
            return;
        }
        raisedShields.add(player.getUniqueId());
        PlayerHoldsShieldEvent.instance.state = true;
        PlayerHoldsShieldEvent.instance.player = new PlayerTag(player);
        PlayerHoldsShieldEvent.instance.cancelled = false;
        instance.fire();
    }

    public static void signalDidLower(Player player) {
        if (!raisedShields.remove(player.getUniqueId())) {
            return;
        }
        PlayerHoldsShieldEvent.instance.state = false;
        PlayerHoldsShieldEvent.instance.player = new PlayerTag(player);
        PlayerHoldsShieldEvent.instance.cancelled = false;
        instance.fire();
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        PlayerHoldsShieldEvent.signalDidLower(event.getPlayer());
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        PlayerHoldsShieldEvent.signalDidLower(event.getEntity());
    }

    @EventHandler
    public void onPlayerChangeItem(PlayerItemHeldEvent event) {
        PlayerHoldsShieldEvent.signalDidLower(event.getPlayer());
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        PlayerHoldsShieldEvent.signalDidLower(event.getPlayer());
    }

    static {
        raisedShields = new HashSet();
    }
}

