/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.block;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.plugin.Plugin;

public class BlockIgnitesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockIgnitesScriptEvent instance;
    public dLocation location;
    public dMaterial material;
    public dEntity entity;
    public dLocation origin_location;
    public Element cause;
    public BlockIgniteEvent event;

    public BlockIgnitesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("ignites");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String s = path.event;
        String lower = path.eventLower;
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        String mat = CoreUtilities.getXthArg(0, lower);
        return this.tryMaterial(this.material, mat);
    }

    @Override
    public String getName() {
        return "BlockIgnites";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        BlockIgniteEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("material")) {
            return this.material;
        }
        if (name.equals("entity") && this.entity != null) {
            return this.entity;
        }
        if (name.equals("origin_location") && this.origin_location != null) {
            return this.origin_location;
        }
        if (name.equals("cause")) {
            return this.cause;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockIgnites(BlockIgniteEvent event) {
        this.location = new dLocation(event.getBlock().getLocation());
        this.material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        this.entity = null;
        if (event.getIgnitingEntity() != null) {
            this.entity = new dEntity(event.getIgnitingEntity());
        }
        this.origin_location = null;
        if (event.getIgnitingBlock() != null) {
            this.origin_location = new dLocation(event.getIgnitingBlock().getLocation());
        }
        this.cause = new Element(event.getCause().toString());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

