/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.notable;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.SavableMapFlagTracker;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class NotableManager {
    public static HashMap<String, Notable> notableObjects = new HashMap();
    public static HashMap<Notable, String> reverseObjects = new HashMap();
    public static HashMap<Class, HashSet<Notable>> notesByType = new HashMap();
    private FileConfiguration notablesSave = null;
    private File notablesFile = null;
    private static Map<Class, String> objects = new HashMap<Class, String>();
    private static Map<String, Class> reverse_objects = new HashMap<String, Class>();

    public NotableManager() {
        NotableManager.registerWithNotableManager(CuboidTag.class);
        NotableManager.registerWithNotableManager(EllipsoidTag.class);
        NotableManager.registerWithNotableManager(InventoryTag.class);
        NotableManager.registerWithNotableManager(ItemTag.class);
        NotableManager.registerWithNotableManager(LocationTag.class);
        NotableManager.registerWithNotableManager(PolygonTag.class);
    }

    public static boolean isSaved(Notable object) {
        return reverseObjects.containsKey(object);
    }

    public static boolean isExactSavedObject(Notable object) {
        String id = reverseObjects.get(object);
        if (id == null) {
            return false;
        }
        return notableObjects.get(id) == object;
    }

    public static Notable getSavedObject(String id) {
        return notableObjects.get(CoreUtilities.toLowerCase(id));
    }

    public static String getSavedId(Notable object) {
        return reverseObjects.get(object);
    }

    public static void saveAs(Notable object, String id) {
        if (object == null) {
            return;
        }
        Notable noted = notableObjects.get(id = CoreUtilities.toLowerCase(id));
        if (noted != null) {
            noted.forget();
        }
        notableObjects.put(id, object);
        reverseObjects.put(object, id);
        notesByType.get(object.getClass()).add(object);
    }

    public static Notable remove(String id) {
        Notable obj = notableObjects.get(id = CoreUtilities.toLowerCase(id));
        if (obj == null) {
            return null;
        }
        notableObjects.remove(id);
        reverseObjects.remove(obj);
        notesByType.get(obj.getClass()).remove(obj);
        return obj;
    }

    public static void remove(Notable obj) {
        String id = reverseObjects.get(obj);
        notableObjects.remove(id);
        reverseObjects.remove(obj);
        notesByType.get(obj.getClass()).remove(obj);
    }

    public static <T extends Notable> Set<T> getAllType(Class<T> type) {
        return notesByType.get(type);
    }

    private static void _recallNotables() {
        notableObjects.clear();
        for (Set set : notesByType.values()) {
            set.clear();
        }
        reverseObjects.clear();
        for (String string : Denizen.getInstance().notableManager.getNotables().getKeys(false)) {
            Class clazz = reverse_objects.get(string);
            ConfigurationSection section = Denizen.getInstance().notableManager.getNotables().getConfigurationSection(string);
            if (section == null) continue;
            for (String notableRaw : section.getKeys(false)) {
                String objText;
                String notable = EscapeTagBase.unEscape(notableRaw.replace("DOT", "."));
                String flagText = null;
                if (section.isConfigurationSection(notableRaw)) {
                    objText = section.getConfigurationSection(notableRaw).getString("object");
                    flagText = section.getConfigurationSection(notableRaw).getString("flags");
                } else {
                    objText = section.getString(notableRaw);
                }
                Notable obj = (Notable)ObjectFetcher.getObjectFrom(clazz, objText, CoreUtilities.errorButNoDebugContext);
                if (obj != null) {
                    obj.makeUnique(notable);
                    if (flagText == null || !(obj instanceof FlaggableObject)) continue;
                    ((FlaggableObject)((Object)NotableManager.getSavedObject(notable))).reapplyTracker(new SavableMapFlagTracker(flagText));
                    continue;
                }
                Debug.echoError("Notable '" + notable + "' failed to load!");
            }
        }
    }

    private static void _saveNotables() {
        FileConfiguration notables = Denizen.getInstance().notableManager.getNotables();
        for (String string : notables.getKeys(false)) {
            notables.set(string, null);
        }
        for (Map.Entry entry : notableObjects.entrySet()) {
            try {
                notables.set(NotableManager.getClassId(NotableManager.getClass((Notable)entry.getValue())) + "." + EscapeTagBase.escape(CoreUtilities.toLowerCase((String)entry.getKey())), ((Notable)entry.getValue()).getSaveObject());
            }
            catch (Exception e) {
                Debug.echoError("Notable '" + (String)entry.getKey() + "' failed to save!");
                Debug.echoError(e);
            }
        }
    }

    private static <T extends Notable> Class<T> getClass(Notable notable) {
        for (Class clazz : objects.keySet()) {
            if (!clazz.isInstance(notable)) continue;
            return clazz;
        }
        return null;
    }

    public void reloadNotables() {
        if (this.notablesFile == null) {
            this.notablesFile = new File(Denizen.getInstance().getDataFolder(), "notables.yml");
        }
        this.notablesSave = YamlConfiguration.loadConfiguration((File)this.notablesFile);
        NotableManager._recallNotables();
    }

    public FileConfiguration getNotables() {
        if (this.notablesSave == null) {
            this.reloadNotables();
        }
        return this.notablesSave;
    }

    public void saveNotables() {
        if (this.notablesSave == null || this.notablesFile == null) {
            return;
        }
        try {
            NotableManager._saveNotables();
            this.notablesSave.save(this.notablesFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save to " + this.notablesFile, ex);
        }
    }

    public static void registerWithNotableManager(Class notable) {
        for (Method method : notable.getMethods()) {
            if (!method.isAnnotationPresent(Note.class)) continue;
            String note = method.getAnnotation(Note.class).value();
            objects.put(notable, note);
            reverse_objects.put(note, notable);
            notesByType.put(notable, new HashSet());
        }
    }

    public static String getClassId(Class notable) {
        return objects.get(notable);
    }

    public static Map<String, Class> getReverseClassIdMap() {
        return reverse_objects;
    }
}

